/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.util.StringTokenizer;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.debug.DebugEventListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RemoteDebugEventSocketListener
implements Runnable {
    static final int MAX_EVENT_ELEMENTS = 8;
    DebugEventListener listener;
    String machine;
    int port;
    Socket channel;
    PrintWriter out;
    BufferedReader in;
    String event;
    public String version;
    public String grammarFileName;
    int previousTokenIndex;
    boolean tokenIndexesInvalid;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void eventHandler() {
        try {
            try {
                this.handshake();
                this.event = this.in.readLine();
                while (this.event != null) {
                    this.dispatch(this.event);
                    this.ack();
                    this.event = this.in.readLine();
                }
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace(System.err);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.closeConnection();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.closeConnection();
            return;
        }
    }

    protected boolean openConnection() {
        boolean success = false;
        try {
            this.channel = new Socket(this.machine, this.port);
            this.channel.setTcpNoDelay(true);
            OutputStream os = this.channel.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os, "UTF8");
            this.out = new PrintWriter(new BufferedWriter(osw));
            InputStream is = this.channel.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, "UTF8");
            this.in = new BufferedReader(isr);
            success = true;
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return success;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void closeConnection() {
        block15: {
            try {
                try {
                    this.in.close();
                    this.in = null;
                    this.out.close();
                    this.out = null;
                    this.channel.close();
                    this.channel = null;
                }
                catch (Exception e) {
                    System.err.println(e);
                    e.printStackTrace(System.err);
                }
            }
            catch (Throwable var1_2) {
                var2_3 = null;
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException ioe) {
                        System.err.println(ioe);
                    }
                }
                if (this.out != null) {
                    this.out.close();
                }
                if (this.channel == null) throw var1_2;
                try {
                    this.channel.close();
                    throw var1_2;
                }
                catch (IOException ioe) {
                    System.err.println(ioe);
                }
                throw var1_2;
            }
            {
                var2_4 = null;
                if (this.in == null) break block15;
            }
            ** try [egrp 2[TRYBLOCK] [2 : 74->84)] { 
lbl36:
            // 1 sources

            this.in.close();
            break block15;
lbl38:
            // 1 sources

            catch (IOException ioe) {
                System.err.println(ioe);
            }
        }
        if (this.out != null) {
            this.out.close();
        }
        if (this.channel == null) return;
        try {}
        catch (IOException ioe) {
            System.err.println(ioe);
            return;
        }
        this.channel.close();
    }

    protected void handshake() throws IOException {
        String antlrLine = this.in.readLine();
        String[] antlrElements = this.getEventElements(antlrLine);
        this.version = antlrElements[1];
        String grammarLine = this.in.readLine();
        String[] grammarElements = this.getEventElements(grammarLine);
        this.grammarFileName = grammarElements[1];
        this.ack();
        this.listener.commence();
    }

    protected void ack() {
        this.out.println("ack");
        this.out.flush();
    }

    protected void dispatch(String line) {
        String[] elements = this.getEventElements(line);
        if (elements == null || elements[0] == null) {
            System.err.println("unknown debug event: " + line);
            return;
        }
        if (elements[0].equals("enterRule")) {
            this.listener.enterRule(elements[1]);
        } else if (elements[0].equals("exitRule")) {
            this.listener.exitRule(elements[1]);
        } else if (elements[0].equals("enterAlt")) {
            this.listener.enterAlt(Integer.parseInt(elements[1]));
        } else if (elements[0].equals("enterSubRule")) {
            this.listener.enterSubRule(Integer.parseInt(elements[1]));
        } else if (elements[0].equals("exitSubRule")) {
            this.listener.exitSubRule(Integer.parseInt(elements[1]));
        } else if (elements[0].equals("enterDecision")) {
            this.listener.enterDecision(Integer.parseInt(elements[1]));
        } else if (elements[0].equals("exitDecision")) {
            this.listener.exitDecision(Integer.parseInt(elements[1]));
        } else if (elements[0].equals("location")) {
            this.listener.location(Integer.parseInt(elements[1]), Integer.parseInt(elements[2]));
        } else if (elements[0].equals("consumeToken")) {
            ProxyToken t = this.deserializeToken(elements, 1);
            if (t.getTokenIndex() == this.previousTokenIndex) {
                this.tokenIndexesInvalid = true;
            }
            this.previousTokenIndex = t.getTokenIndex();
            this.listener.consumeToken(t);
        } else if (elements[0].equals("consumeHiddenToken")) {
            ProxyToken t = this.deserializeToken(elements, 1);
            if (t.getTokenIndex() == this.previousTokenIndex) {
                this.tokenIndexesInvalid = true;
            }
            this.previousTokenIndex = t.getTokenIndex();
            this.listener.consumeHiddenToken(t);
        } else if (elements[0].equals("LT")) {
            ProxyToken t = this.deserializeToken(elements, 2);
            this.listener.LT(Integer.parseInt(elements[1]), t);
        } else if (elements[0].equals("mark")) {
            this.listener.mark(Integer.parseInt(elements[1]));
        } else if (elements[0].equals("rewind")) {
            if (elements[1] != null) {
                this.listener.rewind(Integer.parseInt(elements[1]));
            } else {
                this.listener.rewind();
            }
        } else if (elements[0].equals("beginBacktrack")) {
            this.listener.beginBacktrack(Integer.parseInt(elements[1]));
        } else if (elements[0].equals("endBacktrack")) {
            int level = Integer.parseInt(elements[1]);
            int successI = Integer.parseInt(elements[2]);
            boolean bl = false;
            if (successI == 1) {
                bl = true;
            }
            this.listener.endBacktrack(level, bl);
        } else if (elements[0].equals("exception")) {
            String excName = elements[1];
            String indexS = elements[2];
            String lineS = elements[3];
            String posS = elements[4];
            Class<?> excClass = null;
            try {
                excClass = Class.forName(excName);
                RecognitionException e = (RecognitionException)excClass.newInstance();
                e.index = Integer.parseInt(indexS);
                e.line = Integer.parseInt(lineS);
                e.charPositionInLine = Integer.parseInt(posS);
                this.listener.recognitionException(e);
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println("can't find class " + cnfe);
                cnfe.printStackTrace(System.err);
            }
            catch (InstantiationException ie) {
                System.err.println("can't instantiate class " + ie);
                ie.printStackTrace(System.err);
            }
            catch (IllegalAccessException iae) {
                System.err.println("can't access class " + iae);
                iae.printStackTrace(System.err);
            }
        } else if (elements[0].equals("beginResync")) {
            this.listener.beginResync();
        } else if (elements[0].equals("endResync")) {
            this.listener.endResync();
        } else if (elements[0].equals("terminate")) {
            this.listener.terminate();
        } else if (elements[0].equals("semanticPredicate")) {
            Boolean result = Boolean.valueOf(elements[1]);
            String predicateText = elements[2];
            predicateText = this.unEscapeNewlines(predicateText);
            this.listener.semanticPredicate(result, predicateText);
        } else if (elements[0].equals("consumeNode")) {
            String tokenText = elements[3];
            tokenText = this.unEscapeNewlines(tokenText);
            this.listener.consumeNode(Integer.parseInt(elements[1]), tokenText, Integer.parseInt(elements[2]));
        } else if (elements[0].equals("LN")) {
            String tokenText = elements[4];
            tokenText = this.unEscapeNewlines(tokenText);
            this.listener.LT(Integer.parseInt(elements[1]), Integer.parseInt(elements[2]), tokenText, Integer.parseInt(elements[3]));
        } else if (elements[0].equals("createNodeFromToken")) {
            String tokenText = elements[3];
            tokenText = this.unEscapeNewlines(tokenText);
            this.listener.createNode(Integer.parseInt(elements[1]), tokenText, Integer.parseInt(elements[2]));
        } else if (elements[0].equals("createNode")) {
            this.listener.createNode(Integer.parseInt(elements[1]), Integer.parseInt(elements[2]));
        } else if (elements[0].equals("nilNode")) {
            this.listener.nilNode(Integer.parseInt(elements[1]));
        } else if (elements[0].equals("becomeRoot")) {
            this.listener.becomeRoot(Integer.parseInt(elements[1]), Integer.parseInt(elements[2]));
        } else if (elements[0].equals("addChild")) {
            this.listener.addChild(Integer.parseInt(elements[1]), Integer.parseInt(elements[2]));
        } else if (elements[0].equals("setTokenBoundaries")) {
            this.listener.setTokenBoundaries(Integer.parseInt(elements[1]), Integer.parseInt(elements[2]), Integer.parseInt(elements[3]));
        } else {
            System.err.println("unknown debug event: " + line);
        }
    }

    protected ProxyToken deserializeToken(String[] elements, int offset) {
        String indexS = elements[offset];
        String typeS = elements[offset + 1];
        String channelS = elements[offset + 2];
        String lineS = elements[offset + 3];
        String posS = elements[offset + 4];
        String text = elements[offset + 5];
        text = this.unEscapeNewlines(text);
        int index = Integer.parseInt(indexS);
        ProxyToken t = new ProxyToken(index, Integer.parseInt(typeS), Integer.parseInt(channelS), Integer.parseInt(lineS), Integer.parseInt(posS), text);
        return t;
    }

    public void start() {
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        this.eventHandler();
    }

    public String[] getEventElements(String event) {
        if (event == null) {
            return null;
        }
        String[] elements = new String[8];
        String str = null;
        try {
            int firstQuoteIndex = event.indexOf(34);
            if (firstQuoteIndex >= 0) {
                String eventWithoutString = event.substring(0, firstQuoteIndex);
                str = event.substring(firstQuoteIndex + 1, event.length());
                event = eventWithoutString;
            }
            StringTokenizer st = new StringTokenizer(event, " \t", false);
            int i = 0;
            while (st.hasMoreTokens()) {
                elements[i] = st.nextToken();
                ++i;
            }
            if (str != null) {
                elements[i] = str;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return elements;
    }

    protected String unEscapeNewlines(String txt) {
        txt = txt.replaceAll("%0A", "\n");
        txt = txt.replaceAll("%0D", "\r");
        txt = txt.replaceAll("%25", "%");
        return txt;
    }

    public boolean tokenIndexesAreInvalid() {
        return false;
    }

    private final /* synthetic */ void this() {
        this.channel = null;
        this.previousTokenIndex = -1;
        this.tokenIndexesInvalid = false;
    }

    public RemoteDebugEventSocketListener(DebugEventListener listener, String machine, int port) throws IOException {
        this.this();
        this.listener = listener;
        this.machine = machine;
        this.port = port;
        if (!this.openConnection()) {
            throw new ConnectException();
        }
    }

    public static class ProxyToken
    implements Token {
        int index;
        int type;
        int channel;
        int line;
        int charPos;
        String text;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int ttype) {
            this.type = ttype;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public int getCharPositionInLine() {
            return this.charPos;
        }

        public void setCharPositionInLine(int pos) {
            this.charPos = pos;
        }

        public int getChannel() {
            return this.channel;
        }

        public void setChannel(int channel) {
            this.channel = channel;
        }

        public int getTokenIndex() {
            return this.index;
        }

        public void setTokenIndex(int index) {
            this.index = index;
        }

        public String toString() {
            String channelStr = "";
            if (this.channel > 0) {
                channelStr = ",channel=" + this.channel;
            }
            return "[" + this.getText() + "/<" + this.type + '>' + channelStr + ',' + this.line + ':' + this.getCharPositionInLine() + ']';
        }

        public ProxyToken(int index, int type, int channel, int line, int charPos, String text) {
            this.index = index;
            this.type = type;
            this.channel = channel;
            this.line = line;
            this.charPos = charPos;
            this.text = text;
        }
    }
}

