       subroutine sum_paths(idata, iupath, nxpath, nqmax,
     $      ckreal, ckimag,pdftot)
c
c//////////////////////////////////////////////////////////////////////
c Copyright (c) 1997--2000 Matthew Newville, The University of Chicago
c Copyright (c) 1992--1996 Matthew Newville, University of Washington
c
c Permission to use and redistribute the source code or binary forms of
c this software and its documentation, with or without modification is
c hereby granted provided that the above notice of copyright, these
c terms of use, and the disclaimer of warranty below appear in the
c source code and documentation, and that none of the names of The
c University of Chicago, The University of Washington, or the authors
c appear in advertising or endorsement of works derived from this
c software without specific prior written permission from all parties.
c
c THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
c EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
c MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
c IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
c CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
c TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
c SOFTWARE OR THE USE OR OTHER DEALINGS IN THIS SOFTWARE.
c//////////////////////////////////////////////////////////////////////
c 
c  sum-over-paths for a particular data set, returning 
c      real and imaginary parts of chi(k)
c     used by iff_ff2chi and fitfun
c
       implicit none
       include 'consts.h'
       integer       idata, i, ip, nqmax, xafs_path, ret
       integer       nxpath, iupath(mpaths)
       double precision  xdsave, xtmp, getsca, reff
       double precision  ckreal(maxpts), ckimag(maxpts), pdftot(maxpts)
       double precision  tmpi(maxpts), tmpr(maxpts),tmpp(maxpts)
       external    getsca, xafs_path

       do 25 i = 1, maxpts
          ckreal(i)  = zero
          ckimag(i)  = zero
          pdftot(i)  = zero
          tmpi(i)    = zero
          tmpr(i)    = zero
          tmpp(i)    = zero
 25    continue
       xdsave = getsca('data_set',0)
       xtmp   = one*max(1,min(mdata,idata))
       call setsca('data_set',  xtmp)
cc       print*, 'sum paths data_set', xtmp
       do 1000 ip = 1, nxpath
          ret = xafs_path(iupath(ip), tmpr, tmpi, tmpp, reff)
cc          print*, ' path ', ip, iupath(ip), ret, reff
          if (ret .eq. 1) then
c  add this to the other paths
             do 850 i = 1, nqmax
                ckreal(i) = ckreal(i) + tmpr(i)
                ckimag(i) = ckimag(i) + tmpi(i)
 850         continue
             do 860 i = 1, maxpts
                pdftot(i) = pdftot(i) + tmpp(i)
 860         continue 
c          else 
c             print*, 'sum over paths: path not used: ',
c     $            ip, iupath(ip)
          endif
 1000  continue
c now return previous the previous 'user variables'
       call setsca('data_set',  xdsave)
       return
       end

       integer function xafs_path(ipath,chi_r, chi_i,pdf, reff)
c
c  calculate xafs for a single path 
c  ipath =  'user path index' 
c  idata =  'data set'
c  reff <= 0. on output means path isn't defined.
c
       implicit none
       include 'consts.h'
       include 'keywrd.h'
       include 'arrays.h'
       include 'fefdat.h'
       include 'feffit.h'
       include 'pthpar.h'
       save
       integer ipath, i, j, k, inpath, nqmax, jfeff
       integer u2ipth, ntmp, nkpar, icode(micode)
       double precision reff, degen, xtmp, getsca, ent
       double precision rstep, r0, ss2, drx, pdf(maxpts)
       double precision chi_r(maxpts),chi_i(maxpts)
       double precision tpakar(maxpts)
       double precision tpaamp(maxpts),tpapha(maxpts)
       external         u2ipth, getsca

       reff      = -one
       xafs_path = 0

       do 25 i = 1, maxpts
          chi_r(i)  = zero
          chi_i(i)  = zero
          pdf(i)    = zero
          tpapha(i) = zero
          tpakar(i) = (i-1)*qgrid
          tpaamp(i) = one
 25    continue

       inpath    = u2ipth(ipath)
cc       print*, ' xafs path ', ipath, u2ipth(ipath)
       if (inpath.le.0) return
       if (jpthff(inpath).le.0) then
          write(tmpstr,'(1x,a,i5)') ' no FEFF file for path ', ipath
          call warn(2,tmpstr)
          return
       else
          jfeff = jpthff(inpath)
          reff  = refpth(jfeff)
          degen = degpth(jfeff)
          xtmp  = ipath
          call setsca('path_index', xtmp)
          call setsca('degen', degen)
          call setsca('reff',  reff)
       endif
       call synvar
c      
c path OK to use
       xafs_path = 1
       nkpar     = 0

c loop over path parameters to evaluate
       do 500 i = 1, mpthpr
c
c set default path params here
          tmparr(1) = zero
          if (i.eq.jfps02)  then
             tmparr(1) = one
          elseif (i.eq.jfpdeg) then
             tmparr(1) = degpth(jfeff)
          endif
          ntmp = 0
          do 420 k = 1, micode
             icode(k)  = icdpar(k,i,inpath)
 420      continue 
          if (iprint.ge.12)
     $          call rpndmp(icode)
c  evaluate parameter if it was defined
          if (icode(1).ne.0) then
             call decod(icode, micode, 
     $            consts, scalar, array, narray, nparr, 
     $            maxsize_array, maxarr,  ntmp, tmparr)
          end if
c
c set the param value from tmparr:
          param(i) = tmparr(1)
          if (i.eq.jfpkar) then
             if (nkpar.gt.0)  nkpar = min(nkpar, ntmp)
             if (nkpar.eq.0)  nkpar = ntmp
             do 470 j = 1, ntmp
                tpakar(j) = tmparr(j)
 470         continue 
          elseif (i.eq.jfpaar) then
             if (nkpar.gt.0)  nkpar = min(nkpar, ntmp)
             if (nkpar.eq.0)  nkpar = ntmp
             do 480 j = 1, ntmp
                tpaamp(j) = tmparr(j)
 480         continue 
          elseif (i.eq.jfppar) then
             if (nkpar.gt.0)  nkpar = min(nkpar, ntmp)
             if (nkpar.eq.0)  nkpar = ntmp
             do 490 j = 1, ntmp
                tpapha(j) = tmparr(j)
 490         continue 
          endif
 500   continue

c   get chi(k) for this path from feff and path parameters
c
       if ( (inpath.gt.0).and.(jfeff.gt.0))  then
          if (iprint.ge.9) then
             call echo('calling chipth:')
          endif
          
          call chipth(theamp(1,jfeff), thepha(1,jfeff),
     $         qfeff(1,jfeff), xlamb(1,jfeff), realp(1,jfeff),
     $         nffpts(jfeff), reff, nkpar, tpakar, tpaamp, tpapha,
     $         maxpts, chi_r, chi_i)
          
c 
c   generate pdf for this path from path parameters
          if (nlgpth(jfeff) .le. 2) then
             r0  = refpth(jfeff) + param(jfpdr)

             degen = degpth(jfeff)*param(jfps02)/(sqrt(2*pi*abs(ss2)))
             
             ss2 = param(jfpss2)
c   handle the case of sigma2 near 0.0
             if (sqrt(abs(ss2)).le. pdf_dr*0.25 ) then
                ss2  = pdf_dr*pdf_dr * sign(1.d0,ss2)/16.d0
                degen= 100 * degen
             endif

             ent = zero
             do 810 i = 1, maxpts
                drx = pdf_dr*(i-1) - r0
                pdf(i) = degen * exp(-0.5d0*drx*drx/ss2) 
                ent = ent + pdf(i)*log(pdf(i)+1.e-18)
 810         continue 
             print*,'   sum path ', degen, r0, ss2, -ent
          endif 
       endif

       return
       end
