/*
	GXAnim : A GTK frontend to XAnim
	by Robert Warren
	(c) 1999

	This program is covered under the General Public License.
	See COPYING file for licensing information.
	
	===============================================

	windows.h

	window defines

*/

typedef struct win1 {

	gint context_id;			/* context id for statbar */

	GtkWidget *window;			/* window main */
	GtkWidget *lefttable;		/* 4x2 table of control buttons */
	GtkWidget *rightbox;		/* prefs/exit buttons */
	GtkWidget *righttable;

	GtkWidget *playbtn;			/* play */
	GtkWidget *stopbtn;			/* stop */
	GtkWidget *forwardbtn;		/* forward */
	GtkWidget *backbtn;			/* back */
	
	GtkWidget *mutebtn;			/* mute */
	GtkWidget *pausebtn;		/* pause */
	GtkWidget *restartbtn;		/* restart */
	GtkWidget *aboutbtn;		/* about */

	GtkWidget *nameentry;		/* filename entry field */
	GtkWidget *statbar;			/* status bar */
	GtkWidget *statbox;

	GtkWidget *vollabel;
	GtkObject *voladjust;		/* volume adjustment */
	GtkWidget *volumebar;		/* volume bar */

	GtkWidget *dbfbtn;			/* database button */
	GtkWidget *filebutton;		/* "find" button */
	GtkWidget *prefbtn;			/* preferences btn */
	GtkWidget *quitbtn;			/* quit GXanim */

	GtkWidget *vertbox;	
	GtkWidget *hbox1;
	GtkWidget *hbox2;
	GtkWidget *hbox3;

	GtkTooltips *playtip;
	GtkTooltips *stoptip;
	GtkTooltips *backtip;
	GtkTooltips *forwardtip;
	GtkTooltips *volumetip;
	GtkTooltips *opentip;
	GtkTooltips *abouttip;
	GtkTooltips *mutetip;
	GtkTooltips *pausetip;
	GtkTooltips *prefstip;
	GtkTooltips *exittip;

	GList *history_list;
	GtkWidget *combo;

} main_win;


typedef struct win2 {

	GtkWidget *window;
	GtkWidget *vertbox;
	
	GtkWidget *hbox1;
	GtkWidget *hbox2;
	GtkWidget *hbox3;
	GtkWidget *hbox4;
	GtkWidget *hbox5;
	GtkWidget *hbox6;
	GtkWidget *hbox7;
	GtkWidget *hbox8;

	GtkWidget *hsep1;
	GtkWidget *hsep2;
	GtkWidget *hsep3;
	GtkWidget *hsep4;
	GtkWidget *hsep5;

	GtkWidget *label4; 		/* "Scaling" */
	GtkObject *scaleadj;	/* Scaling Adjustor */
	GtkWidget *scalebar;	/* Scaling Bar */

	GtkWidget *label6; 		/* "Gamma Correction" */
	GtkObject *gammaadj; 	/* Gamma Adjustor */
	GtkWidget *gammabar; 	/* Gamma Bar */
	
	GtkWidget *vbox2;
	GtkWidget *vbox3;
	GtkWidget *vbox4;
	GtkWidget *vbox5;

	GtkWidget *holdbox;		/* "Hold on end?" check button */
	GtkWidget *syncbox; 	/* "Sync Frame? " */
	GtkWidget *floydbox; 	/* "Floyd-Steinberg?" */
	GtkWidget *playbox; 	/* "Play on Start?" */
	GtkWidget *verbbox; 	/* "Verbose Mode?" */
 	
	GtkWidget *label7; 		/* XAnim Binary */
	GtkWidget *binentry; 	/* XAnim Binary text entry */

	GtkWidget *label8; 		/* Default Directory */
	GtkWidget *direntry; 	/* defdir text entry */

	GtkWidget *defaultbtn;
	GtkWidget *applybtn;
	GtkWidget *savebtn;
	GtkWidget *okbtn;

} prefs_win;


typedef struct win3 {

	GtkWidget *window;
	GtkWidget *vertbox;

	GtkWidget *hsep1; 		/* h seperator */
	GtkWidget *hsep2;
	GtkWidget *hsep3;

	GtkWidget *label1;
	GtkWidget *label2;
	GtkWidget *label3;
	GtkWidget *label4;
	GtkWidget *label5;

	GtkWidget *label6; 		/* "Currently Playing" */
	GtkWidget *label7; 		/* movie name */
	GtkWidget *label8; 		/* movie type */

	GtkWidget *okbtn;

} about_win;

typedef struct win4 {
	GtkWidget *window;
	GtkWidget *vertbox;
	GtkWidget *screen;
} screen_win;