/* $Revision: 1.2 $ */
/*
 * "gpgp" Gnome/GTK Front for PGP
 * Copyright (C) 1998  Max Valianskiy
 * Copyright (C) 1999 tftp@netscape.net
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */
#include "../config.h"
#include "../version.h"

#include <gnome.h>
#include <string.h>

#include "gpgp.h"

struct gpgp_options gpgp_options;

void gpgp_init(GnomeApp* app, int use_status)
{
    char buf[1000];
    char* pgppath = getenv(ENV_GNUPGHOME);
  
    if (!pgppath) 
        pgppath=gnome_util_prepend_user_home(DIR_GNUPGHOME);

    gpgp_options.app=app;
    gpgp_options.use_status=use_status;

    /* add "/" at end */
    gpgp_options.pgppath=g_malloc(strlen(pgppath)+2);
    strcpy(gpgp_options.pgppath, pgppath);
    strcat(gpgp_options.pgppath, "/");

    /* now let GNOME rule */

    g_snprintf(buf,sizeof(buf), "%s=%s", GPGP_OPTIONS_FILE "pgppath", gpgp_options.pgppath);
    gpgp_options.pgppath=gnome_config_get_string(buf);

    /* now we have new pgppath */
    g_snprintf(buf,sizeof(buf), "%s%s",
               gpgp_options.pgppath, DEF_PUBRING_FILE);
    gpgp_options.defpub = strdup(buf);
    g_snprintf(buf,sizeof(buf), "%s%s",
               gpgp_options.pgppath, DEF_SECRING_FILE);
    gpgp_options.defsec = strdup(buf);
    gpgp_options.defkey = "";

    /* other options */
    g_snprintf(buf,sizeof(buf), "%s=%s", GPGP_OPTIONS_FILE "Default Public Keyring", gpgp_options.defpub);
    gpgp_options.defpub=gnome_config_get_string(buf); 
  
    g_snprintf(buf,sizeof(buf), "%s=%s", GPGP_OPTIONS_FILE "Defailt Secret Keyring", gpgp_options.defsec);
    gpgp_options.defsec=gnome_config_get_string(buf); 
  
    g_snprintf(buf,sizeof(buf), "%s=%s", GPGP_OPTIONS_FILE "Default Secret Key", gpgp_options.defkey);
    gpgp_options.defkey=gnome_config_get_string(buf); 

    gpgp_options.cipher="";
    g_snprintf(buf,sizeof(buf), "%s=%s", GPGP_OPTIONS_FILE "Cipher", gpgp_options.cipher);
    gpgp_options.cipher=gnome_config_get_string(buf); 

    gpgp_options.pubkey="";
    g_snprintf(buf,sizeof(buf), "%s=%s", GPGP_OPTIONS_FILE "Pubkey", gpgp_options.pubkey);
    gpgp_options.pubkey=gnome_config_get_string(buf); 

    gpgp_options.digest="";
    g_snprintf(buf,sizeof(buf), "%s=%s", GPGP_OPTIONS_FILE "Pubkey", gpgp_options.digest);
    gpgp_options.digest=gnome_config_get_string(buf); 

    gpgp_options.sign_verbose = TRUE;
    g_snprintf(buf,sizeof(buf), "%s=%s", GPGP_OPTIONS_FILE "Sign Verbose", "true");
    gpgp_options.sign_verbose=gnome_config_get_bool(buf); 

    gpgp_options.unsign_verbose = TRUE;
    g_snprintf(buf,sizeof(buf), "%s=%s", GPGP_OPTIONS_FILE "UnSign Verbose", "true");
    gpgp_options.unsign_verbose=gnome_config_get_bool(buf); 

    gpgp_options.rfc1991 = FALSE;
    g_snprintf(buf,sizeof(buf), "%s=%s", GPGP_OPTIONS_FILE "RFC1991", "false");
    gpgp_options.rfc1991=gnome_config_get_bool(buf); 

    gpgp_options.comment = TRUE;
    g_snprintf(buf,sizeof(buf), "%s=%s", GPGP_OPTIONS_FILE "Comment Packet", "true");
    gpgp_options.comment=gnome_config_get_bool(buf); 
 
    gpgp_options.completes_need = 1;
    g_snprintf(buf,sizeof(buf), "%s=%d", GPGP_OPTIONS_FILE "Completes Need", gpgp_options.completes_need);
    gpgp_options.completes_need=gnome_config_get_int(buf); 
  
    gpgp_options.marginals_need = 3;
    g_snprintf(buf,sizeof(buf), "%s=%d", GPGP_OPTIONS_FILE "Marginals Need", gpgp_options.marginals_need);
    gpgp_options.marginals_need=gnome_config_get_int(buf); 

    gpgp_options.compress = 2;
    g_snprintf(buf,sizeof(buf), "%s=%d", GPGP_OPTIONS_FILE "Compress", gpgp_options.compress);
    gpgp_options.compress=gnome_config_get_int(buf); 

    gpgp_options.compresslevel = 6;
    g_snprintf(buf,sizeof(buf), "%s=%d", GPGP_OPTIONS_FILE "Compress Level", gpgp_options.compress);
    gpgp_options.compresslevel=gnome_config_get_int(buf); 

    gpgp_options.optstring = NULL;

    update_gpgp_options();
}
