/*
 * BackupEnvironment.java
 *
 * Created on December 19, 2003, 10:11 PM
 */

package com.sun.enterprise.config.backup.pluggable;

/**
 * BackupEnvironment Interface holds all the environment
 * information about the functionality. In particular, 
 * source and destination paths, number of backups, etc.
 *
 * Implementation of this interface can be of different
 * types. Implementation can read from properties file
 * or allow users to set it explicitly or pass it in 
 * as environment variables. There is no restriction
 * to making this interface dynamic but it is advised 
 * to make the implementation final to avoid complexity.
 *
 * To aid the above point, this interface is designed 
 * as READ ONLY and has only getters. 
 *
 * @author  sridatta
 */
public interface BackupEnvironment {

    // Methods related to Execution Environment
    
    /* 
     * Can be offline or Online as defined
     * in StatusConstants
     */    
    String getExecutionType();
    
    /**
     * Keeps backups upto max backups. After that many backups,
     * oldest backup is deleted.
     */
    int getMaxBackups();
    int getMaxSnapShots();
    
    /**
     * Type of storage like directory, zip, etc
     */
    String getBackupStorageType();
    
    // Relative path Names or name prefixes
    
    /**
     * name of the snapshot file
     * Timestamp is added to this prefix
     */
    String getSnapshotFileNamePrefix();
    
    
    /**
     * prefix to be used for backup files
     * timestamp and the backup number is
     * added to this prefix
     */
    String getBackupFileNamePrefix();
    
    /**
     * Name of the history file
     */
    String getBackupHistoryFileName();
    
    
    
    // location Methods
     
    /**
     * directories on which backup and 
     * restore action is performed. 
     * Note that the directories are
     * absolute paths.
     */
    String[] getDirectoriesToBackup();
    
    /**
     * Get the absolute directory where backup 
     * files are to be stored
     */
    String getDirectoryToStoreBackupFiles ();
    
    /**
     * get the absolute directory where snapshot file 
     * is to be stored. This can be different from the 
     * directory where backup files are stored
     */
    String getDirectoryToStoreSnapshotFile();    
    
    /**
     * get the absolute Directory where history file 
     * is stored
     */
    String getDirectoryToStoreHistoryFile();
    
    /**
     * name of the status info file that is added to backed
     * up storage
     */
    String getStatusInfoFileName();
}
