
import java.sql.*;


/**
 * Test all the SQLServer datatypes in Statement and PreparedStatement
 *
 */
public class t0030
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException
   {
      System.out.println("Test the datatypes given by ResultSetMetaData");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      boolean     passed   = true;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();
      ResultSet   rs;


      String sql = ("select " + 
                    " convert(tinyint, 2),  " + 
                    " convert(smallint, 5)  ");

      rs = stmt.executeQuery(sql);
      if (!rs.next())
      {
         passed = false;
      }
      else
      {
         ResultSetMetaData meta = rs.getMetaData();

         if (meta.getColumnType(1)!=java.sql.Types.TINYINT)
         {
            System.out.println("tinyint column was read as " 
                               + meta.getColumnType(1));
            passed = false;
         }
         if (meta.getColumnType(2)!=java.sql.Types.SMALLINT)
         {
            System.out.println("smallint column was read as " 
                               + meta.getColumnType(2));
            passed = false;
         }
         if (rs.getInt(1) != 2)
         {
            System.out.println("Bogus value read for tinyint");
            passed = false;
         }
         if (rs.getInt(2) != 5)
         {
            System.out.println("Bogus value read for smallint");
            passed = false;
         }
      }
         
      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0030.\n");
      System.exit(passed ? 0 : 1);
   }
}

