
import java.lang.reflect.*;
import java.sql.*;
import java.io.*;


/**
 * test ResultSet.getXXStream
 */
public class t0052
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException,
      java.lang.Exception
   {
      boolean passed = true;

      // ugly, I know
      byte[] image = {
          (byte)0x47, (byte)0x49, (byte)0x46, (byte)0x38, 
          (byte)0x39, (byte)0x61, (byte)0x0A, (byte)0x00,
          (byte)0x0A, (byte)0x00, (byte)0x80, (byte)0xFF, 
          (byte)0x00, (byte)0xD7, (byte)0x3D, (byte)0x1B,
          (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x2C, 
          (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00,
          (byte)0x0A, (byte)0x00, (byte)0x0A, (byte)0x00, 
          (byte)0x00, (byte)0x02, (byte)0x08, (byte)0x84,
          (byte)0x8F, (byte)0xA9, (byte)0xCB, (byte)0xED, 
          (byte)0x0F, (byte)0x63, (byte)0x2B, (byte)0x00,
          (byte)0x3B,
      };

      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();

      try
      {
         stmt.executeUpdate("drop table t0052");
      }
      catch (SQLException e)
      {
      }

      try
      {
          String sql =
              "create table t0052 (                                  " +
              " myvarchar                varchar(2000) not null,     " +
              " myvarbinary              varbinary(2000) not null)   ";

          stmt.executeUpdate(sql);

          sql =
              "insert into t0052               " +
              "  (myvarchar,                   " +
              "   myvarbinary)                 " +
              " values                         " +
              "  (\'This is a test with german umlauts \', " +
              "   0x4749463839610A000A0080FF00D73D1B0000002C000000000A000A00000208848FA9CBED0F632B003B" +
              "  )";
          stmt.executeUpdate(sql);

          sql = "select * from t0052";
          ResultSet rs = stmt.executeQuery(sql);
          if (!rs.next())
              {
                  passed = false;
              }
          else
              {
                  System.out.println("Testing getAsciiStream()");
                  InputStream in = rs.getAsciiStream("myvarchar");
                  String expect = "This is a test with german umlauts ???";
                  byte[] toRead = new byte[expect.length()];
                  count = in.read(toRead);
                  if (count == expect.length()) {
                      for (i=0; i<expect.length(); i++) {
                          if (expect.charAt(i) != toRead[i]) {
                              passed = false;
                              System.out.println("Expected "+expect.charAt(i)
                                                 + " but was "
                                                 + toRead[i]);
                          }
                      }
                  } else {
                      passed = false;
                      System.out.println("Premature end in "
                                         + "getAsciiStream(\"myvarchar\") "
                                         + count + " instead of "
                                         + expect.length());
                  }
                  in.close();

                  in = rs.getAsciiStream(2);
                  toRead = new byte[41];
                  count = in.read(toRead);
                  if (count == 41) {
                      for (i=0; i<41; i++) {
                          if (toRead[i] != (toRead[i] & 0x7F)) {
                              passed = false;
                              System.out.println("Non ASCII characters in getAsciiStream");
                              break;
                          }
                      }
                  } else {
                      passed = false;
                      System.out.println("Premature end in getAsciiStream(1) "
                                         +count+" instead of 41");
                  }
                  in.close();

                  System.out.println("Testing getUnicodeStream()");
                  in = rs.getUnicodeStream("myvarchar");
                  Reader reader = new InputStreamReader(in, "UTF8");
                  expect = "This is a test with german umlauts ";
                  char[] charsToRead = new char[expect.length()];
                  count = reader.read(charsToRead, 0, expect.length());
                  if (count == expect.length()) {
                      String result = new String(charsToRead);
                      if (!expect.equals(result)) {
                          passed = false;
                          System.out.println("Expected "+ expect
                                             + " but was " + result);
                      }
                  } else {
                      passed = false;
                      System.out.println("Premature end in "
                                         + "getUnicodeStream(\"myvarchar\") "
                                         + count + " instead of "
                                         + expect.length());
                  } 
                  reader.close();

                  /* Cannot think of a meaningfull test */
                  in = rs.getUnicodeStream(2);
                  in.close();

                  System.out.println("Testing getBinaryStream()");

                  /* Cannot think of a meaningfull test */
                  in = rs.getBinaryStream("myvarchar");
                  in.close();

                  in = rs.getBinaryStream(2);
                  count = 0;
                  toRead = new byte[image.length];
                  do {
                      int actuallyRead = in.read(toRead, count, 
                                                 image.length-count);
                      if (actuallyRead == -1) {
                          passed = false;
                          System.out.println("Premature end in "
                                             +" getBinaryStream(2) "
                                             + count +" instead of "
                                             + image.length);
                          break;
                      }
                      count += actuallyRead;
                  } while (count < image.length);

                  for (i=0; i<count; i++) {
                      if (toRead[i] != image[i]) {
                          passed = false;
                          System.out.println("Expected "+toRead[i]
                                             + "but was "+image[i]);
                          break;
                      }
                  }
                  in.close();

                  System.out.println("Testing getCharacterStream()");
                  try {
                      Method getCharacterStreamString = 
                          ResultSet.class.getMethod("getCharacterStream", 
                                                    new Class[] {String.class});
                      Method getCharacterStreamInt = 
                          ResultSet.class.getMethod("getCharacterStream", 
                                                    new Class[] {Integer.TYPE});

                      reader = 
                          (Reader)getCharacterStreamString.invoke(rs,
                                                                  new Object[] {"myvarchar"});
                      expect = "This is a test with german umlauts ";
                      charsToRead = new char[expect.length()];
                      count = reader.read(charsToRead, 0, expect.length());
                      if (count == expect.length()) {
                          String result = new String(charsToRead);
                          if (!expect.equals(result)) {
                              passed = false;
                              System.out.println("Expected "+ expect
                                                 + " but was " + result);
                          }
                      } else {
                          passed = false;
                          System.out.println("Premature end in "
                                             + "getCharacterStream(\"myvarchar\") "
                                             + count + " instead of "
                                             + expect.length());
                      } 
                      reader.close();

                      /* Cannot think of a meaningfull test */
                      reader = 
                          (Reader)getCharacterStreamInt.invoke(rs, 
                                                               new Object[] {new Integer(2)});
                      reader.close();
                  } catch (NoSuchMethodException e) {
                      System.out.println("JDBC 2 only");
                  } catch (Throwable t) {
                      passed = false;
                      System.out.println("Exception: "+t.getMessage());
                  }
              }
          rs.close();
          
      }
      catch(java.sql.SQLException e)
      {
         passed = false;
         System.out.println("Exception caught.  " + e.getMessage());
         e.printStackTrace();
      }

      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0052.\n");
      System.exit(passed ? 0 : 1);
   }
}

