 

import java.sql.*;


/**
 * test what happens when you forget to set a parameter
 *
 */
public class t0016
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, java.lang.Exception
   {
      System.out.println("test what happens when you forget to set a parameter");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();
      boolean     passed   = true;
      boolean     tmpPassed;

      try
      {
         stmt.executeUpdate("drop table t0016");
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0016', because it does")))
         {
            throw e;
         }
      }
      
      count = stmt.executeUpdate("create table t0016              "
                                 + "  (i  integer  not null,      "
                                 + "   s  char(10) not null)      ");
      System.out.println("Creating table affected " + count + " rows");
      
      stmt = cx.createStatement();
         
      
      final int rowsToAdd = 20;
      count = 0;
      for(i=1; i<=rowsToAdd; i++)
      {
         String sql = "insert into t0016 values (" + i + ", 'row" + i + "')";
         count += stmt.executeUpdate(sql);
      }
      
      PreparedStatement   pStmt = cx.prepareStatement(
         "select s from t0016 where i=? and s=?");
      ResultSet           rs;

      // see what happens if neither is set
      try
      {
         tmpPassed = false;
         rs = pStmt.executeQuery();
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().equals("parameter #1 has not been set")
                || e.getMessage().equals("parameter #2 has not been set")))
         {
            throw e;
         }
         tmpPassed = true;
      }  
      passed = passed && tmpPassed;

      pStmt.clearParameters();
      try
      {
         tmpPassed = false;
         pStmt.setInt(1, 7);
         pStmt.setString(2, "row7");
         pStmt.clearParameters();
         rs = pStmt.executeQuery();
      }
      catch (SQLException e)
      {
         if (! (e.getMessage().equals("parameter #1 has not been set")
                || e.getMessage().equals("parameter #2 has not been set")))
         {
            throw e;
         }
         tmpPassed = true;
      }   
      passed = passed && tmpPassed;

      pStmt.clearParameters();
      try
      {
         tmpPassed = false;
         pStmt.setInt(1, 7);
         rs = pStmt.executeQuery();
      }
      catch (SQLException e)
      {
         if (! e.getMessage().equals("parameter #2 has not been set"))
         {
            throw e;
         }
         tmpPassed = true;
      }  
      passed = passed && tmpPassed;

      pStmt.clearParameters();
      try
      {
         tmpPassed = false;
         pStmt.setString(2, "row7");
         rs = pStmt.executeQuery();
      }
      catch (SQLException e)
      {
         if (! e.getMessage().equals("parameter #1 has not been set"))
         {
            throw e;
         }
         tmpPassed = true;
      }  
      passed = passed && tmpPassed;

      System.out.println("\n" +(passed ? "Passed" : "failed") 
                         + " t0016.\n");
      System.exit(passed ? 0 : 1);
   }
}

