/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.xml.scanner;

import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.InputBuffer;
import org.apache.batik.util.XMLUtilities;
import org.apache.batik.xml.scanner.LexicalException;

public class AbstractScanner
implements Localizable {
    public static final String BUNDLE_CLASSNAME = "org.apache.batik.xml.scanner.resources.Messages";
    protected LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.xml.scanner.resources.Messages");
    protected InputBuffer inputBuffer;
    protected char[] buffer = new char[4096];
    protected char[] value;
    protected int type;
    protected boolean lastFragment;

    protected AbstractScanner(Reader reader) throws LexicalException {
        try {
            this.inputBuffer = new InputBuffer(reader);
            this.inputBuffer.setMark();
        }
        catch (IOException iOException) {
            throw this.createException(iOException.getLocalizedMessage());
        }
    }

    public void setLocale(Locale locale) {
        this.localizableSupport.setLocale(locale);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string, objectArray);
    }

    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    public int currentType() {
        return this.type;
    }

    /*
     * Unable to fully structure code
     */
    protected int readIdentifier(String var1_1, int var2_2, int var3_3) throws IOException, LexicalException {
        var4_4 = var1_1.length();
        var5_5 = 0;
        while (var5_5 < var4_4) {
            block2: {
                var6_6 = this.inputBuffer.next();
                if (var6_6 == var1_1.charAt(var5_5)) break block2;
                if (var3_3 != -1) ** GOTO lbl9
                throw this.createException("character");
lbl-1000:
                // 1 sources

                {
                    var6_6 = this.inputBuffer.next();
lbl9:
                    // 2 sources

                    ** while (var6_6 != -1 && XMLUtilities.isXMLNameCharacter((char)((char)var6_6)))
                }
lbl10:
                // 1 sources

                this.type = var3_3;
                return this.type;
            }
            ++var5_5;
        }
        this.inputBuffer.next();
        this.type = var2_2;
        return this.type;
    }

    protected int readName(int n) throws IOException, LexicalException {
        this.inputBuffer.resetMark();
        int n2 = this.inputBuffer.current();
        if (n2 == -1) {
            throw this.createException("eof");
        }
        if (!XMLUtilities.isXMLNameFirstCharacter((char)n2)) {
            throw this.createException("name");
        }
        while ((n2 = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n2)) {
        }
        this.type = n;
        return this.type;
    }

    /*
     * Unable to fully structure code
     */
    protected int readNmtoken() throws IOException, LexicalException {
        this.inputBuffer.resetMark();
        var1_1 = this.inputBuffer.current();
        if (var1_1 != -1) ** GOTO lbl6
        throw this.createException("eof");
lbl-1000:
        // 1 sources

        {
            var1_1 = this.inputBuffer.next();
lbl6:
            // 2 sources

            ** while (XMLUtilities.isXMLNameCharacter((char)((char)var1_1)))
        }
lbl7:
        // 1 sources

        this.type = 56;
        return 56;
    }

    /*
     * Unable to fully structure code
     */
    protected int readComment() throws IOException, LexicalException {
        var1_1 = this.inputBuffer.next();
        if (var1_1 != 45) {
            throw this.createException("comment");
        }
        var1_1 = this.inputBuffer.next();
        this.inputBuffer.unsetMark();
        this.inputBuffer.setMark();
        ** GOTO lbl13
        {
            var1_1 = this.inputBuffer.next();
            do {
                if (var1_1 != -1 && var1_1 != 45) continue block0;
                var1_1 = this.inputBuffer.next();
                if (var1_1 == 45) break block0;
lbl13:
                // 2 sources

            } while (var1_1 != -1);
        }
        if (var1_1 == -1) {
            throw this.createException("eof");
        }
        var1_1 = this.inputBuffer.next();
        if (var1_1 != 62) {
            throw this.createException("comment");
        }
        var1_1 = this.inputBuffer.next();
        this.type = 7;
        return 7;
    }

    protected int readString() throws IOException, LexicalException {
        int n = this.inputBuffer.current();
        int n2 = this.inputBuffer.next();
        this.inputBuffer.unsetMark();
        this.inputBuffer.setMark();
        while (n2 != -1 && n2 != n) {
            n2 = this.inputBuffer.next();
        }
        if (n2 == -1) {
            throw this.createException("eof");
        }
        this.inputBuffer.next();
        this.type = 23;
        return 23;
    }

    protected int readReference() throws IOException, LexicalException {
        int n = this.inputBuffer.next();
        if (n == 35) {
            n = this.inputBuffer.next();
            this.inputBuffer.unsetMark();
            this.inputBuffer.setMark();
            int n2 = 0;
            switch (n) {
                case 120: {
                    do {
                        ++n2;
                    } while ((n = this.inputBuffer.next()) >= 48 && n <= 57 || n >= 97 && n <= 102 || n >= 65 && n <= 70);
                    break;
                }
                default: {
                    do {
                        ++n2;
                    } while ((n = this.inputBuffer.next()) >= 48 && n <= 57);
                    break;
                }
                case -1: {
                    throw this.createException("eof");
                }
            }
            if (n2 == 1 || n != 59) {
                throw this.createException("character.reference");
            }
            this.inputBuffer.next();
            this.type = 15;
            return 15;
        }
        this.readName(14);
        n = this.inputBuffer.current();
        if (n != 59) {
            throw this.createException("character.reference");
        }
        this.inputBuffer.next();
        return this.type;
    }

    protected int readPEReference() throws IOException, LexicalException {
        int n = this.inputBuffer.next();
        this.inputBuffer.unsetMark();
        this.inputBuffer.setMark();
        if (n == -1) {
            throw this.createException("eof");
        }
        if (!XMLUtilities.isXMLNameFirstCharacter((char)n)) {
            throw this.createException("parameter.entity");
        }
        while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
        }
        if (n != 59) {
            throw this.createException("parameter.entity");
        }
        this.inputBuffer.next();
        this.type = 28;
        return 28;
    }

    protected int readPIStart() throws IOException, LexicalException {
        int n = this.inputBuffer.next();
        this.inputBuffer.unsetMark();
        this.inputBuffer.setMark();
        if (n == -1) {
            throw this.createException("eof");
        }
        if (!XMLUtilities.isXMLNameFirstCharacter((char)n)) {
            throw this.createException("pi.target");
        }
        int n2 = this.inputBuffer.next();
        if (n2 == -1 || !XMLUtilities.isXMLNameCharacter((char)n2)) {
            this.type = 3;
            return 3;
        }
        int n3 = this.inputBuffer.next();
        if (n3 == -1 || !XMLUtilities.isXMLNameCharacter((char)n3)) {
            this.type = 3;
            return 3;
        }
        int n4 = this.inputBuffer.next();
        if (n4 != -1 && XMLUtilities.isXMLNameCharacter((char)n4)) {
            while ((n = this.inputBuffer.next()) != -1 && XMLUtilities.isXMLNameCharacter((char)n)) {
            }
            this.type = 3;
            return 3;
        }
        if (!(n != 120 && n != 88 || n2 != 109 && n2 != 77 || n3 != 108 && n3 != 76)) {
            throw this.createException("xml.reserved");
        }
        this.type = 3;
        return 3;
    }

    protected LexicalException createException(String string) {
        return new LexicalException(this.formatMessage(string, null), this.inputBuffer.getLine(), this.inputBuffer.getColumn());
    }
}

