/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.XSLTransformer;
import org.apache.batik.util.DocumentEvent;
import org.apache.batik.util.DocumentEventSource;
import org.apache.batik.util.DocumentListener;
import org.apache.batik.util.DocumentLoadingEvent;
import org.apache.batik.util.DocumentPropertyEvent;
import org.w3c.dom.svg.SVGSVGElement;
import org.xml.sax.SAXException;

public class DocumentLoadRunnable
implements Runnable,
DocumentEventSource {
    private boolean isRunning = false;
    protected String documentURI;
    protected SVGDocumentFactory df;
    protected Vector listeners = new Vector();

    public DocumentLoadRunnable(String string) {
        this.documentURI = string;
    }

    public static Thread createLoaderThread(String string, DocumentListener documentListener, SVGDocumentFactory sVGDocumentFactory) {
        DocumentLoadRunnable documentLoadRunnable = new DocumentLoadRunnable(string);
        documentLoadRunnable.addDocumentListener(documentListener);
        documentLoadRunnable.setDocumentFactory(sVGDocumentFactory);
        Thread thread = new Thread(documentLoadRunnable);
        thread.setPriority(1);
        return thread;
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.listeners.add(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.listeners.remove(documentListener);
    }

    public synchronized void setDocumentFactory(SVGDocumentFactory sVGDocumentFactory) {
        this.df = sVGDocumentFactory;
    }

    public synchronized SVGDocumentFactory getDocumentFactory() {
        return this.df;
    }

    public void fireAsyncDocumentEvent(DocumentEvent documentEvent, boolean bl) {
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocumentListener documentListener = (DocumentListener)iterator.next();
            DocumentEventDispatch documentEventDispatch = new DocumentEventDispatch(documentEvent, documentListener, this.getDocumentFactory());
            if (!EventQueue.isDispatchThread()) {
                if (bl) {
                    try {
                        EventQueue.invokeAndWait(documentEventDispatch);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    continue;
                }
                EventQueue.invokeLater(documentEventDispatch);
                continue;
            }
            documentEventDispatch.run();
        }
    }

    public void run() {
        SVGOMDocument sVGOMDocument = null;
        long l = System.currentTimeMillis();
        try {
            float f;
            float f2;
            this.fireAsyncDocumentEvent(new DocumentLoadingEvent(1, null), false);
            this.checkInterrupt();
            URL uRL = new URL(this.documentURI);
            InputStream inputStream = uRL.openStream();
            this.checkInterrupt();
            try {
                inputStream = new GZIPInputStream(inputStream);
            }
            catch (InterruptedIOException interruptedIOException) {
                inputStream.close();
                throw new InterruptedException();
            }
            catch (IOException iOException) {
                inputStream.close();
                inputStream = uRL.openStream();
            }
            this.checkInterrupt();
            try {
                sVGOMDocument = this.df.createDocument(this.documentURI, inputStream);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new InterruptedException("Parser interrupted?");
            }
            this.checkInterrupt();
            List list = XSLTransformer.getStyleSheets(sVGOMDocument.getFirstChild(), this.documentURI);
            if (list.size() > 0) {
                inputStream.close();
                inputStream = uRL.openStream();
                try {
                    inputStream = new GZIPInputStream(inputStream);
                }
                catch (InterruptedIOException interruptedIOException) {
                    inputStream.close();
                    throw new InterruptedException();
                }
                catch (IOException iOException) {
                    inputStream.close();
                    inputStream = uRL.openStream();
                }
                Reader reader = XSLTransformer.transform(new InputStreamReader(inputStream), list);
                sVGOMDocument = this.df.createDocument(this.documentURI, reader);
            }
            long l2 = System.currentTimeMillis();
            this.checkInterrupt();
            this.fireAsyncDocumentEvent(new DocumentLoadingEvent(2, sVGOMDocument), true);
            String string = sVGOMDocument.getTitle();
            this.checkInterrupt();
            this.fireAsyncDocumentEvent(new DocumentPropertyEvent(1, string), false);
            SVGSVGElement sVGSVGElement = sVGOMDocument.getRootElement();
            try {
                f2 = sVGSVGElement.getWidth().getBaseVal().getValue();
                f = sVGSVGElement.getHeight().getBaseVal().getValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                f2 = 400.0f;
                f = 400.0f;
            }
            this.checkInterrupt();
            String string2 = SVGUtilities.getDescription(sVGOMDocument.getRootElement());
            this.fireAsyncDocumentEvent(new DocumentPropertyEvent(15, string2), false);
            this.fireAsyncDocumentEvent(new DocumentLoadingEvent(15, sVGOMDocument), false);
            this.fireAsyncDocumentEvent(new DocumentPropertyEvent(2, new Dimension((int)f2, (int)f)), false);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Document loading thread interrupted.");
            this.fireAsyncDocumentEvent(new DocumentLoadingEvent(254, null), false);
        }
        catch (InterruptedIOException interruptedIOException) {
            System.out.println("Loading interrupted during document I/O.");
            this.fireAsyncDocumentEvent(new DocumentLoadingEvent(254, null), false);
        }
        catch (IOException iOException) {
            this.fireAsyncDocumentEvent(new DocumentLoadingEvent(255, null, iOException), false);
        }
        catch (SAXException sAXException) {
            this.fireAsyncDocumentEvent(new DocumentLoadingEvent(255, null, sAXException), false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void checkInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    private class DocumentEventDispatch
    implements Runnable {
        private DocumentEvent e;
        private DocumentListener l;
        private SVGDocumentFactory df;

        public DocumentEventDispatch(DocumentEvent documentEvent, DocumentListener documentListener, SVGDocumentFactory sVGDocumentFactory) {
            this.e = documentEvent;
            this.l = documentListener;
            this.df = sVGDocumentFactory;
        }

        public void run() {
            this.l.processDocumentEvent(this.e);
        }
    }
}

