/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.util.CharacterDecoder;

public class Base64Decoder
extends CharacterDecoder {
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    byte[] decode_buffer = new byte[4];

    int bytesPerAtom() {
        return 3;
    }

    int bytesPerLine() {
        return 48;
    }

    void decodeAtom(InputStream inputStream, OutputStream outputStream, int n) throws EOFException, IOException {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        StringBuffer stringBuffer = new StringBuffer(4);
        this.decode_buffer[0] = (byte)inputStream.read();
        if (this.decode_buffer[0] == -1) {
            throw new EOFException();
        }
        int n6 = this.decode_buffer[0] == 10 ? inputStream.read(this.decode_buffer, 0, 4) : inputStream.read(this.decode_buffer, 1, 3);
        if (n6 == -1) {
            throw new EOFException();
        }
        n6 = 0;
        while (n6 < 64) {
            if (this.decode_buffer[0] == pem_array[n6]) {
                n2 = (byte)n6;
            }
            if (this.decode_buffer[1] == pem_array[n6]) {
                n3 = (byte)n6;
            }
            if (this.decode_buffer[2] == pem_array[n6]) {
                n4 = (byte)n6;
            }
            if (this.decode_buffer[3] == pem_array[n6]) {
                n5 = (byte)n6;
            }
            ++n6;
        }
        if (n == 2 && this.decode_buffer[3] != 61) {
            throw new IOException("Base64Decoder: Bad Padding byte (2).");
        }
        if (n == 1 && (this.decode_buffer[2] != 61 || this.decode_buffer[3] != 61)) {
            throw new IOException("Base64Decoder: Bad Padding byte (1).");
        }
        n6 = 0;
        while (n6 < 4) {
            stringBuffer.append((char)this.decode_buffer[n6]);
            ++n6;
        }
        switch (n) {
            case 1: {
                outputStream.write((byte)(n2 << 2 & 0xFC | n3 >>> 4 & 3));
                break;
            }
            case 2: {
                outputStream.write((byte)(n2 << 2 & 0xFC | n3 >>> 4 & 3));
                outputStream.write((byte)(n3 << 4 & 0xF0 | n4 >>> 2 & 0xF));
                break;
            }
            case 3: {
                outputStream.write((byte)(n2 << 2 & 0xFC | n3 >>> 4 & 3));
                outputStream.write((byte)(n3 << 4 & 0xF0 | n4 >>> 2 & 0xF));
                outputStream.write((byte)(n4 << 6 & 0xC0 | n5 & 0x3F));
            }
        }
    }

    void decodeLineSuffix(InputStream inputStream, OutputStream outputStream) throws EOFException, IOException {
        int n;
        do {
            if ((n = inputStream.read()) != -1) continue;
            throw new EOFException();
        } while (n != 10 && n != 13 && n != 32);
    }
}

