/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder;

import java.io.IOException;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.transcoder.AbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public abstract class XMLAbstractTranscoder
extends AbstractTranscoder {
    public static final TranscodingHints.Key KEY_XML_PARSER_CLASSNAME = new StringKey(0);
    public static final TranscodingHints.Key KEY_DOCUMENT_ELEMENT = new StringKey(2);
    public static final TranscodingHints.Key KEY_DOCUMENT_ELEMENT_NAMESPACE_URI = new StringKey(3);
    public static final TranscodingHints.Key KEY_DOM_IMPLEMENTATION = new DOMImplKey(0);

    protected XMLAbstractTranscoder() {
    }

    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput) throws TranscoderException {
        Document document = null;
        if (transcoderInput.getDocument() != null) {
            document = transcoderInput.getDocument();
        } else {
            String string = (String)this.hints.get(KEY_XML_PARSER_CLASSNAME);
            String string2 = (String)this.hints.get(KEY_DOCUMENT_ELEMENT_NAMESPACE_URI);
            String string3 = (String)this.hints.get(KEY_DOCUMENT_ELEMENT);
            DOMImplementation dOMImplementation = (DOMImplementation)this.hints.get(KEY_DOM_IMPLEMENTATION);
            if (string == null) {
                this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_XML_PARSER_CLASSNAME"));
                return;
            }
            if (dOMImplementation == null) {
                this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_DOM_IMPLEMENTATION"));
                return;
            }
            if (string2 == null) {
                this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_DOCUMENT_ELEMENT_NAMESPACE_URI"));
                return;
            }
            if (string3 == null) {
                this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_DOCUMENT_ELEMENT"));
                return;
            }
            DocumentFactory documentFactory = this.createDocumentFactory(dOMImplementation, string);
            try {
                if (transcoderInput.getInputStream() != null) {
                    document = documentFactory.createDocument(string2, string3, transcoderInput.getURI(), transcoderInput.getInputStream());
                } else if (transcoderInput.getReader() != null) {
                    document = documentFactory.createDocument(string2, string3, transcoderInput.getURI(), transcoderInput.getReader());
                } else if (transcoderInput.getURI() != null) {
                    document = documentFactory.createDocument(string2, string3, transcoderInput.getURI());
                }
            }
            catch (DOMException dOMException) {
                this.handler.fatalError(new TranscoderException(dOMException));
            }
            catch (IOException iOException) {
                this.handler.fatalError(new TranscoderException(iOException));
            }
        }
        if (document != null) {
            try {
                this.transcode(document, transcoderOutput);
            }
            catch (TranscoderException transcoderException) {
                this.handler.fatalError(transcoderException);
                return;
            }
        }
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation dOMImplementation, String string) {
        return new SAXDocumentFactory(dOMImplementation, string);
    }

    protected abstract void transcode(Document var1, TranscoderOutput var2) throws TranscoderException;

    private static class DOMImplKey
    extends TranscodingHints.Key {
        public DOMImplKey(int n) {
            super(n);
        }

        public boolean isCompatibleValue(Object object) {
            return object instanceof DOMImplementation;
        }
    }

    private static class StringKey
    extends TranscodingHints.Key {
        public StringKey(int n) {
            super(n);
        }

        public boolean isCompatibleValue(Object object) {
            return object instanceof String;
        }
    }
}

