/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.svggen.SVGGraphicObjectConverter;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGPath
extends SVGGraphicObjectConverter {
    public SVGPath(Document document) {
        super(document);
    }

    public Element toSVG(Shape shape) {
        GeneralPath generalPath = null;
        generalPath = shape instanceof GeneralPath ? (GeneralPath)shape : new GeneralPath(shape);
        String string = SVGPath.toSVGPathData(generalPath);
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "path");
        element.setAttributeNS(null, "d", string);
        if (generalPath.getWindingRule() == 0) {
            element.setAttributeNS(null, "fill-rule", "evenodd");
        }
        return element;
    }

    static String toSVGPathData(GeneralPath generalPath) {
        StringBuffer stringBuffer = new StringBuffer("");
        PathIterator pathIterator = generalPath.getPathIterator(null);
        float[] fArray = new float[6];
        int n = 0;
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    stringBuffer.append("M ");
                    SVGPath.appendPoint(stringBuffer, fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    stringBuffer.append("L ");
                    SVGPath.appendPoint(stringBuffer, fArray[0], fArray[1]);
                    break;
                }
                case 4: {
                    stringBuffer.append("Z ");
                    break;
                }
                case 2: {
                    stringBuffer.append("Q ");
                    SVGPath.appendPoint(stringBuffer, fArray[0], fArray[1]);
                    SVGPath.appendPoint(stringBuffer, fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    stringBuffer.append("C ");
                    SVGPath.appendPoint(stringBuffer, fArray[0], fArray[1]);
                    SVGPath.appendPoint(stringBuffer, fArray[2], fArray[3]);
                    SVGPath.appendPoint(stringBuffer, fArray[4], fArray[5]);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            pathIterator.next();
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return "";
    }

    private static void appendPoint(StringBuffer stringBuffer, float f, float f2) {
        stringBuffer.append(SVGGraphicObjectConverter.doubleString(f));
        stringBuffer.append(" ");
        stringBuffer.append(SVGGraphicObjectConverter.doubleString(f2));
        stringBuffer.append(" ");
    }

    public static void main(String[] stringArray) throws Exception {
        GeneralPath generalPath = new GeneralPath(0);
        Shape[] shapeArray = new Shape[]{generalPath, new Rectangle2D.Float(20.0f, 30.0f, 40.0f, 50.0f), new Ellipse2D.Float(25.0f, 35.0f, 80.0f, 60.0f), new Line2D.Float(30.0f, 40.0f, 50.0f, 60.0f), new QuadCurve2D.Float(20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f), new CubicCurve2D.Float(15.0f, 25.0f, 35.0f, 45.0f, 55.0f, 65.0f, 75.0f, 85.0f)};
        Document document = TestUtil.getDocumentPrototype();
        SVGPath sVGPath = new SVGPath(document);
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < shapeArray.length) {
            Shape shape = shapeArray[n];
            Element element2 = sVGPath.toSVG(shape);
            element.appendChild(element2);
            ++n;
        }
        TestUtil.trace(element, System.out);
    }
}

