/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.DefaultImageHandler;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.ImageHandler;
import org.apache.batik.svggen.SVGBasicStroke;
import org.apache.batik.svggen.SVGClip;
import org.apache.batik.svggen.SVGComposite;
import org.apache.batik.svggen.SVGConverter;
import org.apache.batik.svggen.SVGFont;
import org.apache.batik.svggen.SVGGraphicContext;
import org.apache.batik.svggen.SVGPaint;
import org.apache.batik.svggen.SVGRenderingHints;
import org.apache.batik.svggen.SVGSyntax;
import org.apache.batik.svggen.SVGTransform;
import org.apache.batik.svggen.TestUtil;
import org.apache.batik.svggen.TransformStackElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGGraphicContextConverter
implements SVGSyntax {
    public static final String ERROR_NULL_INPUT = "domFactory, extensionHandler and imageHandler should not be null";
    private static final int GRAPHIC_CONTEXT_CONVERTER_COUNT = 6;
    private String[] leafOnlyAttributes = new String[]{"opacity", "filter", "clip-path"};
    private SVGTransform transformConverter;
    private SVGPaint paintConverter;
    private SVGBasicStroke strokeConverter;
    private SVGComposite compositeConverter;
    private SVGClip clipConverter;
    private SVGRenderingHints hintsConverter;
    private SVGFont fontConverter;
    private SVGConverter[] converters = new SVGConverter[6];

    public SVGTransform getTransformConverter() {
        return this.transformConverter;
    }

    public SVGPaint getPaintConverter() {
        return this.paintConverter;
    }

    public SVGBasicStroke getStrokeConverter() {
        return this.strokeConverter;
    }

    public SVGComposite getCompositeConverter() {
        return this.compositeConverter;
    }

    public SVGClip getClipConverter() {
        return this.clipConverter;
    }

    public SVGRenderingHints getHintsConverter() {
        return this.hintsConverter;
    }

    public SVGFont getFontConverter() {
        return this.fontConverter;
    }

    public SVGGraphicContextConverter(Document document, ExtensionHandler extensionHandler, ImageHandler imageHandler) {
        if (document == null || extensionHandler == null || imageHandler == null) {
            throw new IllegalArgumentException(ERROR_NULL_INPUT);
        }
        this.transformConverter = new SVGTransform();
        this.paintConverter = new SVGPaint(document, imageHandler, extensionHandler);
        this.strokeConverter = new SVGBasicStroke();
        this.compositeConverter = new SVGComposite(document, extensionHandler);
        this.clipConverter = new SVGClip(document);
        this.hintsConverter = new SVGRenderingHints();
        this.fontConverter = new SVGFont();
        int n = 0;
        this.converters[n++] = this.paintConverter;
        this.converters[n++] = this.strokeConverter;
        this.converters[n++] = this.compositeConverter;
        this.converters[n++] = this.clipConverter;
        this.converters[n++] = this.hintsConverter;
        this.converters[n++] = this.fontConverter;
    }

    void setExtensionHandler(ExtensionHandler extensionHandler) {
        this.paintConverter.setExtensionHandler(extensionHandler);
        this.compositeConverter.setExtensionHandler(extensionHandler);
    }

    public String toSVG(TransformStackElement[] transformStackElementArray) {
        return SVGTransform.toSVGTransform(transformStackElementArray);
    }

    public SVGGraphicContext toSVG(GraphicContext graphicContext) {
        Object object;
        Hashtable hashtable = new Hashtable();
        int n = 0;
        while (n < this.converters.length) {
            object = this.converters[n].toSVG(graphicContext);
            if (object != null) {
                object.getAttributeMap(hashtable);
            }
            ++n;
        }
        object = new Hashtable();
        int n2 = 0;
        while (n2 < this.leafOnlyAttributes.length) {
            Object v = hashtable.get(this.leafOnlyAttributes[n2]);
            if (v != null) {
                object.put(this.leafOnlyAttributes[n2], v);
                hashtable.remove(this.leafOnlyAttributes[n2]);
            }
            ++n2;
        }
        return new SVGGraphicContext(hashtable, (Map)object, graphicContext.getTransformStack());
    }

    public Set getDefinitionSet() {
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < this.converters.length) {
            hashSet.addAll(this.converters[n].getDefinitionSet());
            ++n;
        }
        return hashSet;
    }

    public static void main(String[] stringArray) throws Exception {
        Document document = TestUtil.getDocumentPrototype();
        GraphicContext graphicContext = new GraphicContext(new AffineTransform());
        SVGGraphicContextConverter sVGGraphicContextConverter = new SVGGraphicContextConverter(document, new DefaultExtensionHandler(), new DefaultImageHandler());
        SVGGraphicContext sVGGraphicContext = sVGGraphicContextConverter.toSVG(graphicContext);
        SVGGraphicContextConverter.traceSVGGC(sVGGraphicContext, sVGGraphicContextConverter);
        graphicContext.translate(40, 40);
        graphicContext.setPaint(new GradientPaint(0.0f, 0.0f, Color.yellow, 200.0f, 200.0f, Color.red));
        graphicContext.setStroke(new BasicStroke(4.0f, 1, 2, 40.0f, new float[]{4.0f, 5.0f, 6.0f, 7.0f}, 3.0f));
        graphicContext.setComposite(AlphaComposite.getInstance(5, 0.25f));
        graphicContext.setClip(new Ellipse2D.Double(20.0, 30.0, 40.0, 50.0));
        graphicContext.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphicContext.setFont(new Font("French Script MT", 1, 45));
        SVGGraphicContext sVGGraphicContext2 = sVGGraphicContextConverter.toSVG(graphicContext);
        SVGGraphicContextConverter.traceSVGGC(sVGGraphicContext2, sVGGraphicContextConverter);
        Set set = sVGGraphicContextConverter.getDefinitionSet();
        Iterator iterator = set.iterator();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            element.appendChild(element2);
        }
        TestUtil.trace(element, System.out);
    }

    static void traceSVGGC(SVGGraphicContext sVGGraphicContext, SVGGraphicContextConverter sVGGraphicContextConverter) {
        String string;
        Object object;
        System.out.println("=============================================");
        Map map = sVGGraphicContext.getGroupContext();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            string = (String)map.get(object);
            System.out.println((String)object + " = " + string);
        }
        System.out.println("++++++++++++++++++");
        object = sVGGraphicContext.getGraphicElementContext();
        iterator = object.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            String string2 = (String)object.get(string);
            System.out.println(string + " = " + string2);
        }
        System.out.println("++++++++++++++++++");
        System.out.println("transform: " + sVGGraphicContextConverter.toSVG(sVGGraphicContext.getTransformStack()));
        System.out.println("=============================================");
    }
}

