/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.SVGAttribute;
import org.apache.batik.svggen.SVGAttributeMap;
import org.apache.batik.svggen.SVGGraphicContext;
import org.apache.batik.svggen.SVGSyntax;
import org.apache.batik.svggen.TransformStackElement;
import org.w3c.dom.Element;

public class DOMGroupManager
implements SVGSyntax {
    static final String ERROR_GC_NULL = "gc should not be null";
    static final String ERROR_DOMTREEMANAGER_NULL = "domTreeManager should not be null";
    private GraphicContext gc;
    private DOMTreeManager domTreeManager;
    private SVGGraphicContext groupGC;
    private Element currentGroup;

    public DOMGroupManager(GraphicContext graphicContext, DOMTreeManager dOMTreeManager) {
        if (graphicContext == null) {
            throw new IllegalArgumentException(ERROR_GC_NULL);
        }
        if (dOMTreeManager == null) {
            throw new IllegalArgumentException(ERROR_DOMTREEMANAGER_NULL);
        }
        this.gc = graphicContext;
        this.domTreeManager = dOMTreeManager;
        this.recycleCurrentGroup();
        this.groupGC = dOMTreeManager.gcConverter.toSVG(graphicContext);
    }

    void recycleCurrentGroup() {
        this.currentGroup = this.domTreeManager.domFactory.createElementNS("http://www.w3.org/2000/svg", "g");
    }

    public void addElement(Element element) {
        if (!this.currentGroup.hasChildNodes()) {
            this.currentGroup.appendChild(element);
            this.groupGC = this.domTreeManager.gcConverter.toSVG(this.gc);
            SVGGraphicContext sVGGraphicContext = this.processDeltaGC(this.groupGC, this.domTreeManager.defaultGC);
            this.setAttributes(this.currentGroup, sVGGraphicContext.getGroupContext());
            this.setAttributes(element, sVGGraphicContext.getGraphicElementContext());
            this.setTransform(this.currentGroup, sVGGraphicContext.getTransformStack());
            this.domTreeManager.appendGroup(this.currentGroup, this);
        } else if (this.gc.isTransformStackValid()) {
            SVGGraphicContext sVGGraphicContext = this.domTreeManager.gcConverter.toSVG(this.gc);
            SVGGraphicContext sVGGraphicContext2 = this.processDeltaGC(sVGGraphicContext, this.groupGC);
            this.trimContextForElement(sVGGraphicContext2, element);
            if (this.countOverrides(sVGGraphicContext2) <= this.domTreeManager.maxGCOverrides) {
                this.currentGroup.appendChild(element);
                this.setAttributes(element, sVGGraphicContext2.getGroupContext());
                this.setAttributes(element, sVGGraphicContext2.getGraphicElementContext());
                this.setTransform(element, sVGGraphicContext2.getTransformStack());
            } else {
                this.currentGroup = this.domTreeManager.domFactory.createElementNS("http://www.w3.org/2000/svg", "g");
                this.addElement(element);
            }
        } else {
            this.currentGroup = this.domTreeManager.domFactory.createElementNS("http://www.w3.org/2000/svg", "g");
            this.gc.validateTransformStack();
            this.addElement(element);
        }
    }

    private int countOverrides(SVGGraphicContext sVGGraphicContext) {
        return sVGGraphicContext.getGroupContext().size();
    }

    private void trimContextForElement(SVGGraphicContext sVGGraphicContext, Element element) {
        String string = element.getTagName();
        Map map = sVGGraphicContext.getGroupContext();
        if (string != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                SVGAttribute sVGAttribute = SVGAttributeMap.get(string2);
                if (sVGAttribute == null || sVGAttribute.appliesTo(string)) continue;
                map.remove(string2);
            }
        }
    }

    private void setTransform(Element element, TransformStackElement[] transformStackElementArray) {
        String string = this.domTreeManager.gcConverter.toSVG(transformStackElementArray).trim();
        if (string.length() > 0) {
            element.setAttributeNS(null, "transform", string);
        }
    }

    private void setAttributes(Element element, Map map) {
        String string = element.getTagName();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (element.getAttributeNS(null, string2).length() != 0) continue;
            element.setAttributeNS(null, string2, (String)map.get(string2));
        }
    }

    private SVGGraphicContext processDeltaGC(SVGGraphicContext sVGGraphicContext, SVGGraphicContext sVGGraphicContext2) {
        Map map = this.processDeltaMap(sVGGraphicContext.getGroupContext(), sVGGraphicContext2.getGroupContext());
        Map map2 = sVGGraphicContext.getGraphicElementContext();
        TransformStackElement[] transformStackElementArray = sVGGraphicContext.getTransformStack();
        TransformStackElement[] transformStackElementArray2 = sVGGraphicContext2.getTransformStack();
        int n = transformStackElementArray.length - transformStackElementArray2.length;
        TransformStackElement[] transformStackElementArray3 = new TransformStackElement[n];
        System.arraycopy(transformStackElementArray, transformStackElementArray2.length, transformStackElementArray3, 0, n);
        SVGGraphicContext sVGGraphicContext3 = new SVGGraphicContext(map, map2, transformStackElementArray3);
        return sVGGraphicContext3;
    }

    private Map processDeltaMap(Map map, Map map2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            if (string3.equals(string = (String)map2.get(string2))) continue;
            hashtable.put(string2, string3);
        }
        return hashtable;
    }

    public static void main(String[] stringArray) throws Exception {
    }
}

