/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.lang.reflect.Array;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.GlyphLayout;
import org.apache.batik.gvt.text.TextLayoutAdapter;
import org.apache.batik.gvt.text.TextLayoutFactory;
import org.apache.batik.gvt.text.TextSpanLayout;

public class ConcreteTextLayoutFactory
implements TextLayoutFactory {
    public static final int L = 2;
    public static final int R = 1;
    public static final int AL = 5;
    public static final int RLE = 17;
    public static final int RLO = 49;
    public static final int LRE = 16;
    public static final int LRO = 48;
    public static final int B = 128;
    public static final int BN = 384;
    public static final int S = 12;
    public static final int WS = 8;
    public static final int AN = 320;
    public static final int ON = 258;
    public static final int EN = 256;
    public static final int ET = 512;
    public static String unicodeFileName = "UnicodeData.txt";

    public TextSpanLayout createTextLayout(AttributedCharacterIterator attributedCharacterIterator, Point2D point2D, FontRenderContext fontRenderContext) {
        Set<AttributedCharacterIterator.Attribute> set = attributedCharacterIterator.getAllAttributeKeys();
        HashSet<GVTAttributedCharacterIterator.TextAttribute> hashSet = new HashSet<GVTAttributedCharacterIterator.TextAttribute>();
        hashSet.add(GVTAttributedCharacterIterator.TextAttribute.EXPLICIT_LAYOUT);
        hashSet.add(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING);
        hashSet.add(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH);
        hashSet.add(GVTAttributedCharacterIterator.TextAttribute.DX);
        hashSet.add(GVTAttributedCharacterIterator.TextAttribute.DY);
        hashSet.add(GVTAttributedCharacterIterator.TextAttribute.ROTATION);
        hashSet.add(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT);
        hashSet.retainAll(set);
        if (hashSet.isEmpty()) {
            return new TextLayoutAdapter(new TextLayout(attributedCharacterIterator, fontRenderContext), point2D, attributedCharacterIterator);
        }
        char c = attributedCharacterIterator.first();
        do {
            if (!this.isRTL(c)) continue;
            return new TextLayoutAdapter(new TextLayout(attributedCharacterIterator, fontRenderContext), point2D, attributedCharacterIterator);
        } while ((c = attributedCharacterIterator.next()) != '\uffff');
        return new GlyphLayout(attributedCharacterIterator, point2D, fontRenderContext);
    }

    private boolean isRTL(char c) {
        int n = UnicodeData.getBiDiCode(Character.getNumericValue(c));
        switch (n) {
            case 1: 
            case 5: 
            case 17: 
            case 49: {
                return true;
            }
        }
        return false;
    }

    public static class UnicodeData {
        protected static int BIDI_CODE_NDX = 4;
        protected static Object[] unicodeValues = new Object[65280];
        static /* synthetic */ Class class$java$lang$Object;

        public static int getBiDiCode(int n) {
            int n2;
            try {
                n2 = (Integer)Array.get(UnicodeData.getUnicodeData(n), BIDI_CODE_NDX);
            }
            catch (Exception exception) {
                n2 = 0;
            }
            return n2;
        }

        public static Array getUnicodeData(int n) {
            Array array = (Array)unicodeValues[n];
            if (array == null) {
                array = UnicodeData.parseUnicodeDataEntry(n);
                UnicodeData.unicodeValues[n] = array;
            }
            return array;
        }

        public static Array parseUnicodeDataEntry(int n) {
            Array array = (Array)Array.newInstance(class$java$lang$Object == null ? (class$java$lang$Object = UnicodeData.class$("java.lang.Object")) : class$java$lang$Object, 14);
            String string = UnicodeData.readUnicodeData(n, unicodeFileName);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            Array.set(array, 0, new Integer(stringTokenizer.nextToken()));
            Array.set(array, 1, stringTokenizer.nextToken());
            Array.set(array, 2, stringTokenizer.nextToken());
            Array.set(array, 3, stringTokenizer.nextToken());
            Array.set(array, 4, new Integer(UnicodeData.getBiDiValue(stringTokenizer.nextToken())));
            Array.set(array, 5, new Integer(stringTokenizer.nextToken()));
            Array.set(array, 6, stringTokenizer.nextToken());
            Array.set(array, 7, stringTokenizer.nextToken());
            Array.set(array, 8, stringTokenizer.nextToken());
            Array.set(array, 9, stringTokenizer.nextToken());
            Array.set(array, 10, stringTokenizer.nextToken());
            Array.set(array, 11, stringTokenizer.nextToken());
            Array.set(array, 12, stringTokenizer.nextToken());
            Array.set(array, 13, stringTokenizer.nextToken());
            return array;
        }

        private static int getBiDiValue(String string) {
            int n = 0;
            char[] cArray = string.toCharArray();
            block0 : switch (cArray[0]) {
                case 'L': {
                    if (cArray.length > 2) {
                        switch (cArray[2]) {
                            case 'E': {
                                n = 16;
                                break block0;
                            }
                        }
                        n = 48;
                        break;
                    }
                    n = 2;
                    break;
                }
                case 'R': {
                    if (cArray.length > 2) {
                        switch (cArray[2]) {
                            case 'E': {
                                n = 17;
                                break block0;
                            }
                        }
                        n = 49;
                        break;
                    }
                    n = 1;
                    break;
                }
                case 'A': {
                    switch (cArray[2]) {
                        case 'L': {
                            n = 5;
                            break block0;
                        }
                    }
                    n = 320;
                    break;
                }
                case 'B': {
                    if (cArray.length > 1) {
                        n = 384;
                        break;
                    }
                    n = 128;
                    break;
                }
                case 'E': {
                    switch (cArray[1]) {
                        case 'N': {
                            n = 256;
                            break block0;
                        }
                    }
                    n = 512;
                    break;
                }
                case 'O': {
                    n = 258;
                    break;
                }
                case 'S': {
                    n = 12;
                }
            }
            return n;
        }

        private static String readUnicodeData(int n, String string) {
            String string2 = null;
            try {
                StreamTokenizer streamTokenizer = new StreamTokenizer(new FileReader(string));
                streamTokenizer.resetSyntax();
                streamTokenizer.eolIsSignificant(true);
                int n2 = 0;
                while (n2 < n) {
                    string2 = streamTokenizer.toString();
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    ++n2;
                }
                System.out.println("UnicodeData for " + n + ": " + string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(fileNotFoundException);
            }
            catch (IOException iOException) {
                System.out.println("Error reading Unicode Database: " + iOException);
            }
            return string2;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

