/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.renderer.BasicTextPainter;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextSpanLayout;

public class StrokingTextPainter
extends BasicTextPainter {
    static Set extendedAtts = new HashSet();

    public void paint(TextNode textNode, Graphics2D graphics2D, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        TextChunk textChunk;
        FontRenderContext fontRenderContext = graphicsNodeRenderContext.getFontRenderContext();
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        ArrayList arrayList = new ArrayList();
        attributedCharacterIterator.first();
        int n = 0;
        do {
            if ((textChunk = this.getTextChunk(textNode, attributedCharacterIterator, arrayList, n, fontRenderContext)) == null) continue;
            this.adjustChunkOffsets(arrayList, textChunk.advance, textChunk.begin, textChunk.end);
            n = textChunk.end;
        } while (textChunk != null);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            this.paintTextRun((TextRun)arrayList.get(n2), graphics2D);
            ++n2;
        }
    }

    private TextChunk getTextChunk(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, List list, int n, FontRenderContext fontRenderContext) {
        int n2 = n;
        boolean bl = true;
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        Point2D point2D = textNode.getLocation();
        if (attributedCharacterIterator.current() != '\uffff') {
            int n3 = attributedCharacterIterator.getIndex();
            boolean bl2 = true;
            do {
                int n4 = attributedCharacterIterator.getRunStart(extendedAtts);
                int n5 = attributedCharacterIterator.getRunLimit(extendedAtts);
                AttributedCharacterIterator attributedCharacterIterator2 = new AttributedCharacterSpanIterator(attributedCharacterIterator, n4, n5);
                Float f = (Float)attributedCharacterIterator2.getAttribute(GVTAttributedCharacterIterator.TextAttribute.X);
                boolean bl3 = bl = bl2 || f == null || f.isNaN();
                if (bl) {
                    Point2D.Float float_2 = new Point2D.Float((float)(point2D.getX() + ((Point2D)float_).getX()), (float)(point2D.getY() + ((Point2D)float_).getY()));
                    TextSpanLayout textSpanLayout = this.getTextLayoutFactory().createTextLayout(attributedCharacterIterator2, float_2, fontRenderContext);
                    if (textSpanLayout.isVertical()) {
                        attributedCharacterIterator2 = this.createModifiedACIForVerticalLayout(attributedCharacterIterator2);
                    }
                    TextRun textRun = new TextRun(textSpanLayout, attributedCharacterIterator2);
                    list.add(textRun);
                    Point2D point2D2 = textSpanLayout.getAdvance2D();
                    float_ = new Point2D.Float((float)(((Point2D)float_).getX() + point2D2.getX()), (float)(((Point2D)float_).getY() + point2D2.getY()));
                    ++n2;
                    if (attributedCharacterIterator.setIndex(n5) == '\uffff') {
                        break;
                    }
                } else {
                    attributedCharacterIterator.setIndex(n4);
                }
                bl2 = false;
            } while (bl);
            return new TextChunk(n, n2, float_);
        }
        return null;
    }

    private AttributedCharacterIterator createModifiedACIForVerticalLayout(AttributedCharacterIterator attributedCharacterIterator) {
        AttributedString attributedString = new AttributedString(attributedCharacterIterator);
        if (attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE) != null) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH) != null) {
            attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return attributedString.getIterator();
    }

    private void adjustChunkOffsets(List list, Point2D point2D, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            TextRun textRun = (TextRun)list.get(n3);
            int n4 = textRun.getAnchorType();
            float f = 0.0f;
            float f2 = 0.0f;
            switch (n4) {
                case 1: {
                    f = (float)(-point2D.getX() / 2.0);
                    f2 = (float)(-point2D.getY() / 2.0);
                    break;
                }
                case 2: {
                    f = (float)(-point2D.getX());
                    f2 = (float)(-point2D.getY());
                    break;
                }
            }
            TextSpanLayout textSpanLayout = textRun.getLayout();
            Point2D point2D2 = textSpanLayout.getOffset();
            if (textSpanLayout.isVertical()) {
                textSpanLayout.setOffset(new Point2D.Float((float)point2D2.getX(), (float)point2D2.getY() + f2));
            } else {
                textSpanLayout.setOffset(new Point2D.Float((float)point2D2.getX() + f, (float)point2D2.getY()));
            }
            ++n3;
        }
    }

    private void paintTextRun(TextRun textRun, Graphics2D graphics2D) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
        TextSpanLayout textSpanLayout = textRun.getLayout();
        attributedCharacterIterator.first();
        Composite composite = (Composite)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OPACITY);
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
        boolean bl4 = bl3 = attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE) != null;
        if (bl3 && !textSpanLayout.isVertical()) {
            this.paintUnderline(textRun, graphics2D);
        }
        boolean bl5 = bl2 = attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE) != null;
        if (bl2 && !textSpanLayout.isVertical()) {
            this.paintOverline(textRun, graphics2D);
        }
        Shape shape = textSpanLayout.getOutline();
        Paint paint = (Paint)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(shape);
        }
        Stroke stroke = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE);
        paint = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT);
        if (stroke != null && paint != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(shape);
        }
        boolean bl6 = bl = attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH) == GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_ON;
        if (bl && !textSpanLayout.isVertical()) {
            this.paintStrikethrough(textRun, graphics2D);
        }
    }

    private void paintOverline(TextRun textRun, Graphics2D graphics2D) {
        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
        TextSpanLayout textSpanLayout = textRun.getLayout();
        Shape shape = textSpanLayout.getDecorationOutline(4);
        Paint paint = (Paint)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(shape);
        }
        Stroke stroke = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE);
        paint = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT);
        if (stroke != null && paint != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(shape);
        }
    }

    private void paintUnderline(TextRun textRun, Graphics2D graphics2D) {
        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
        TextSpanLayout textSpanLayout = textRun.getLayout();
        Shape shape = textSpanLayout.getDecorationOutline(1);
        Paint paint = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(shape);
        }
        Stroke stroke = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
        paint = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
        if (stroke != null && paint != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(shape);
        }
    }

    private void paintStrikethrough(TextRun textRun, Graphics2D graphics2D) {
        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
        TextSpanLayout textSpanLayout = textRun.getLayout();
        Shape shape = textSpanLayout.getDecorationOutline(2);
        Paint paint = (Paint)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(shape);
        }
        Stroke stroke = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE);
        paint = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT);
        if (stroke != null && paint != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(shape);
        }
    }

    static {
        extendedAtts.add(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
    }

    class TextRun {
        private AttributedCharacterIterator aci;
        private TextSpanLayout layout;
        private int anchorType;

        public TextRun(TextSpanLayout textSpanLayout, AttributedCharacterIterator attributedCharacterIterator) {
            this.layout = textSpanLayout;
            this.aci = attributedCharacterIterator;
            this.aci.first();
            TextNode.Anchor anchor = (TextNode.Anchor)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
            this.anchorType = 0;
            if (anchor != null) {
                this.anchorType = anchor.getType();
            }
        }

        public AttributedCharacterIterator getACI() {
            return this.aci;
        }

        public TextSpanLayout getLayout() {
            return this.layout;
        }

        public int getAnchorType() {
            return this.anchorType;
        }
    }

    class TextChunk {
        public int begin;
        public int end;
        public Point2D advance;

        public TextChunk(int n, int n2, Point2D point2D) {
            this.begin = n;
            this.end = n2;
            this.advance = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        }
    }
}

