/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.filter.ConcreteGraphicsNodeRableFactory;
import org.apache.batik.gvt.renderer.Renderer;
import org.apache.batik.gvt.renderer.RendererFactory;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.apache.batik.gvt.renderer.StrokingTextPainter;

public class StaticRendererFactory
implements RendererFactory {
    private GraphicsNodeRenderContext nodeRenderContext = null;

    public Renderer createRenderer(BufferedImage bufferedImage) {
        return new StaticRenderer(bufferedImage, this.getRenderContext());
    }

    public GraphicsNodeRenderContext getRenderContext() {
        if (this.nodeRenderContext == null) {
            RenderingHints renderingHints = new RenderingHints(null);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
            StrokingTextPainter strokingTextPainter = new StrokingTextPainter();
            ConcreteGraphicsNodeRableFactory concreteGraphicsNodeRableFactory = new ConcreteGraphicsNodeRableFactory();
            this.nodeRenderContext = new GraphicsNodeRenderContext(new AffineTransform(), null, renderingHints, fontRenderContext, strokingTextPainter, concreteGraphicsNodeRableFactory);
        }
        return this.nodeRenderContext;
    }
}

