/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.text.ConcreteTextLayoutFactory;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextLayoutFactory;
import org.apache.batik.gvt.text.TextSpanLayout;

public class BasicTextPainter
implements TextPainter {
    private static TextLayoutFactory textLayoutFactory = new ConcreteTextLayoutFactory();
    private Mark cachedMark = null;
    private AttributedCharacterIterator cachedACI = null;
    private TextHit cachedHit = null;

    public void paint(TextNode textNode, Graphics2D graphics2D, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        FontRenderContext fontRenderContext = graphicsNodeRenderContext.getFontRenderContext();
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        TextSpanLayout textSpanLayout = this.getOffsetAdjustedTextLayout(attributedCharacterIterator, textNode.getLocation(), fontRenderContext);
        textSpanLayout.draw(graphics2D);
    }

    protected TextLayoutFactory getTextLayoutFactory() {
        return textLayoutFactory;
    }

    public org.apache.batik.gvt.text.Mark selectAt(double d, double d2, AttributedCharacterIterator attributedCharacterIterator, TextNode textNode, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        org.apache.batik.gvt.text.Mark mark = this.hitTest(d, d2, attributedCharacterIterator, textNode, graphicsNodeRenderContext);
        this.cachedHit = null;
        return mark;
    }

    public org.apache.batik.gvt.text.Mark selectTo(double d, double d2, org.apache.batik.gvt.text.Mark mark, AttributedCharacterIterator attributedCharacterIterator, TextNode textNode, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        org.apache.batik.gvt.text.Mark mark2 = this.hitTest(d, d2, attributedCharacterIterator, textNode, graphicsNodeRenderContext);
        return mark2;
    }

    public org.apache.batik.gvt.text.Mark selectAll(double d, double d2, AttributedCharacterIterator attributedCharacterIterator, TextNode textNode, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        org.apache.batik.gvt.text.Mark mark = this.hitTest(d, d2, attributedCharacterIterator, textNode, graphicsNodeRenderContext);
        return mark;
    }

    public int[] getSelected(AttributedCharacterIterator attributedCharacterIterator, org.apache.batik.gvt.text.Mark mark, org.apache.batik.gvt.text.Mark mark2) {
        Mark mark3;
        Mark mark4;
        try {
            mark4 = (Mark)mark;
            mark3 = (Mark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        TextSpanLayout textSpanLayout = null;
        if (mark4 != null) {
            textSpanLayout = mark4.getLayout();
        }
        if (textSpanLayout != null) {
            int[] nArray = null;
            try {
                nArray = new int[2];
                nArray[0] = mark4.getHit().isLeadingEdge() ? mark4.getHit().getCharIndex() : mark4.getHit().getCharIndex() + 1;
                int n = nArray[1] = mark3.getHit().isLeadingEdge() ? mark3.getHit().getCharIndex() : mark3.getHit().getCharIndex() + 1;
                if (nArray[0] > nArray[1]) {
                    int n2 = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n2;
                }
            }
            catch (Exception exception) {
                return null;
            }
            if (nArray[0] < 0) {
                nArray[0] = 0;
            }
            return nArray;
        }
        return null;
    }

    public Shape getHighlightShape(org.apache.batik.gvt.text.Mark mark, org.apache.batik.gvt.text.Mark mark2) {
        Mark mark3;
        Mark mark4;
        try {
            mark4 = (Mark)mark;
            mark3 = (Mark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        Shape shape = null;
        TextSpanLayout textSpanLayout = null;
        if (mark4 != null) {
            textSpanLayout = mark4.getLayout();
        }
        if (textSpanLayout != null) {
            int n = 0;
            int n2 = 0;
            if (mark4 != mark3) {
                n = mark4.getHit().isLeadingEdge() ? mark4.getHit().getCharIndex() : mark4.getHit().getCharIndex() + 1;
                int n3 = n2 = mark3.getHit().isLeadingEdge() ? mark3.getHit().getCharIndex() : mark3.getHit().getCharIndex() + 1;
                if (n > n2) {
                    int n4 = n;
                    n = n2;
                    n2 = n4;
                }
            } else {
                n2 = textSpanLayout.getCharacterCount();
            }
            if (n < 0) {
                n = 0;
            }
            shape = textSpanLayout.getLogicalHighlightShape(n, n2);
        }
        return shape;
    }

    public Rectangle2D getBounds(TextNode textNode, FontRenderContext fontRenderContext) {
        return this.getBounds(textNode, fontRenderContext, false, false);
    }

    public Rectangle2D getDecoratedBounds(TextNode textNode, FontRenderContext fontRenderContext) {
        return this.getBounds(textNode, fontRenderContext, true, false);
    }

    public Rectangle2D getPaintedBounds(TextNode textNode, FontRenderContext fontRenderContext) {
        Rectangle2D rectangle2D = this.getBounds(textNode, fontRenderContext, true, true);
        return rectangle2D;
    }

    protected Rectangle2D getBounds(TextNode textNode, FontRenderContext fontRenderContext, boolean bl, boolean bl2) {
        Shape shape;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        TextSpanLayout textSpanLayout = this.getOffsetAdjustedTextLayout(attributedCharacterIterator, textNode.getLocation(), fontRenderContext);
        Rectangle2D rectangle2D = bl2 ? ((shape = this.getStrokeOutline(textNode, fontRenderContext, bl)) != null ? shape.getBounds2D() : textSpanLayout.getBounds()) : (bl ? textSpanLayout.getDecoratedBounds() : textSpanLayout.getBounds());
        return rectangle2D;
    }

    protected Shape getOutline(TextNode textNode, FontRenderContext fontRenderContext, boolean bl) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        TextSpanLayout textSpanLayout = this.getOffsetAdjustedTextLayout(attributedCharacterIterator, textNode.getLocation(), fontRenderContext);
        Shape shape = textSpanLayout.getOutline();
        if (bl) {
            int n = 0;
            if (attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE) != null) {
                n |= 1;
            }
            if (attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE) != null) {
                n |= 4;
            }
            if (attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH) != null) {
                n |= 2;
            }
            if (n != 0) {
                if (!(shape instanceof GeneralPath)) {
                    shape = new GeneralPath(shape);
                }
                ((GeneralPath)shape).setWindingRule(1);
                ((GeneralPath)shape).append(textSpanLayout.getDecorationOutline(n), false);
            }
        }
        return shape;
    }

    public Shape getShape(TextNode textNode, FontRenderContext fontRenderContext) {
        return this.getOutline(textNode, fontRenderContext, false);
    }

    public Shape getDecoratedShape(TextNode textNode, FontRenderContext fontRenderContext) {
        return this.getOutline(textNode, fontRenderContext, true);
    }

    protected Shape getStrokeOutline(TextNode textNode, FontRenderContext fontRenderContext, boolean bl) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        BasicStroke basicStroke = (BasicStroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE);
        Shape shape = this.getOutline(textNode, fontRenderContext, bl);
        shape = shape != null && basicStroke != null ? basicStroke.createStrokedShape(shape) : null;
        return shape;
    }

    private TextSpanLayout getOffsetAdjustedTextLayout(AttributedCharacterIterator attributedCharacterIterator, Point2D point2D, FontRenderContext fontRenderContext) {
        TextSpanLayout textSpanLayout = this.getTextLayoutFactory().createTextLayout(attributedCharacterIterator, point2D, new FontRenderContext(new AffineTransform(), true, true));
        TextNode.Anchor anchor = (TextNode.Anchor)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
        int n = 0;
        if (anchor != null) {
            n = anchor.getType();
        }
        Point2D point2D2 = textSpanLayout.getAdvance2D();
        float f = 0.0f;
        float f2 = 0.0f;
        switch (n) {
            case 1: {
                f = (float)(-point2D2.getX() / 2.0);
                f2 = (float)(-point2D2.getY() / 2.0);
                break;
            }
            case 2: {
                f = (float)(-point2D2.getX());
                f2 = (float)(-point2D2.getY());
                break;
            }
        }
        Point2D point2D3 = textSpanLayout.getOffset();
        if (textSpanLayout.isVertical()) {
            textSpanLayout.setOffset(new Point2D.Float((float)point2D3.getX(), (float)point2D3.getY() + f2));
        } else {
            textSpanLayout.setOffset(new Point2D.Float((float)point2D3.getX() + f, (float)point2D3.getY()));
        }
        return textSpanLayout;
    }

    private org.apache.batik.gvt.text.Mark hitTest(double d, double d2, AttributedCharacterIterator attributedCharacterIterator, TextNode textNode, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        FontRenderContext fontRenderContext = graphicsNodeRenderContext.getFontRenderContext();
        TextSpanLayout textSpanLayout = this.getOffsetAdjustedTextLayout(attributedCharacterIterator, textNode.getLocation(), fontRenderContext);
        TextHit textHit = textSpanLayout.hitTestChar((float)d, (float)d2);
        if (attributedCharacterIterator != this.cachedACI || textHit == null || this.cachedHit == null || textHit.getCharIndex() != -1 && textHit.getInsertionIndex() != this.cachedHit.getInsertionIndex()) {
            this.cachedMark = new Mark(d, d2, textSpanLayout, textHit);
            this.cachedACI = attributedCharacterIterator;
            this.cachedHit = textHit;
        }
        return this.cachedMark;
    }

    class Mark
    implements org.apache.batik.gvt.text.Mark {
        private TextHit hit;
        private TextSpanLayout layout;
        private double x;
        private double y;

        Mark(double d, double d2, TextSpanLayout textSpanLayout, TextHit textHit) {
            this.x = d;
            this.y = d2;
            this.layout = textSpanLayout;
            this.hit = textHit;
        }

        TextHit getHit() {
            return this.hit;
        }

        TextSpanLayout getLayout() {
            return this.layout;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }
}

