/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.image.Raster;
import java.lang.ref.WeakReference;
import org.apache.batik.ext.awt.image.rendered.LRUCache;

public class TileLRUMember
implements LRUCache.LRUObj {
    private static final boolean DEBUG = false;
    private LRUCache.LRUNode myNode = null;
    private WeakReference wRaster = null;
    private Raster hRaster = null;

    public TileLRUMember() {
    }

    public TileLRUMember(Raster raster) {
        this.setRaster(raster);
    }

    public void setRaster(Raster raster) {
        this.hRaster = raster;
        this.wRaster = new WeakReference<Raster>(raster);
    }

    public boolean checkRaster() {
        if (this.hRaster != null) {
            return true;
        }
        return this.wRaster != null && this.wRaster.get() != null;
    }

    public Raster retrieveRaster() {
        if (this.hRaster != null) {
            return this.hRaster;
        }
        if (this.wRaster == null) {
            return null;
        }
        this.hRaster = (Raster)this.wRaster.get();
        if (this.hRaster == null) {
            this.wRaster = null;
        }
        return this.hRaster;
    }

    public LRUCache.LRUNode lruGet() {
        return this.myNode;
    }

    public void lruSet(LRUCache.LRUNode lRUNode) {
        this.myNode = lRUNode;
    }

    public void lruRemove() {
        this.myNode = null;
        this.hRaster = null;
    }
}

