/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import org.apache.batik.ext.awt.image.renderable.TransferFunction;

public class LinearTransfer
implements TransferFunction {
    public byte[] lutData;
    public float slope;
    public float intercept;

    public LinearTransfer(float f, float f2) {
        this.slope = f;
        this.intercept = f2;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        float f = this.intercept * 255.0f + 0.5f;
        int n = 0;
        while (n <= 255) {
            int n2 = (int)(this.slope * (float)n + f);
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            this.lutData[n] = (byte)(0xFF & n2);
            ++n;
        }
    }

    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

