/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import org.apache.batik.ext.awt.image.renderable.TransferFunction;

public class GammaTransfer
implements TransferFunction {
    public byte[] lutData;
    public float amplitude;
    public float exponent;
    public float offset;

    public GammaTransfer(float f, float f2, float f3) {
        this.amplitude = f;
        this.exponent = f2;
        this.offset = f3;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        int n = 0;
        while (n <= 255) {
            int n2 = (int)Math.round(255.0 * ((double)this.amplitude * Math.pow((float)n / 255.0f, this.exponent) + (double)this.offset));
            if (n2 > 255) {
                n2 = -1;
            } else if (n2 < 0) {
                n2 = 0;
            }
            this.lutData[n] = (byte)(n2 & 0xFF);
            ++n;
        }
    }

    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

