/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;
import org.apache.batik.ext.awt.image.rendered.RenderedImageCachableRed;

public abstract class AbstractRable
implements Filter {
    protected Vector srcs;
    protected Map props;
    protected long stamp = 0L;

    protected AbstractRable() {
    }

    protected AbstractRable(Filter filter) {
        this.init(filter, null);
    }

    protected AbstractRable(Filter filter, Map map) {
        this.init(filter, map);
    }

    protected AbstractRable(List list) {
        this(list, null);
    }

    protected AbstractRable(List list, Map map) {
        this.init(list, map);
    }

    public final void touch() {
        ++this.stamp;
    }

    public long getTimeStamp() {
        return this.stamp;
    }

    protected void init(Filter filter) {
        this.touch();
        this.srcs = new Vector(1);
        if (filter != null) {
            this.srcs.add(filter);
        }
    }

    protected void init(Filter filter, Map map) {
        this.init(filter);
        this.props = new HashMap();
        if (map != null) {
            this.props.putAll(map);
        }
    }

    protected void init(List list) {
        this.touch();
        this.srcs = new Vector(list);
    }

    protected void init(List list, Map map) {
        this.init(list);
        this.props = new HashMap();
        if (map != null) {
            this.props.putAll(map);
        }
    }

    public Rectangle2D getBounds2D() {
        Rectangle2D rectangle2D = null;
        if (this.srcs.size() != 0) {
            Iterator iterator = ((AbstractList)this.srcs).iterator();
            Filter filter = (Filter)iterator.next();
            rectangle2D = (Rectangle2D)filter.getBounds2D().clone();
            while (iterator.hasNext()) {
                filter = (Filter)iterator.next();
                Rectangle2D rectangle2D2 = filter.getBounds2D();
                Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
            }
        }
        return rectangle2D;
    }

    public Vector getSources() {
        return this.srcs;
    }

    public RenderedImage createDefaultRendering() {
        return this.createScaledRendering(100, 100, null);
    }

    public RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        float f = (float)n / this.getWidth();
        float f2 = (float)n2 / this.getHeight();
        float f3 = Math.min(f, f2);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f3, f3);
        RenderContext renderContext = new RenderContext(affineTransform, renderingHints);
        float f4 = this.getWidth() * f3 - (float)n;
        float f5 = this.getHeight() * f3 - (float)n2;
        RenderedImage renderedImage = this.createRendering(renderContext);
        CachableRed cachableRed = RenderedImageCachableRed.wrap(renderedImage);
        return new PadRed(cachableRed, new Rectangle((int)(f4 / 2.0f), (int)(f5 / 2.0f), n, n2), PadMode.ZERO_PAD, null);
    }

    public float getMinX() {
        return (float)this.getBounds2D().getX();
    }

    public float getMinY() {
        return (float)this.getBounds2D().getY();
    }

    public float getWidth() {
        return (float)this.getBounds2D().getWidth();
    }

    public float getHeight() {
        return (float)this.getBounds2D().getHeight();
    }

    public Object getProperty(String string) {
        Object object = this.props.get(string);
        if (object != null) {
            return object;
        }
        Iterator iterator = ((AbstractList)this.srcs).iterator();
        while (iterator.hasNext()) {
            RenderableImage renderableImage = (RenderableImage)iterator.next();
            object = renderableImage.getProperty(string);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public String[] getPropertyNames() {
        Set set = this.props.keySet();
        Iterator<Object> iterator = set.iterator();
        String[] stringArray = new String[set.size()];
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        iterator = ((AbstractList)this.srcs).iterator();
        while (iterator.hasNext()) {
            RenderableImage renderableImage = (RenderableImage)iterator.next();
            String[] stringArray2 = renderableImage.getPropertyNames();
            if (stringArray2.length == 0) continue;
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray3, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray3, stringArray.length, stringArray2, 0, stringArray2.length);
            stringArray = stringArray3;
        }
        return stringArray;
    }

    public boolean isDynamic() {
        return false;
    }

    public Shape getDependencyRegion(int n, Rectangle2D rectangle2D) {
        if (n < 0 || n > this.srcs.size()) {
            throw new IndexOutOfBoundsException("Nonexistant source requested.");
        }
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        Rectangle2D rectangle2D3 = this.getBounds2D();
        if (!rectangle2D3.intersects(rectangle2D2)) {
            return new Rectangle2D.Float();
        }
        Rectangle2D.intersect(rectangle2D2, rectangle2D3, rectangle2D2);
        return rectangle2D2;
    }

    public Shape getDirtyRegion(int n, Rectangle2D rectangle2D) {
        if (n < 0 || n > this.srcs.size()) {
            throw new IndexOutOfBoundsException("Nonexistant source requested.");
        }
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        Rectangle2D rectangle2D3 = this.getBounds2D();
        if (!rectangle2D3.intersects(rectangle2D2)) {
            return new Rectangle2D.Float();
        }
        Rectangle2D.intersect(rectangle2D2, rectangle2D3, rectangle2D2);
        return rectangle2D2;
    }

    public abstract RenderedImage createRendering(RenderContext var1);
}

