/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.PropertyMap;
import org.apache.batik.css.value.AbstractRGBColorFactory;
import org.apache.batik.css.value.ImmutableFloat;
import org.apache.batik.css.value.ImmutableRGBColor;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ValueConstants;
import org.apache.batik.css.value.ValueFactory;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class ColorFactory
extends AbstractRGBColorFactory
implements ValueConstants {
    public final ValueFactory RGB_FACTORY = new AbstractRGBColorFactory.ColorComponentFactory(this, this.getParser());
    public String property;
    protected static final PropertyMap values = new PropertyMap();
    protected final PropertyMap factories = new PropertyMap();

    public ColorFactory(Parser parser, String string) {
        super(parser);
        this.factories.put("black", new RGBColorFactory(0.0f, 0.0f, 0.0f));
        this.factories.put("silver", new RGBColorFactory(192.0f, 192.0f, 192.0f));
        this.factories.put("gray", new RGBColorFactory(128.0f, 128.0f, 128.0f));
        this.factories.put("white", new RGBColorFactory(255.0f, 255.0f, 255.0f));
        this.factories.put("maroon", new RGBColorFactory(128.0f, 0.0f, 0.0f));
        this.factories.put("red", new RGBColorFactory(255.0f, 0.0f, 0.0f));
        this.factories.put("purple", new RGBColorFactory(128.0f, 0.0f, 128.0f));
        this.factories.put("fuchsia", new RGBColorFactory(255.0f, 0.0f, 255.0f));
        this.factories.put("green", new RGBColorFactory(0.0f, 128.0f, 0.0f));
        this.factories.put("lime", new RGBColorFactory(0.0f, 255.0f, 0.0f));
        this.factories.put("olive", new RGBColorFactory(128.0f, 128.0f, 0.0f));
        this.factories.put("yellow", new RGBColorFactory(255.0f, 255.0f, 0.0f));
        this.factories.put("navy", new RGBColorFactory(0.0f, 0.0f, 128.0f));
        this.factories.put("blue", new RGBColorFactory(0.0f, 0.0f, 255.0f));
        this.factories.put("teal", new RGBColorFactory(0.0f, 128.0f, 128.0f));
        this.factories.put("aqua", new RGBColorFactory(0.0f, 255.0f, 255.0f));
        this.property = string;
    }

    public String getPropertyName() {
        return this.property;
    }

    public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT;
            }
            case 35: {
                String string = lexicalUnit.getStringValue().toLowerCase().intern();
                Object object = this.factories.get(string);
                if (object != null) {
                    return ((RGBColorFactory)object).create();
                }
                object = values.get(string);
                if (object != null) {
                    return (ImmutableValue)object;
                }
                throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.identifier", new Object[]{lexicalUnit.getStringValue()});
            }
        }
        return super.createValue(lexicalUnit);
    }

    public ImmutableValue createStringValue(short s, String string) throws DOMException {
        if (s != 21) {
            throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.identifier", new Object[]{string});
        }
        String string2 = string.toLowerCase().intern();
        Object object = this.factories.get(string2);
        if (object != null) {
            return ((RGBColorFactory)object).create();
        }
        object = values.get(string2);
        if (object == null) {
            throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.identifier", new Object[]{string});
        }
        return (ImmutableValue)object;
    }

    protected ImmutableRGBColor createImmutableRGBColor(float f, float f2, float f3) {
        ImmutableFloat immutableFloat = new ImmutableFloat(1, f);
        ImmutableFloat immutableFloat2 = new ImmutableFloat(1, f2);
        ImmutableFloat immutableFloat3 = new ImmutableFloat(1, f3);
        return new ImmutableRGBColor(new CSSOMValue(this.RGB_FACTORY, immutableFloat), new CSSOMValue(this.RGB_FACTORY, immutableFloat2), new CSSOMValue(this.RGB_FACTORY, immutableFloat3));
    }

    static {
        values.put("activeborder", ValueConstants.ACTIVEBORDER_VALUE);
        values.put("activecaption", ValueConstants.ACTIVECAPTION_VALUE);
        values.put("appworkspace", ValueConstants.APPWORKSPACE_VALUE);
        values.put("background", ValueConstants.BACKGROUND_VALUE);
        values.put("buttonface", ValueConstants.BUTTONFACE_VALUE);
        values.put("buttonhighlight", ValueConstants.BUTTONHIGHLIGHT_VALUE);
        values.put("buttonshadow", ValueConstants.BUTTONSHADOW_VALUE);
        values.put("buttontext", ValueConstants.BUTTONTEXT_VALUE);
        values.put("captiontext", ValueConstants.CAPTIONTEXT_VALUE);
        values.put("graytext", ValueConstants.GRAYTEXT_VALUE);
        values.put("highlight", ValueConstants.HIGHLIGHT_VALUE);
        values.put("highlighttext", ValueConstants.HIGHLIGHTTEXT_VALUE);
        values.put("inactiveborder", ValueConstants.INACTIVEBORDER_VALUE);
        values.put("inactivecaption", ValueConstants.INACTIVECAPTION_VALUE);
        values.put("inactivecaptiontext", ValueConstants.INACTIVECAPTIONTEXT_VALUE);
        values.put("infobackground", ValueConstants.INFOBACKGROUND_VALUE);
        values.put("infotext", ValueConstants.INFOTEXT_VALUE);
        values.put("menu", ValueConstants.MENU_VALUE);
        values.put("menutext", ValueConstants.MENUTEXT_VALUE);
        values.put("scrollbar", ValueConstants.SCROLLBAR_VALUE);
        values.put("threeddarkshadow", ValueConstants.THREEDDARKSHADOW_VALUE);
        values.put("threedface", ValueConstants.THREEDFACE_VALUE);
        values.put("threedhighlight", ValueConstants.THREEDHIGHLIGHT_VALUE);
        values.put("threedlightshadow", ValueConstants.THREEDLIGHTSHADOW_VALUE);
        values.put("threedshadow", ValueConstants.THREEDSHADOW_VALUE);
        values.put("window", ValueConstants.WINDOW_VALUE);
        values.put("windowframe", ValueConstants.WINDOWFRAME_VALUE);
        values.put("windowtext", ValueConstants.WINDOWTEXT_VALUE);
    }

    protected class RGBColorFactory {
        protected float red;
        protected float green;
        protected float blue;

        public RGBColorFactory(float f, float f2, float f3) {
            this.red = f;
            this.green = f2;
            this.blue = f3;
        }

        public ImmutableValue create() {
            return ColorFactory.this.createImmutableRGBColor(this.red, this.green, this.blue);
        }
    }
}

