/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.parser;

import java.io.IOException;
import java.io.Reader;
import org.apache.batik.css.parser.LexicalUnits;
import org.apache.batik.css.parser.ParseException;
import org.apache.batik.css.parser.ScannerUtilities;
import org.apache.batik.util.InputBuffer;

public class Scanner {
    protected InputBuffer inputBuffer;
    protected String uri;
    protected char[] buffer = new char[4096];
    protected String value;
    protected int type;
    protected int blankCharacters;

    public Scanner(Reader reader, String string) throws ParseException {
        try {
            this.uri = string == null ? "" : string;
            this.inputBuffer = new InputBuffer(reader);
            this.inputBuffer.setMark();
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    public int getLine() {
        return this.inputBuffer.getLine();
    }

    public int getColumn() {
        return this.inputBuffer.getColumn();
    }

    public int currentType() {
        return this.type;
    }

    public String currentValue() {
        if (this.value == null) {
            this.value = LexicalUnits.VALUES[this.type];
            if (this.value == null) {
                int n = this.inputBuffer.contentSize();
                if (this.buffer.length < n) {
                    this.buffer = new char[n];
                }
                this.inputBuffer.readContent(this.buffer);
                int n2 = this.inputBuffer.current();
                int n3 = n2 == -1 ? 0 : 1;
                switch (this.type) {
                    case 19: 
                    case 42: 
                    case 43: 
                    case 52: {
                        ++n3;
                        break;
                    }
                    case 18: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 44: 
                    case 45: 
                    case 46: {
                        n3 += 2;
                        break;
                    }
                    case 47: 
                    case 48: 
                    case 50: {
                        n3 += 3;
                        break;
                    }
                    case 49: {
                        n3 += 4;
                    }
                }
                this.value = new String(this.buffer, 0, n - n3 - this.blankCharacters);
            }
        }
        return this.value;
    }

    public String scanAtRule() throws ParseException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('@');
            int n = this.inputBuffer.current();
            block11: while (true) {
                switch (n) {
                    case 123: {
                        int n2 = 1;
                        block12: while (true) {
                            n = this.inputBuffer.next();
                            switch (n) {
                                case 125: {
                                    if (--n2 > 0) continue block12;
                                }
                                case -1: {
                                    break block11;
                                }
                                case 123: {
                                    ++n2;
                                }
                            }
                        }
                    }
                    case -1: 
                    case 59: {
                        break block11;
                    }
                    default: {
                        n = this.inputBuffer.next();
                        continue block11;
                    }
                }
                break;
            }
            stringBuffer.append(this.currentValue());
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    public int next() throws ParseException {
        try {
            this.blankCharacters = 0;
            this.inputBuffer.resetMark();
            this.value = null;
            int n = this.inputBuffer.current();
            switch (n) {
                case -1: {
                    this.type = 0;
                    return 0;
                }
                case 123: {
                    this.inputBuffer.next();
                    this.type = 1;
                    return 1;
                }
                case 125: {
                    this.inputBuffer.next();
                    this.type = 2;
                    return 2;
                }
                case 61: {
                    this.inputBuffer.next();
                    this.type = 3;
                    return 3;
                }
                case 43: {
                    this.inputBuffer.next();
                    this.type = 4;
                    return 4;
                }
                case 44: {
                    this.inputBuffer.next();
                    this.type = 6;
                    return 6;
                }
                case 59: {
                    this.inputBuffer.next();
                    this.type = 8;
                    return 8;
                }
                case 62: {
                    this.inputBuffer.next();
                    this.type = 9;
                    return 9;
                }
                case 91: {
                    this.inputBuffer.next();
                    this.type = 11;
                    return 11;
                }
                case 93: {
                    this.inputBuffer.next();
                    this.type = 12;
                    return 12;
                }
                case 42: {
                    this.inputBuffer.next();
                    this.type = 13;
                    return 13;
                }
                case 40: {
                    this.inputBuffer.next();
                    this.type = 14;
                    return 14;
                }
                case 41: {
                    this.inputBuffer.next();
                    this.type = 15;
                    return 15;
                }
                case 58: {
                    this.inputBuffer.next();
                    this.type = 16;
                    return 16;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    while (ScannerUtilities.isCSSSpace((char)(n = this.inputBuffer.next()))) {
                    }
                    this.type = 17;
                    return 17;
                }
                case 47: {
                    n = this.inputBuffer.next();
                    if (n != 42) {
                        this.type = 10;
                        return 10;
                    }
                    n = this.inputBuffer.next();
                    this.inputBuffer.resetMark();
                    while ((n = this.inputBuffer.next()) != -1 && n == 42) {
                    }
                    if (n == 47) {
                        this.inputBuffer.next();
                        this.type = 18;
                        return 18;
                    }
                    while (true) {
                        if ((n = this.inputBuffer.next()) != -1 && n != 42) {
                            continue;
                        }
                        while ((n = this.inputBuffer.next()) != -1 && n == 42) {
                        }
                        if (n == -1 || n == 47) break;
                    }
                    if (n == -1) {
                        throw new ParseException("eof", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                    }
                    this.inputBuffer.next();
                    this.type = 18;
                    return 18;
                }
                case 39: {
                    this.type = this.string1();
                    return this.type;
                }
                case 34: {
                    this.type = this.string2();
                    return this.type;
                }
                case 60: {
                    n = this.inputBuffer.next();
                    if (n != 33) {
                        throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                    }
                    n = this.inputBuffer.next();
                    if (n == 45 && (n = this.inputBuffer.next()) == 45) {
                        this.inputBuffer.next();
                        this.type = 21;
                        return 21;
                    }
                    throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                }
                case 45: {
                    n = this.inputBuffer.next();
                    if (n != 45) {
                        this.type = 5;
                        return 5;
                    }
                    n = this.inputBuffer.next();
                    if (n == 62) {
                        this.inputBuffer.next();
                        this.type = 22;
                        return 22;
                    }
                    throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                }
                case 124: {
                    n = this.inputBuffer.next();
                    if (n == 61) {
                        this.inputBuffer.next();
                        this.type = 25;
                        return 25;
                    }
                    throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                }
                case 126: {
                    n = this.inputBuffer.next();
                    if (n == 61) {
                        this.inputBuffer.next();
                        this.type = 26;
                        return 26;
                    }
                    throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                }
                case 35: {
                    n = this.inputBuffer.next();
                    if (ScannerUtilities.isCSSNameCharacter((char)n)) {
                        this.inputBuffer.resetMark();
                        do {
                            if ((n = this.inputBuffer.next()) != 92) continue;
                            n = this.escape(this.inputBuffer.next());
                        } while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n));
                        this.type = 27;
                        return 27;
                    }
                    throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                }
                case 64: {
                    n = this.inputBuffer.next();
                    switch (n) {
                        case 67: 
                        case 99: {
                            this.inputBuffer.resetMark();
                            n = this.inputBuffer.next();
                            if (!Scanner.isEqualIgnoreCase(n, 'h') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'a') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'r') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 's') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'e') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 't')) break;
                            this.inputBuffer.next();
                            this.type = 30;
                            return 30;
                        }
                        case 70: 
                        case 102: {
                            this.inputBuffer.resetMark();
                            n = this.inputBuffer.next();
                            if (!Scanner.isEqualIgnoreCase(n, 'o') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'n') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 't') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), '-') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'f') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'a') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'c') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'e')) break;
                            this.inputBuffer.next();
                            this.type = 31;
                            return 31;
                        }
                        case 73: 
                        case 105: {
                            this.inputBuffer.resetMark();
                            n = this.inputBuffer.next();
                            if (!Scanner.isEqualIgnoreCase(n, 'm') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'p') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'o') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'r') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 't')) break;
                            this.inputBuffer.next();
                            this.type = 28;
                            return 28;
                        }
                        case 77: 
                        case 109: {
                            this.inputBuffer.resetMark();
                            n = this.inputBuffer.next();
                            if (!Scanner.isEqualIgnoreCase(n, 'e') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'd') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'i') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'a')) break;
                            this.inputBuffer.next();
                            this.type = 32;
                            return 32;
                        }
                        case 80: 
                        case 112: {
                            this.inputBuffer.resetMark();
                            n = this.inputBuffer.next();
                            if (!Scanner.isEqualIgnoreCase(n, 'a') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'g') || !Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'e')) break;
                            this.inputBuffer.next();
                            this.type = 33;
                            return 33;
                        }
                        default: {
                            if (!ScannerUtilities.isCSSIdentifierStartCharacter((char)n)) {
                                throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                            }
                            this.inputBuffer.resetMark();
                        }
                    }
                    do {
                        if ((n = this.inputBuffer.next()) != 92) continue;
                        n = this.escape(this.inputBuffer.next());
                    } while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n));
                    return 29;
                }
                case 33: {
                    while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSSpace((char)n)) {
                    }
                    if (Scanner.isEqualIgnoreCase(n, 'i') && Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'm') && Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'p') && Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'o') && Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'r') && Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 't') && Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'a') && Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 'n') && Scanner.isEqualIgnoreCase(n = this.inputBuffer.next(), 't')) {
                        this.inputBuffer.next();
                        this.type = 23;
                        return 23;
                    }
                    if (n == -1) {
                        throw new ParseException("eof", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                    }
                    throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.type = this.number();
                    return this.type;
                }
                case 46: {
                    switch (this.inputBuffer.next()) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.type = this.dotNumber();
                            return this.type;
                        }
                    }
                    this.type = 7;
                    return 7;
                }
                case 85: 
                case 117: {
                    n = this.inputBuffer.next();
                    switch (n) {
                        case 43: {
                            boolean bl = false;
                            int n2 = 0;
                            while (n2 < 6) {
                                n = this.inputBuffer.next();
                                switch (n) {
                                    case 63: {
                                        bl = true;
                                        break;
                                    }
                                    default: {
                                        if (!bl || ScannerUtilities.isCSSHexadecimalCharacter((char)n)) break;
                                        throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                                    }
                                }
                                ++n2;
                            }
                            n = this.inputBuffer.next();
                            if (bl) {
                                return 53;
                            }
                            if (n == 45) {
                                n = this.inputBuffer.next();
                                if (!ScannerUtilities.isCSSHexadecimalCharacter((char)n)) {
                                    throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                                }
                                n = this.inputBuffer.next();
                                if (!ScannerUtilities.isCSSHexadecimalCharacter((char)n)) {
                                    return 53;
                                }
                                n = this.inputBuffer.next();
                                if (!ScannerUtilities.isCSSHexadecimalCharacter((char)n)) {
                                    return 53;
                                }
                                n = this.inputBuffer.next();
                                if (!ScannerUtilities.isCSSHexadecimalCharacter((char)n)) {
                                    return 53;
                                }
                                n = this.inputBuffer.next();
                                if (!ScannerUtilities.isCSSHexadecimalCharacter((char)n)) {
                                    return 53;
                                }
                                n = this.inputBuffer.next();
                                if (!ScannerUtilities.isCSSHexadecimalCharacter((char)n)) {
                                    return 53;
                                }
                                this.inputBuffer.next();
                                return 53;
                            }
                        }
                        case 82: 
                        case 114: {
                            n = this.inputBuffer.next();
                            switch (n) {
                                case 76: 
                                case 108: {
                                    n = this.inputBuffer.next();
                                    switch (n) {
                                        case 40: {
                                            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSSpace((char)n)) {
                                            }
                                            switch (n) {
                                                case 39: {
                                                    this.string1();
                                                    this.blankCharacters += 2;
                                                    n = this.inputBuffer.current();
                                                    while (n != -1 && ScannerUtilities.isCSSSpace((char)n)) {
                                                        ++this.blankCharacters;
                                                        n = this.inputBuffer.next();
                                                    }
                                                    if (n == -1) {
                                                        throw new ParseException("eof", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                                                    }
                                                    if (n != 41) {
                                                        throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                                                    }
                                                    this.inputBuffer.next();
                                                    this.type = 51;
                                                    return 51;
                                                }
                                                case 34: {
                                                    this.string2();
                                                    n = this.inputBuffer.current();
                                                    this.blankCharacters += 2;
                                                    while (n != -1 && ScannerUtilities.isCSSSpace((char)n)) {
                                                        ++this.blankCharacters;
                                                        n = this.inputBuffer.next();
                                                    }
                                                    if (n == -1) {
                                                        throw new ParseException("eof", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                                                    }
                                                    if (n != 41) {
                                                        throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                                                    }
                                                    this.inputBuffer.next();
                                                    this.type = 51;
                                                    return 51;
                                                }
                                                case 41: {
                                                    throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                                                }
                                            }
                                            if (!ScannerUtilities.isCSSURICharacter((char)n)) {
                                                throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                                            }
                                            this.inputBuffer.resetMark();
                                            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSURICharacter((char)n)) {
                                            }
                                            ++this.blankCharacters;
                                            while (n != -1 && ScannerUtilities.isCSSSpace((char)n)) {
                                                ++this.blankCharacters;
                                                n = this.inputBuffer.next();
                                            }
                                            if (n == -1) {
                                                throw new ParseException("eof", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                                            }
                                            if (n != 41) {
                                                throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                                            }
                                            this.inputBuffer.next();
                                            this.type = 51;
                                            return 51;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                        n = this.inputBuffer.next();
                    }
                    if (n == 40) {
                        this.inputBuffer.next();
                        this.type = 52;
                        return 52;
                    }
                    this.type = 20;
                    return 20;
                }
            }
            if (ScannerUtilities.isCSSIdentifierStartCharacter((char)n)) {
                do {
                    if ((n = this.inputBuffer.next()) != 92) continue;
                    n = this.escape(this.inputBuffer.next());
                } while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n));
                if (n == 40) {
                    this.inputBuffer.next();
                    this.type = 52;
                    return 52;
                }
                this.type = 20;
                return 20;
            }
            throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int string1() throws IOException {
        int n = this.inputBuffer.next();
        this.inputBuffer.resetMark();
        block9: while (true) {
            n = this.inputBuffer.next();
            switch (n) {
                case -1: {
                    throw new ParseException("eof", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                }
                case 39: {
                    break block9;
                }
                case 34: {
                    continue block9;
                }
                case 92: {
                    n = this.inputBuffer.next();
                    switch (n) {
                        case 10: 
                        case 12: {
                            continue block9;
                        }
                    }
                    n = this.escape(n);
                    continue block9;
                }
                default: {
                    if (!ScannerUtilities.isCSSStringCharacter((char)n)) throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                    continue block9;
                }
            }
            break;
        }
        this.inputBuffer.next();
        return 19;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int string2() throws IOException {
        int n = this.inputBuffer.next();
        this.inputBuffer.resetMark();
        block9: while (true) {
            n = this.inputBuffer.next();
            switch (n) {
                case -1: {
                    throw new ParseException("eof", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                }
                case 39: {
                    continue block9;
                }
                case 34: {
                    break block9;
                }
                case 92: {
                    n = this.inputBuffer.next();
                    switch (n) {
                        case 10: 
                        case 12: {
                            continue block9;
                        }
                    }
                    n = this.escape(n);
                    continue block9;
                }
                default: {
                    if (!ScannerUtilities.isCSSStringCharacter((char)n)) throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                    continue block9;
                }
            }
            break;
        }
        this.inputBuffer.next();
        return 19;
    }

    protected int number() throws IOException {
        int n;
        block7: while (true) {
            n = this.inputBuffer.next();
            switch (n) {
                case 46: {
                    switch (this.inputBuffer.next()) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            return this.dotNumber();
                        }
                    }
                    throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
                }
                default: {
                    break block7;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block7;
                }
            }
            break;
        }
        return this.numberUnit(n, true);
    }

    protected int dotNumber() throws IOException {
        int n;
        block3: while (true) {
            n = this.inputBuffer.next();
            switch (n) {
                default: {
                    break block3;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block3;
                }
            }
            break;
        }
        return this.numberUnit(n, false);
    }

    protected int numberUnit(int n, boolean bl) throws IOException {
        switch (n) {
            case 37: {
                this.inputBuffer.next();
                return 42;
            }
            case 67: 
            case 99: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 77: 
                    case 109: {
                        n = this.inputBuffer.next();
                        if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            }
                            return 34;
                        }
                        return 37;
                    }
                }
                while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                    n = this.inputBuffer.next();
                }
                return 34;
            }
            case 68: 
            case 100: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 69: 
                    case 101: {
                        n = this.inputBuffer.next();
                        switch (n) {
                            case 71: 
                            case 103: {
                                n = this.inputBuffer.next();
                                if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                                    while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                                    }
                                    return 34;
                                }
                                return 47;
                            }
                        }
                    }
                }
                while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                    n = this.inputBuffer.next();
                }
                return 34;
            }
            case 69: 
            case 101: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 77: 
                    case 109: {
                        n = this.inputBuffer.next();
                        if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            }
                            return 34;
                        }
                        return 36;
                    }
                    case 88: 
                    case 120: {
                        n = this.inputBuffer.next();
                        if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            }
                            return 34;
                        }
                        return 35;
                    }
                }
                while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                    n = this.inputBuffer.next();
                }
                return 34;
            }
            case 71: 
            case 103: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 82: 
                    case 114: {
                        n = this.inputBuffer.next();
                        switch (n) {
                            case 65: 
                            case 97: {
                                n = this.inputBuffer.next();
                                switch (n) {
                                    case 68: 
                                    case 100: {
                                        n = this.inputBuffer.next();
                                        if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                                            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                                            }
                                            return 34;
                                        }
                                        return 49;
                                    }
                                }
                            }
                        }
                    }
                }
                while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                    n = this.inputBuffer.next();
                }
                return 34;
            }
            case 72: 
            case 104: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 90: 
                    case 122: {
                        n = this.inputBuffer.next();
                        if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            }
                            return 34;
                        }
                        return 41;
                    }
                }
                while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                    n = this.inputBuffer.next();
                }
                return 34;
            }
            case 73: 
            case 105: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 78: 
                    case 110: {
                        n = this.inputBuffer.next();
                        if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            }
                            return 34;
                        }
                        return 39;
                    }
                }
                while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                    n = this.inputBuffer.next();
                }
                return 34;
            }
            case 75: 
            case 107: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 72: 
                    case 104: {
                        n = this.inputBuffer.next();
                        switch (n) {
                            case 90: 
                            case 122: {
                                n = this.inputBuffer.next();
                                if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                                    while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                                    }
                                    return 34;
                                }
                                return 50;
                            }
                        }
                    }
                }
                while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                    n = this.inputBuffer.next();
                }
                return 34;
            }
            case 77: 
            case 109: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 77: 
                    case 109: {
                        n = this.inputBuffer.next();
                        if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            }
                            return 34;
                        }
                        return 38;
                    }
                    case 83: 
                    case 115: {
                        n = this.inputBuffer.next();
                        if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            }
                            return 34;
                        }
                        return 40;
                    }
                }
                while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                    n = this.inputBuffer.next();
                }
                return 34;
            }
            case 80: 
            case 112: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 67: 
                    case 99: {
                        n = this.inputBuffer.next();
                        if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            }
                            return 34;
                        }
                        return 44;
                    }
                    case 84: 
                    case 116: {
                        n = this.inputBuffer.next();
                        if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            }
                            return 34;
                        }
                        return 45;
                    }
                    case 88: 
                    case 120: {
                        n = this.inputBuffer.next();
                        if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                            }
                            return 34;
                        }
                        return 46;
                    }
                }
                while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                    n = this.inputBuffer.next();
                }
                return 34;
            }
            case 82: 
            case 114: {
                n = this.inputBuffer.next();
                switch (n) {
                    case 65: 
                    case 97: {
                        n = this.inputBuffer.next();
                        switch (n) {
                            case 68: 
                            case 100: {
                                n = this.inputBuffer.next();
                                if (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                                    while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                                    }
                                    return 34;
                                }
                                return 48;
                            }
                        }
                    }
                }
                while (n != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
                    n = this.inputBuffer.next();
                }
                return 34;
            }
            case 83: 
            case 115: {
                this.inputBuffer.next();
                return 43;
            }
        }
        if (n != -1 && ScannerUtilities.isCSSIdentifierStartCharacter((char)n)) {
            while ((n = this.inputBuffer.next()) != -1 && ScannerUtilities.isCSSNameCharacter((char)n)) {
            }
            return 34;
        }
        return bl ? 24 : 54;
    }

    protected int escape(int n) throws IOException {
        if (ScannerUtilities.isCSSHexadecimalCharacter((char)n)) {
            n = this.inputBuffer.next();
            if (!ScannerUtilities.isCSSHexadecimalCharacter((char)n)) {
                if (ScannerUtilities.isCSSSpace((char)n)) {
                    n = this.inputBuffer.next();
                }
                return n;
            }
            n = this.inputBuffer.next();
            if (!ScannerUtilities.isCSSHexadecimalCharacter((char)n)) {
                if (ScannerUtilities.isCSSSpace((char)n)) {
                    n = this.inputBuffer.next();
                }
                return n;
            }
            n = this.inputBuffer.next();
            if (!ScannerUtilities.isCSSHexadecimalCharacter((char)n)) {
                if (ScannerUtilities.isCSSSpace((char)n)) {
                    n = this.inputBuffer.next();
                }
                return n;
            }
            n = this.inputBuffer.next();
            if (!ScannerUtilities.isCSSHexadecimalCharacter((char)n)) {
                if (ScannerUtilities.isCSSSpace((char)n)) {
                    n = this.inputBuffer.next();
                }
                return n;
            }
            n = this.inputBuffer.next();
            if (!ScannerUtilities.isCSSHexadecimalCharacter((char)n)) {
                if (ScannerUtilities.isCSSSpace((char)n)) {
                    n = this.inputBuffer.next();
                }
                return n;
            }
        }
        if (n >= 32 && n <= 126 || n >= 128) {
            n = this.inputBuffer.next();
            return n;
        }
        throw new ParseException("character", this.inputBuffer.getLine(), this.inputBuffer.getColumn());
    }

    protected static boolean isEqualIgnoreCase(int n, char c) {
        return n == -1 ? false : Character.toLowerCase((char)n) == c;
    }
}

