/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.StringReader;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.util.SVGConstants;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGViewport
implements Viewport,
SVGConstants {
    private float width;
    private float height;

    public SVGViewport(SVGSVGElement sVGSVGElement, UnitProcessor.Context context) {
        this.width = this.computeWidth(sVGSVGElement, context);
        this.height = this.computeHeight(sVGSVGElement, context);
    }

    private float computeWidth(SVGSVGElement sVGSVGElement, UnitProcessor.Context context) {
        String string = sVGSVGElement.getAttributeNS(null, "width");
        LengthParser lengthParser = new LengthParser();
        UnitProcessor.UnitResolver unitResolver = new UnitProcessor.UnitResolver();
        lengthParser.setLengthHandler(unitResolver);
        lengthParser.parse(new StringReader(string));
        return UnitProcessor.svgToUserSpace(unitResolver.unit, unitResolver.value, sVGSVGElement, (short)2, context);
    }

    private float computeHeight(SVGSVGElement sVGSVGElement, UnitProcessor.Context context) {
        String string = sVGSVGElement.getAttributeNS(null, "height");
        LengthParser lengthParser = new LengthParser();
        UnitProcessor.UnitResolver unitResolver = new UnitProcessor.UnitResolver();
        lengthParser.setLengthHandler(unitResolver);
        lengthParser.parse(new StringReader(string));
        return UnitProcessor.svgToUserSpace(unitResolver.unit, unitResolver.value, sVGSVGElement, (short)1, context);
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }
}

