/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.BasicStroke;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeEventSupport;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.ext.awt.image.renderable.Clip;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.filter.Mask;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.util.SVGConstants;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;

public class SVGTextElementBridge
implements GraphicsNodeBridge,
SVGConstants {
    protected static final Map fonts = new HashMap(11);

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Object object;
        TextNode textNode = new TextNode();
        textNode.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        String string = element.getAttributeNS(null, "transform");
        if (string.length() > 0) {
            object = SVGUtilities.convertAffineTransform(string);
            textNode.setTransform((AffineTransform)object);
        }
        object = element.getAttributeNS(null, "x");
        float f = 0.0f;
        if (((String)object).length() != 0) {
            f = SVGUtilities.svgToUserSpace(element, "x", (String)object, defaultUnitProcessorContext, (short)2);
        }
        object = element.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (((String)object).length() != 0) {
            f2 = SVGUtilities.svgToUserSpace(element, "y", (String)object, defaultUnitProcessorContext, (short)1);
        }
        textNode.setLocation(new Point2D.Float(f, f2));
        textNode.setVisible(CSSUtilities.convertVisibility(element));
        return textNode;
    }

    public void buildGraphicsNode(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element) {
        TextNode textNode = (TextNode)graphicsNode;
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        element.normalize();
        AttributedString attributedString = this.buildAttributedString(bridgeContext, element, textNode);
        textNode.setAttributedCharacterIterator(attributedString.getIterator());
        Filter filter = CSSUtilities.convertFilter(element, textNode, bridgeContext);
        textNode.setFilter(filter);
        Mask mask = CSSUtilities.convertMask(element, textNode, bridgeContext);
        textNode.setMask(mask);
        Clip clip = CSSUtilities.convertClipPath(element, textNode, bridgeContext);
        textNode.setClip(clip);
        BridgeEventSupport.addDOMListener(bridgeContext, (SVGElement)element);
        bridgeContext.bind(element, textNode);
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }

    public boolean isContainer() {
        return false;
    }

    protected AttributedString buildAttributedString(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        Object object;
        AttributedString attributedString = null;
        List list = this.buildAttributedStrings(bridgeContext, element, graphicsNode, true, new LinkedList());
        switch (list.size()) {
            case 0: {
                return new AttributedString(" ");
            }
            case 1: {
                return (AttributedString)list.get(0);
            }
        }
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            AttributedString attributedString2 = (AttributedString)iterator.next();
            object = attributedString2.getIterator();
            char c = object.first();
            while (c != '\uffff') {
                stringBuffer.append(c);
                c = object.next();
            }
        }
        attributedString = new AttributedString(stringBuffer.toString());
        int n = 0;
        iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (AttributedString)iterator.next();
            AttributedCharacterIterator attributedCharacterIterator = ((AttributedString)object).getIterator();
            Iterator<AttributedCharacterIterator.Attribute> iterator2 = attributedCharacterIterator.getAllAttributeKeys().iterator();
            while (iterator2.hasNext()) {
                int n2;
                AttributedCharacterIterator.Attribute attribute = iterator2.next();
                attributedCharacterIterator.first();
                do {
                    int n3 = attributedCharacterIterator.getRunStart(attribute);
                    n2 = attributedCharacterIterator.getRunLimit(attribute);
                    attributedCharacterIterator.setIndex(n3);
                    Object object2 = attributedCharacterIterator.getAttribute(attribute);
                    attributedString.addAttribute(attribute, object2, n + n3, n + n2);
                    attributedCharacterIterator.setIndex(n2);
                } while (n2 < attributedCharacterIterator.getEndIndex());
            }
            n += attributedCharacterIterator.getEndIndex();
        }
        return attributedString;
    }

    protected List buildAttributedStrings(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode, boolean bl, LinkedList linkedList) {
        Map map = this.getAttributeMap(bridgeContext, element, graphicsNode);
        String string = XMLSupport.getXMLSpace(element);
        boolean bl2 = string.equals("preserve");
        boolean bl3 = true;
        boolean bl4 = !bl2;
        boolean bl5 = !bl2;
        Element element2 = element;
        AttributedString attributedString = null;
        if (!linkedList.isEmpty()) {
            attributedString = (AttributedString)linkedList.getLast();
        }
        Node node = element.getFirstChild();
        while (node != null) {
            boolean bl6 = node.getNextSibling() == null;
            int n = attributedString != null ? (int)attributedString.getIterator().last() : 65535;
            bl4 = !bl2 && bl3 && (bl || n == 32 || n == 65535);
            switch (node.getNodeType()) {
                case 1: {
                    Object object;
                    Object object2;
                    Object object3;
                    element2 = (Element)node;
                    if (node.getLocalName().equals("tspan") || node.getLocalName().equals("altGlyph")) {
                        this.buildAttributedStrings(bridgeContext, element2, graphicsNode, false, linkedList);
                        break;
                    }
                    if (!node.getLocalName().equals("tref")) break;
                    try {
                        AttributedString attributedString2;
                        object3 = XLinkSupport.getXLinkHref((Element)node);
                        object2 = (SVGDocument)element.getOwnerDocument();
                        object = ((SVGOMDocument)object2).getURLObject();
                        URL uRL = new URL((URL)object, (String)object3);
                        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
                        URIResolver uRIResolver = new URIResolver((SVGDocument)object2, documentLoader);
                        Element element3 = (Element)uRIResolver.getNode(uRL.toString());
                        string = this.getElementContent(element3);
                        Map map2 = this.getAttributeMap(bridgeContext, element2, graphicsNode);
                        int[] nArray = new int[string.length()];
                        attributedString = this.createAttributedString(string, map2, nArray, bl2, bl4, bl6 && bl);
                        if (attributedString == null) break;
                        this.addGlyphPositionAttributes(attributedString, true, nArray, bridgeContext, element2);
                        boolean bl7 = bl5 = !bl2 && attributedString.getIterator().first() == ' ';
                        if (bl5 && (attributedString2 = (AttributedString)linkedList.removeLast()) != null) {
                            int n2;
                            AttributedCharacterIterator attributedCharacterIterator = attributedString2.getIterator();
                            if (attributedCharacterIterator.setIndex(n2 = attributedCharacterIterator.getEndIndex() - 1) == ' ') {
                                attributedString2 = new AttributedString(attributedString2.getIterator(null, attributedCharacterIterator.getBeginIndex(), n2));
                            }
                            linkedList.add(attributedString2);
                        }
                        linkedList.add(attributedString);
                        break;
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new IllegalAttributeValueException(Messages.formatMessage("tref.xlinkHref.badURL", null));
                    }
                    catch (Exception exception) {
                        break;
                    }
                }
                case 3: {
                    Object object;
                    Object object2;
                    string = node.getNodeValue();
                    Object object3 = new int[string.length()];
                    attributedString = this.createAttributedString(string, map, (int[])object3, bl2, bl4, bl6 && bl);
                    if (attributedString == null) break;
                    if (bl3) {
                        this.addGlyphPositionAttributes(attributedString, !bl, (int[])object3, bridgeContext, element);
                    }
                    boolean bl8 = bl5 = !bl2 && attributedString.getIterator().first() == ' ';
                    if (bl5 && !linkedList.isEmpty() && (object2 = (AttributedString)linkedList.removeLast()) != null) {
                        int n3;
                        object = ((AttributedString)object2).getIterator();
                        if (object.setIndex(n3 = object.getEndIndex() - 1) == ' ') {
                            object2 = new AttributedString(((AttributedString)object2).getIterator(null, object.getBeginIndex(), n3));
                        }
                        linkedList.add(object2);
                    }
                    linkedList.add(attributedString);
                }
            }
            bl3 = false;
            node = node.getNextSibling();
        }
        return linkedList;
    }

    protected String getElementContent(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        Node node = element.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: {
                    stringBuffer.append(this.getElementContent((Element)node));
                    break;
                }
                case 3: {
                    stringBuffer.append(node.getNodeValue());
                }
            }
            node = node.getNextSibling();
        }
        return stringBuffer.toString();
    }

    protected AttributedString createAttributedString(String string, Map map, int[] nArray, boolean bl, boolean bl2, boolean bl3) {
        AttributedString attributedString = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        stringBuffer.append(' ');
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                nArray[n] = n;
                ++n;
            }
        } else {
            int n;
            boolean bl4 = false;
            int n2 = 0;
            while (n2 < string.length()) {
                n = string.charAt(n2);
                switch (n) {
                    case 10: 
                    case 13: {
                        break;
                    }
                    case 9: 
                    case 32: {
                        if (bl4) break;
                        stringBuffer.append(' ');
                        nArray[stringBuffer.length() - 1] = n2;
                        bl4 = true;
                        break;
                    }
                    default: {
                        stringBuffer.append((char)n);
                        nArray[stringBuffer.length() - 1] = n2;
                        bl4 = false;
                    }
                }
                ++n2;
            }
            if (bl2) {
                while (stringBuffer.length() > 0) {
                    if (stringBuffer.charAt(0) != ' ') break;
                    stringBuffer.deleteCharAt(0);
                    System.arraycopy(nArray, 1, nArray, 0, stringBuffer.length());
                }
            }
            if (bl3) {
                while ((n = stringBuffer.length()) > 0) {
                    if (stringBuffer.charAt(n - '\u0001') != ' ') break;
                    stringBuffer.deleteCharAt(n - 1);
                }
            }
            n = stringBuffer.length();
            while (n < nArray.length) {
                nArray[n] = -1;
                ++n;
            }
        }
        if (stringBuffer.length() > 0) {
            attributedString = new AttributedString(stringBuffer.toString(), map);
        }
        return attributedString;
    }

    protected void addGlyphPositionAttributes(AttributedString attributedString, boolean bl, int[] nArray, BridgeContext bridgeContext, Element element) {
        int n;
        float[] fArray;
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        int n2 = attributedString.getIterator().getEndIndex();
        String string = element.getAttributeNS(null, "x");
        if (string.length() != 0) {
            fArray = SVGUtilities.svgToUserSpaceArray(element, "x", string, defaultUnitProcessorContext, (short)2);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, new Float(Float.NaN), 0, n2);
            if (fArray.length > 1 || bl) {
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.EXPLICIT_LAYOUT, new Boolean(true), 0, n2);
            }
            n = 0;
            while (n < n2) {
                if (n < fArray.length) {
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, new Float(fArray[n]), n, n + 1);
                }
                ++n;
            }
        }
        if ((string = element.getAttributeNS(null, "y")).length() != 0) {
            fArray = SVGUtilities.svgToUserSpaceArray(element, "y", string, defaultUnitProcessorContext, (short)1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, new Float(Float.NaN), 0, n2);
            if (fArray.length > 1 || bl) {
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.EXPLICIT_LAYOUT, new Boolean(true), 0, n2);
            }
            n = 0;
            while (n < n2) {
                if (n < fArray.length) {
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, new Float(fArray[n]), n, n + 1);
                }
                ++n;
            }
        }
        if ((string = element.getAttributeNS(null, "dx")).length() != 0) {
            fArray = SVGUtilities.svgToUserSpaceArray(element, "dx", string, defaultUnitProcessorContext, (short)2);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DX, new Float(Float.NaN), 0, n2);
            n = 0;
            while (n < n2) {
                if (n < fArray.length) {
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DX, new Float(fArray[n]), n, n + 1);
                }
                ++n;
            }
        }
        if ((string = element.getAttributeNS(null, "dy")).length() != 0) {
            fArray = SVGUtilities.svgToUserSpaceArray(element, "dy", string, defaultUnitProcessorContext, (short)1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DY, new Float(Float.NaN), 0, n2);
            n = 0;
            while (n < n2) {
                if (n < fArray.length) {
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DY, new Float(fArray[n]), n, n + 1);
                }
                ++n;
            }
        }
    }

    protected Map getAttributeMap(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        CSSValue cSSValue;
        BasicStroke basicStroke;
        Paint paint;
        Object object;
        Object object2;
        short s;
        float f;
        TextNode.Anchor anchor;
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER, element);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("text-anchor");
        String string = cSSPrimitiveValue.getStringValue();
        switch (string.charAt(0)) {
            case 's': {
                anchor = TextNode.Anchor.START;
                break;
            }
            case 'm': {
                anchor = TextNode.Anchor.MIDDLE;
                break;
            }
            default: {
                anchor = TextNode.Anchor.END;
            }
        }
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE, anchor);
        float f2 = CSSUtilities.convertFontSize((SVGElement)element, bridgeContext, cSSStyleDeclaration, defaultUnitProcessorContext);
        hashMap.put(TextAttribute.SIZE, new Float(f2));
        CSSValueList cSSValueList = (CSSValueList)cSSStyleDeclaration.getPropertyCSSValue("font-family");
        string = null;
        int n = 0;
        while (string == null && n < cSSValueList.getLength()) {
            cSSPrimitiveValue = (CSSPrimitiveValue)cSSValueList.item(n);
            string = (String)fonts.get(cSSPrimitiveValue.getStringValue());
            ++n;
        }
        string = string == null ? "SansSerif" : string;
        hashMap.put(TextAttribute.FAMILY, string);
        cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("font-weight");
        if (cSSPrimitiveValue.getPrimitiveType() == 21) {
            if (cSSPrimitiveValue.getStringValue().charAt(0) == 'n') {
                hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
            } else if (cSSPrimitiveValue.getStringValue().charAt(0) == 'l') {
                hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
            } else {
                hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
        } else {
            switch ((int)cSSPrimitiveValue.getFloatValue((short)1)) {
                case 100: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRA_LIGHT);
                    break;
                }
                case 200: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
                    break;
                }
                case 300: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMILIGHT);
                    break;
                }
                case 400: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
                    break;
                }
                case 500: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_SEMIBOLD);
                    break;
                }
                case 600: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                    break;
                }
                case 700: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                    break;
                }
                case 800: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                    break;
                }
                case 900: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                }
            }
        }
        cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("baseline-shift");
        if (cSSPrimitiveValue.getPrimitiveType() == 21) {
            string = cSSPrimitiveValue.getStringValue();
            switch (string.charAt(2)) {
                case 'p': {
                    hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, TextAttribute.SUPERSCRIPT_SUPER);
                    break;
                }
                case 'b': {
                    hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, TextAttribute.SUPERSCRIPT_SUB);
                    break;
                }
            }
        } else if (cSSPrimitiveValue.getPrimitiveType() == 2) {
            f = cSSPrimitiveValue.getFloatValue(cSSPrimitiveValue.getPrimitiveType());
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, new Float(f * f2 / 100.0f));
        } else {
            s = cSSPrimitiveValue.getPrimitiveType();
            f = UnitProcessor.cssToUserSpace(s, cSSPrimitiveValue.getFloatValue(s), (SVGElement)element, (short)2, defaultUnitProcessorContext);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, new Float(f));
        }
        cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("unicode-bidi");
        string = cSSPrimitiveValue.getStringValue();
        if (string.charAt(0) == 'n') {
            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(0));
        } else {
            cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("direction");
            object2 = cSSPrimitiveValue.getStringValue();
            block19 : switch (((String)object2).charAt(0)) {
                case 'l': {
                    hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    break;
                }
                case 'r': {
                    hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                    switch (string.charAt(0)) {
                        case 'b': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(-1));
                            break block19;
                        }
                        case 'e': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(1));
                        }
                    }
                }
            }
        }
        cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("writing-mode");
        string = cSSPrimitiveValue.getStringValue();
        switch (string.charAt(0)) {
            case 'l': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_LTR);
                break;
            }
            case 'r': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL);
                break;
            }
        }
        cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("font-style");
        string = cSSPrimitiveValue.getStringValue();
        switch (string.charAt(0)) {
            case 'n': {
                hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
                break;
            }
            case 'i': 
            case 'o': {
                hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
        }
        cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("font-stretch");
        string = cSSPrimitiveValue.getStringValue();
        switch (string.charAt(0)) {
            case 'u': {
                if (string.charAt(6) == 'c') {
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
                    break;
                }
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
                break;
            }
            case 'e': {
                if (string.charAt(6) == 'c') {
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
                    break;
                }
                if (string.length() == 8) {
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
                    break;
                }
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
                break;
            }
            case 's': {
                if (string.charAt(6) == 'c') {
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_CONDENSED);
                    break;
                }
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
                break;
            }
            default: {
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_REGULAR);
            }
        }
        cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("letter-spacing");
        s = cSSPrimitiveValue.getPrimitiveType();
        if (s != 21) {
            f = UnitProcessor.cssToUserSpace(s, cSSPrimitiveValue.getFloatValue(s), (SVGElement)element, (short)2, defaultUnitProcessorContext);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING, new Float(f));
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, new Boolean(true));
        }
        if ((s = (cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("word-spacing")).getPrimitiveType()) != 21) {
            f = UnitProcessor.cssToUserSpace(s, cSSPrimitiveValue.getFloatValue(s), (SVGElement)element, (short)2, defaultUnitProcessorContext);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING, new Float(f));
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, new Boolean(true));
        }
        if ((string = element.getAttributeNS(null, "kerning")).length() != 0) {
            f = SVGUtilities.svgToUserSpace(element, "kerning", string, defaultUnitProcessorContext, (short)2);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.KERNING, new Float(f));
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, new Boolean(true));
        }
        if ((string = element.getAttributeNS(null, "textLength")).length() != 0) {
            f = SVGUtilities.svgToUserSpace(element, "textLength", string, defaultUnitProcessorContext, (short)2);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH, new Float(f));
            string = element.getAttributeNS(null, "lengthAdjust");
            if (string.length() < 10) {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, new Boolean(true));
            } else {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL);
            }
        }
        if ((object2 = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("opacity")) != null) {
            object = CSSUtilities.convertOpacityToComposite((CSSPrimitiveValue)object2);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.OPACITY, object);
        }
        if ((object = CSSUtilities.convertFillToPaint((SVGElement)element, graphicsNode, bridgeContext, cSSStyleDeclaration, defaultUnitProcessorContext)) != null) {
            hashMap.put(TextAttribute.FOREGROUND, object);
        }
        if ((paint = CSSUtilities.convertStrokeToPaint((SVGElement)element, graphicsNode, bridgeContext, cSSStyleDeclaration, defaultUnitProcessorContext)) != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT, paint);
        }
        if ((basicStroke = CSSUtilities.convertStrokeToBasicStroke((SVGElement)element, bridgeContext, cSSStyleDeclaration, defaultUnitProcessorContext)) != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.STROKE, basicStroke);
        }
        if ((s = (cSSValue = cSSStyleDeclaration.getPropertyCSSValue("text-decoration")).getCssValueType()) == 2) {
            CSSValueList cSSValueList2 = (CSSValueList)cSSValue;
            int n2 = 0;
            while (n2 < cSSValueList2.getLength()) {
                cSSPrimitiveValue = (CSSPrimitiveValue)cSSValueList2.item(n2);
                string = cSSPrimitiveValue.getStringValue();
                switch (string.charAt(0)) {
                    case 'u': {
                        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE, GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_ON);
                        if (paint != null) {
                            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT, paint);
                        }
                        if (basicStroke != null) {
                            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE, basicStroke);
                        }
                        if (object == null) break;
                        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT, object);
                        break;
                    }
                    case 'o': {
                        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.OVERLINE, GVTAttributedCharacterIterator.TextAttribute.OVERLINE_ON);
                        break;
                    }
                    case 'l': {
                        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH, GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_ON);
                    }
                }
                ++n2;
            }
        }
        return hashMap;
    }

    static {
        fonts.put("serif", "Serif");
        fonts.put("Times", "Serif");
        fonts.put("Times New Roman", "Serif");
        fonts.put("sans-serif", "SansSerif");
        fonts.put("cursive", "Dialog");
        fonts.put("fantasy", "Symbol");
        fonts.put("monospace", "Monospaced");
        fonts.put("monospaced", "Monospaced");
        fonts.put("Courier", "Monospaced");
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = stringArray != null ? stringArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            fonts.put(stringArray[n2], stringArray[n2]);
            ++n2;
        }
    }
}

