/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.MaskBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.filter.GraphicsNodeRableFactory;
import org.apache.batik.gvt.filter.Mask;
import org.apache.batik.gvt.filter.MaskRable8Bit;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SVGMaskElementBridge
implements MaskBridge,
SVGConstants {
    public Mask createMask(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element, Element element2) {
        Object object;
        Object object2;
        int n;
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        Rectangle2D rectangle2D = SVGUtilities.convertMaskRegion(element, element2, graphicsNode, graphicsNodeRenderContext, defaultUnitProcessorContext);
        String string = element.getAttributeNS(null, "maskContentUnits");
        if (string.length() == 0) {
            string = "userSpaceOnUse";
        }
        try {
            n = SVGUtilities.parseCoordinateSystem(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("mask.maskContentUnits.invalid", new Object[]{string, "maskContentUnits"}));
        }
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        CompositeGraphicsNode compositeGraphicsNode2 = new CompositeGraphicsNode();
        compositeGraphicsNode.getChildren().add(compositeGraphicsNode2);
        boolean bl = false;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && (object2 = gVTBuilder.build(bridgeContext, (Element)(object = (Element)node))) != null) {
                bl = true;
                compositeGraphicsNode2.getChildren().add(object2);
            }
            node = node.getNextSibling();
        }
        if (!bl) {
            return null;
        }
        object = element.getAttributeNS(null, "transform");
        object2 = ((String)object).length() > 0 ? SVGUtilities.convertAffineTransform((String)object) : new AffineTransform();
        object2 = SVGUtilities.convertAffineTransform((AffineTransform)object2, graphicsNode, graphicsNodeRenderContext, n);
        compositeGraphicsNode2.setTransform((AffineTransform)object2);
        Filter filter = graphicsNode.getFilter();
        if (filter == null) {
            GraphicsNodeRableFactory graphicsNodeRableFactory = bridgeContext.getGraphicsNodeRableFactory();
            filter = graphicsNodeRableFactory.createGraphicsNodeRable(graphicsNode, graphicsNodeRenderContext);
        }
        return new MaskRable8Bit(filter, compositeGraphicsNode, rectangle2D);
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }
}

