/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.FilterPrimitiveBridge;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.MissingAttributeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.ComponentTransferFunction;
import org.apache.batik.ext.awt.image.renderable.ComponentTransferRable8Bit;
import org.apache.batik.ext.awt.image.renderable.ConcreteComponentTransferFunction;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SVGFeComponentTransferElementBridge
implements FilterPrimitiveBridge,
SVGConstants {
    public Filter create(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element, Element element2, Filter filter, Rectangle2D rectangle2D, Map map) {
        AbstractRable abstractRable = null;
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        String string = element.getAttributeNS(null, "in");
        filter = CSSUtilities.getFilterSource(graphicsNode, string, bridgeContext, element2, filter, map);
        if (filter == null) {
            return null;
        }
        Filter filter2 = (Filter)map.get("SourceGraphic");
        Rectangle2D rectangle2D2 = filter.getBounds2D();
        if (filter == filter2) {
            rectangle2D2 = rectangle2D;
        }
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, rectangle2D2, rectangle2D, graphicsNode, graphicsNodeRenderContext, defaultUnitProcessorContext, documentLoader);
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = n - 1;
        ComponentTransferFunction componentTransferFunction = null;
        ComponentTransferFunction componentTransferFunction2 = null;
        ComponentTransferFunction componentTransferFunction3 = null;
        ComponentTransferFunction componentTransferFunction4 = null;
        if (n2 >= 0 && (componentTransferFunction = SVGFeComponentTransferElementBridge.createComponentTransferFunction(element, nodeList.item(n2), "feFuncA")) != null) {
            --n2;
        }
        if (n2 >= 0 && (componentTransferFunction4 = SVGFeComponentTransferElementBridge.createComponentTransferFunction(element, nodeList.item(n2), "feFuncB")) != null) {
            --n2;
        }
        if (n2 >= 0 && (componentTransferFunction3 = SVGFeComponentTransferElementBridge.createComponentTransferFunction(element, nodeList.item(n2), "feFuncG")) != null) {
            --n2;
        }
        if (n2 >= 0) {
            componentTransferFunction2 = SVGFeComponentTransferElementBridge.createComponentTransferFunction(element, nodeList.item(n2), "feFuncR");
        }
        abstractRable = new ComponentTransferRable8Bit(filter, componentTransferFunction, componentTransferFunction2, componentTransferFunction3, componentTransferFunction4);
        abstractRable = new PadRable8Bit(abstractRable, rectangle2D3, PadMode.ZERO_PAD);
        String string2 = element.getAttributeNS(null, "result");
        if (string2 != null && string2.trim().length() > 0) {
            map.put(string2, abstractRable);
        }
        return abstractRable;
    }

    private static ComponentTransferFunction createComponentTransferFunction(Element element, Node node, String string) {
        Element element2;
        ComponentTransferFunction componentTransferFunction = null;
        if (node.getNodeType() == 1 && (element2 = (Element)node).getNodeName().equals(string)) {
            String string2 = element2.getAttributeNS(null, "type");
            int n = SVGFeComponentTransferElementBridge.convertType(element2, string2);
            switch (n) {
                case 0: {
                    componentTransferFunction = ConcreteComponentTransferFunction.getIdentityTransfer();
                    break;
                }
                case 1: {
                    String string3 = element2.getAttributeNS(null, "tableValues");
                    if (string3.length() == 0) {
                        componentTransferFunction = ConcreteComponentTransferFunction.getIdentityTransfer();
                        break;
                    }
                    float[] fArray = SVGFeComponentTransferElementBridge.convertTableValues(string3);
                    componentTransferFunction = ConcreteComponentTransferFunction.getTableTransfer(fArray);
                    break;
                }
                case 2: {
                    String string4 = element2.getAttributeNS(null, "tableValues");
                    if (string4.length() == 0) {
                        componentTransferFunction = ConcreteComponentTransferFunction.getIdentityTransfer();
                        break;
                    }
                    float[] fArray = SVGFeComponentTransferElementBridge.convertTableValues(string4);
                    componentTransferFunction = ConcreteComponentTransferFunction.getDiscreteTransfer(fArray);
                    break;
                }
                case 3: {
                    String string5 = element2.getAttributeNS(null, "slope");
                    float f = 1.0f;
                    if (string5.length() > 0) {
                        f = SVGUtilities.convertSVGNumber("slope", string5);
                    }
                    String string6 = element2.getAttributeNS(null, "intercept");
                    float f2 = 0.0f;
                    if (string6.length() > 0) {
                        f2 = SVGUtilities.convertSVGNumber("intercept", string6);
                    }
                    componentTransferFunction = ConcreteComponentTransferFunction.getLinearTransfer(f, f2);
                    break;
                }
                case 4: {
                    String string7 = element2.getAttributeNS(null, "amplitude");
                    float f = 1.0f;
                    if (string7.length() > 0) {
                        f = SVGUtilities.convertSVGNumber("amplitude", string7);
                    }
                    String string8 = element2.getAttributeNS(null, "exponent");
                    float f3 = 1.0f;
                    if (string8.length() > 0) {
                        f3 = SVGUtilities.convertSVGNumber("exponent", string8);
                    }
                    String string9 = element2.getAttributeNS(null, "offset");
                    float f4 = 0.0f;
                    if (string9.length() > 0) {
                        f4 = SVGUtilities.convertSVGNumber("offset", string9);
                    }
                    componentTransferFunction = ConcreteComponentTransferFunction.getGammaTransfer(f, f3, f4);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        return componentTransferFunction;
    }

    private static float[] convertTableValues(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        float[] fArray = new float[stringTokenizer.countTokens()];
        int n = 0;
        String string2 = "";
        try {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                fArray[n++] = Float.parseFloat(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feComponentTransfer.value.invalid", new Object[]{string2}));
        }
        return fArray;
    }

    private static int convertType(Element element, String string) {
        int n;
        if (string.length() == 0) {
            throw new MissingAttributeException(Messages.formatMessage("feComponentTransfer.type.required", new Object[]{element.getLocalName()}));
        }
        if ("table".equals(string)) {
            n = 1;
        } else if ("discrete".equals(string)) {
            n = 2;
        } else if ("linear".equals(string)) {
            n = 3;
        } else if ("gamma".equals(string)) {
            n = 4;
        } else if ("identity".equals(string)) {
            n = 0;
        } else {
            throw new IllegalAttributeValueException(Messages.formatMessage("feComponentTransfer.type.invalid", new Object[]{string}));
        }
        return n;
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }
}

