/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.FilterPrimitiveBridge;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.ext.awt.image.renderable.ColorMatrixRable;
import org.apache.batik.ext.awt.image.renderable.ColorMatrixRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SVGFeColorMatrixElementBridge
implements FilterPrimitiveBridge,
SVGConstants {
    public Filter create(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element, Element element2, Filter filter, Rectangle2D rectangle2D, Map map) {
        ColorMatrixRable colorMatrixRable;
        PadRable8Bit padRable8Bit = null;
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        String string = element.getAttributeNS(null, "in");
        filter = CSSUtilities.getFilterSource(graphicsNode, string, bridgeContext, element2, filter, map);
        if (filter == null) {
            return null;
        }
        Filter filter2 = (Filter)map.get("SourceGraphic");
        Rectangle2D rectangle2D2 = filter.getBounds2D();
        if (filter == filter2) {
            rectangle2D2 = rectangle2D;
        }
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, rectangle2D2, rectangle2D, graphicsNode, graphicsNodeRenderContext, defaultUnitProcessorContext, documentLoader);
        String string2 = element.getAttributeNS(null, "type");
        int n = SVGFeColorMatrixElementBridge.convertType(string2);
        String string3 = element.getAttributeNS(null, "values");
        switch (n) {
            case 0: {
                float[][] fArray = SVGFeColorMatrixElementBridge.convertValuesToMatrix(string3);
                colorMatrixRable = ColorMatrixRable8Bit.buildMatrix(fArray);
                break;
            }
            case 1: {
                float f = 1.0f;
                if (string3.length() > 0) {
                    f = CSSUtilities.convertRatio(string3);
                }
                colorMatrixRable = ColorMatrixRable8Bit.buildSaturate(f);
                break;
            }
            case 2: {
                float f = 0.0f;
                if (string3.length() > 0) {
                    f = (float)((double)SVGUtilities.convertSVGNumber("values", string3) * Math.PI / 180.0);
                }
                colorMatrixRable = ColorMatrixRable8Bit.buildHueRotate(f);
                break;
            }
            case 3: {
                colorMatrixRable = ColorMatrixRable8Bit.buildLuminanceToAlpha();
                break;
            }
            default: {
                throw new Error();
            }
        }
        colorMatrixRable.setSource(filter);
        padRable8Bit = new PadRable8Bit(colorMatrixRable, rectangle2D3, PadMode.ZERO_PAD);
        String string4 = element.getAttributeNS(null, "result");
        if (string4 != null && string4.trim().length() > 0) {
            map.put(string4, padRable8Bit);
        }
        return padRable8Bit;
    }

    private static float[][] convertValuesToMatrix(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        float[][] fArray = new float[4][5];
        if (stringTokenizer.countTokens() != 20) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feColorMatrix.values.invalid", new Object[]{string}));
        }
        int n = 0;
        String string2 = "";
        try {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                fArray[n / 5][n % 5] = Float.parseFloat(string2);
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feColorMatrix.value.invalid", new Object[]{string2}));
        }
        n = 0;
        while (n < 4) {
            float[] fArray2 = fArray[n];
            fArray2[4] = fArray2[4] * 255.0f;
            ++n;
        }
        return fArray;
    }

    private static int convertType(String string) {
        int n;
        if (string.length() == 0) {
            n = 0;
        } else if ("saturate".equals(string)) {
            n = 1;
        } else if ("hueRotate".equals(string)) {
            n = 2;
        } else if ("luminanceToAlpha".equals(string)) {
            n = 3;
        } else if ("matrix".equals(string)) {
            n = 0;
        } else {
            throw new IllegalAttributeValueException(Messages.formatMessage("feColorMatrix.type.invalid", new Object[]{string}));
        }
        return n;
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }
}

