/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.StringReader;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGSVGElement;

class BridgeEventSupport
implements SVGConstants {
    private static final String[] EVENT_ATTRIBUTES_GRAPHICS = new String[]{"onfocusin", "onfocusout", "onactivate", "onclick", "onmousedown", "onmouseup", "onmouseover", "onmouseout", "onmousemove", "onload"};
    private static final int FIRST_SVG_EVENT = 10;
    private static final String[] EVENT_ATTRIBUTES_SVG = new String[]{"onunload", "onabort", "onerror", "onresize", "onscroll", "onzoom"};
    private static final int FIRST_ANIMATION_EVENT = 16;
    private static final String[] EVENT_ATTRIBUTES_ANIMATION = new String[]{"onbegin", "onend", "onrepeat"};
    private static final String[] EVENT_NAMES = new String[]{"focusin", "focusout", "activate", "click", "mousedown", "mouseup", "mouseover", "mouseout", "mousemove", "SVGLoad", "SVGUnload", "SVGAbort", "SVGError", "SVGResize", "SVGScroll", "SVGZoom", "beginEvent", "endEvent", "repeatEvent"};

    private BridgeEventSupport() {
    }

    public static void addDOMListener(BridgeContext bridgeContext, SVGElement sVGElement) {
        UserAgent userAgent;
        int n;
        EventTarget eventTarget = null;
        try {
            eventTarget = (EventTarget)((Object)sVGElement);
        }
        catch (ClassCastException classCastException) {
            return;
        }
        SVGSVGElement sVGSVGElement = sVGElement.getOwnerSVGElement();
        if (sVGSVGElement == null) {
            if (sVGElement.getLocalName().equals("svg")) {
                sVGSVGElement = (SVGSVGElement)sVGElement;
            } else {
                return;
            }
        }
        String string = sVGSVGElement.getContentScriptType();
        Interpreter interpreter = null;
        String string2 = null;
        if (sVGElement.getLocalName().equals("svg")) {
            n = 0;
            while (n < EVENT_ATTRIBUTES_SVG.length) {
                string2 = sVGElement.getAttribute(EVENT_ATTRIBUTES_SVG[n]);
                if (!string2.equals("")) {
                    if (interpreter == null && (interpreter = bridgeContext.getInterpreterPool().getInterpreter(sVGElement.getOwnerDocument(), string)) == null) {
                        userAgent = bridgeContext.getUserAgent();
                        if (userAgent != null) {
                            userAgent.displayError("unknow language: " + string);
                        }
                        break;
                    }
                    eventTarget.addEventListener(EVENT_NAMES[n + 10], new ScriptCaller(bridgeContext.getUserAgent(), string2, interpreter), false);
                }
                ++n;
            }
        } else if (sVGElement.getLocalName().equals("set") || sVGElement.getLocalName().startsWith("animate")) {
            int n2 = 0;
            while (n2 < EVENT_ATTRIBUTES_ANIMATION.length) {
                string2 = sVGElement.getAttribute(EVENT_ATTRIBUTES_ANIMATION[n2]);
                if (!string2.equals("")) {
                    if (interpreter == null && (interpreter = bridgeContext.getInterpreterPool().getInterpreter(sVGElement.getOwnerDocument(), string)) == null) {
                        UserAgent userAgent2 = bridgeContext.getUserAgent();
                        if (userAgent2 == null) break;
                        userAgent2.displayError("unknow language: " + string);
                        break;
                    }
                    eventTarget.addEventListener(EVENT_NAMES[n2 + 16], new ScriptCaller(bridgeContext.getUserAgent(), string2, interpreter), false);
                }
                ++n2;
            }
            return;
        }
        n = 0;
        while (n < EVENT_ATTRIBUTES_GRAPHICS.length) {
            string2 = sVGElement.getAttribute(EVENT_ATTRIBUTES_GRAPHICS[n]);
            if (!string2.equals("")) {
                if (interpreter == null && (interpreter = bridgeContext.getInterpreterPool().getInterpreter(sVGElement.getOwnerDocument(), string)) == null) {
                    userAgent = bridgeContext.getUserAgent();
                    if (userAgent == null) break;
                    userAgent.displayError("unknow language: " + string);
                    break;
                }
                eventTarget.addEventListener(EVENT_NAMES[n], new ScriptCaller(bridgeContext.getUserAgent(), string2, interpreter), false);
            }
            ++n;
        }
    }

    public static void updateDOMListener(BridgeContext bridgeContext, SVGElement sVGElement) {
    }

    public static void addGVTListener(BridgeContext bridgeContext, Element element) {
        EventDispatcher eventDispatcher;
        UserAgent userAgent = bridgeContext.getUserAgent();
        if (userAgent != null && (eventDispatcher = userAgent.getEventDispatcher()) != null) {
            Listener listener = new Listener(bridgeContext, userAgent);
            eventDispatcher.addGraphicsNodeMouseListener(listener);
            ((EventTarget)((Object)element)).addEventListener("SVGUnload", new UnloadListener(eventDispatcher, listener), false);
        }
    }

    public static void loadScripts(BridgeContext bridgeContext, Document document) {
        NodeList nodeList = document.getElementsByTagName("script");
        UserAgent userAgent = bridgeContext.getUserAgent();
        String string = null;
        Element element = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            element = (Element)nodeList.item(n);
            string = element.getAttribute("type");
            Interpreter interpreter = bridgeContext.getInterpreterPool().getInterpreter(document, string);
            if (interpreter != null) {
                StringBuffer stringBuffer = new StringBuffer();
                Node node = element.getFirstChild();
                while (node != null) {
                    stringBuffer.append(node.getNodeValue());
                    node = node.getNextSibling();
                }
                try {
                    interpreter.evaluate(new StringReader(stringBuffer.toString()));
                }
                catch (IOException iOException) {
                }
                catch (InterpreterException interpreterException) {
                    if (userAgent != null) {
                        userAgent.displayError("scripting error: " + interpreterException.getMessage());
                    }
                }
            } else if (userAgent != null) {
                userAgent.displayError("unknown language: " + string);
            }
            ++n;
        }
    }

    public static class ScriptCaller
    implements EventListener {
        private static String EVENT_NAME = "evt";
        private String script = null;
        private Interpreter interpreter = null;
        private UserAgent ua = null;

        public ScriptCaller(UserAgent userAgent, String string, Interpreter interpreter) {
            this.script = string;
            this.interpreter = interpreter;
            this.ua = userAgent;
        }

        public void handleEvent(Event event) {
            block3: {
                this.interpreter.bindObject(EVENT_NAME, event);
                try {
                    this.interpreter.evaluate(new StringReader(this.script));
                }
                catch (IOException iOException) {
                }
                catch (InterpreterException interpreterException) {
                    if (this.ua == null) break block3;
                    this.ua.displayError("scripting error: " + interpreterException.getMessage());
                }
            }
        }
    }

    private static class Listener
    implements GraphicsNodeMouseListener {
        private BridgeContext context;
        private UserAgent ua;
        private GraphicsNode lastTarget;

        public Listener(BridgeContext bridgeContext, UserAgent userAgent) {
            this.context = bridgeContext;
            this.ua = userAgent;
        }

        public void mouseClicked(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("click", graphicsNodeMouseEvent, true);
        }

        public void mousePressed(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mousedown", graphicsNodeMouseEvent, true);
        }

        public void mouseReleased(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mouseup", graphicsNodeMouseEvent, true);
        }

        public void mouseEntered(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mouseover", graphicsNodeMouseEvent, true);
        }

        public void mouseExited(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mouseout", graphicsNodeMouseEvent, true);
        }

        public void mouseDragged(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            GraphicsNode graphicsNode = graphicsNodeMouseEvent.getRelatedNode();
            GraphicsNodeMouseEvent graphicsNodeMouseEvent2 = null;
            if (this.lastTarget != graphicsNode) {
                if (this.lastTarget != null) {
                    graphicsNodeMouseEvent2 = new GraphicsNodeMouseEvent(this.lastTarget, 505, graphicsNodeMouseEvent.getWhen(), graphicsNodeMouseEvent.getModifiers(), graphicsNodeMouseEvent.getX(), graphicsNodeMouseEvent.getY(), graphicsNodeMouseEvent.getClickCount(), this.lastTarget);
                    this.dispatchMouseEvent("mouseout", graphicsNodeMouseEvent2, true);
                }
                if (graphicsNode != null) {
                    graphicsNodeMouseEvent2 = new GraphicsNodeMouseEvent(graphicsNode, 504, graphicsNodeMouseEvent.getWhen(), graphicsNodeMouseEvent.getModifiers(), graphicsNodeMouseEvent.getX(), graphicsNodeMouseEvent.getY(), graphicsNodeMouseEvent.getClickCount(), this.lastTarget);
                    this.dispatchMouseEvent("mouseover", graphicsNodeMouseEvent2, true);
                }
            }
            try {
                if (graphicsNode != null) {
                    graphicsNodeMouseEvent2 = new GraphicsNodeMouseEvent(graphicsNode, 503, graphicsNodeMouseEvent.getWhen(), graphicsNodeMouseEvent.getModifiers(), graphicsNodeMouseEvent.getX(), graphicsNodeMouseEvent.getY(), graphicsNodeMouseEvent.getClickCount(), null);
                    this.dispatchMouseEvent("mousemove", graphicsNodeMouseEvent2, true);
                }
                Object var5_4 = null;
                this.lastTarget = graphicsNode;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.lastTarget = graphicsNode;
                throw throwable;
            }
        }

        public void mouseMoved(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mousemove", graphicsNodeMouseEvent, false);
        }

        private void dispatchMouseEvent(String string, GraphicsNodeMouseEvent graphicsNodeMouseEvent, boolean bl) {
            Point2D point2D = graphicsNodeMouseEvent.getPoint2D();
            AffineTransform affineTransform = this.ua.getTransform();
            if (affineTransform != null && !affineTransform.isIdentity()) {
                affineTransform.transform(point2D, point2D);
            }
            Point point = this.ua.getClientAreaLocationOnScreen();
            point.translate((int)Math.floor(point2D.getX()), (int)Math.floor(point2D.getY()));
            GraphicsNode graphicsNode = graphicsNodeMouseEvent.getGraphicsNode();
            Element element = this.context.getElement(graphicsNode);
            if (element == null) {
                return;
            }
            EventTarget eventTarget = (EventTarget)((Object)element);
            short s = 1;
            if ((0x10 & graphicsNodeMouseEvent.getModifiers()) != 0) {
                s = 0;
            } else if ((4 & graphicsNodeMouseEvent.getModifiers()) != 0) {
                s = 2;
            }
            MouseEvent mouseEvent = (MouseEvent)EventSupport.createEvent("MouseEvents");
            graphicsNode = graphicsNodeMouseEvent.getRelatedNode();
            EventTarget eventTarget2 = (EventTarget)((Object)this.context.getElement(graphicsNode));
            mouseEvent.initMouseEvent(string, true, bl, null, graphicsNodeMouseEvent.getClickCount(), point.x, point.y, (int)Math.floor(point2D.getX()), (int)Math.floor(point2D.getY()), graphicsNodeMouseEvent.isControlDown(), graphicsNodeMouseEvent.isAltDown(), graphicsNodeMouseEvent.isShiftDown(), graphicsNodeMouseEvent.isMetaDown(), s, eventTarget2);
            try {
                eventTarget.dispatchEvent(mouseEvent);
            }
            catch (RuntimeException runtimeException) {
                this.ua.displayError("scripting error in event handling: " + runtimeException.getMessage());
            }
        }
    }

    private static class UnloadListener
    implements EventListener {
        private EventDispatcher dispatcher;
        private Listener listener;

        UnloadListener(EventDispatcher eventDispatcher, Listener listener) {
            this.dispatcher = eventDispatcher;
            this.listener = listener;
        }

        public void handleEvent(Event event) {
            this.dispatcher.removeGraphicsNodeMouseListener(this.listener);
            event.getTarget().removeEventListener("SVGUnload", this, false);
        }
    }
}

