/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.Iterator;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.StyleReference;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MutationEvent;

public class BridgeDOMAttrModifiedListener
implements EventListener {
    private BridgeContext context;

    public BridgeDOMAttrModifiedListener(BridgeContext bridgeContext) {
        this.context = bridgeContext;
    }

    public void handleEvent(Event event) {
        MutationEvent mutationEvent = (MutationEvent)event;
        Element element = (Element)((Object)event.getTarget());
        GraphicsNode graphicsNode = this.context.getGraphicsNode(element);
        if (graphicsNode != null) {
            BridgeMutationEvent bridgeMutationEvent = new BridgeMutationEvent(element, this.context, 0);
            bridgeMutationEvent.setAttrName(mutationEvent.getAttrName());
            bridgeMutationEvent.setAttrNewValue(mutationEvent.getNewValue());
            bridgeMutationEvent.setGraphicsNode(graphicsNode);
            this.context.getBridgeUpdateManager().addDirtyNode(graphicsNode, bridgeMutationEvent);
        } else {
            List list = this.context.getStyleReferenceList(element);
            if (!list.isEmpty()) {
                BridgeMutationEvent bridgeMutationEvent = new BridgeMutationEvent(element, this.context, 0);
                bridgeMutationEvent.setAttrName(mutationEvent.getAttrName());
                bridgeMutationEvent.setAttrNewValue(mutationEvent.getNewValue());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    StyleReference styleReference = (StyleReference)iterator.next();
                    BridgeMutationEvent bridgeMutationEvent2 = new BridgeMutationEvent(this.context.getElement(styleReference.getGraphicsNode()), this.context, 1);
                    bridgeMutationEvent2.setGraphicsNode(styleReference.getGraphicsNode());
                    bridgeMutationEvent2.setAttrName(styleReference.getStyleAttribute());
                    bridgeMutationEvent2.setStyleMutationEvent(bridgeMutationEvent);
                    this.context.getBridgeUpdateManager().addDirtyNode(graphicsNode, bridgeMutationEvent2);
                }
            }
        }
    }
}

