/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Map;
import org.apache.velocity.util.introspection.MethodMap;

public class ClassMap {
    private static final CacheMiss CACHE_MISS = new CacheMiss();
    private static final Object OBJECT = new Object();
    private Class clazz;
    private Map methodCache = new Hashtable();
    private MethodMap methodMap = new MethodMap();

    public ClassMap(Class clazz) {
        this.clazz = clazz;
        this.populateMethodCache();
    }

    public Method findMethod(String name, Object[] params) {
        String methodKey = ClassMap.makeMethodKey(name, params);
        Object cacheEntry = this.methodCache.get(methodKey);
        if (cacheEntry == CACHE_MISS) {
            return null;
        }
        if (cacheEntry == null) {
            cacheEntry = this.methodMap.find(name, params);
            if (cacheEntry == null) {
                this.methodCache.put(methodKey, CACHE_MISS);
            } else {
                this.methodCache.put(methodKey, cacheEntry);
            }
        }
        return (Method)cacheEntry;
    }

    private void populateMethodCache() {
        Method[] methods = this.clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isPublic(methods[i].getModifiers())) {
                this.methodMap.add(methods[i]);
                this.methodCache.put(this.makeMethodKey(methods[i]), methods[i]);
            }
            ++i;
        }
    }

    private String makeMethodKey(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        StringBuffer methodKey = new StringBuffer().append(method.getName());
        int j = 0;
        while (j < parameterTypes.length) {
            if (parameterTypes[j].isPrimitive()) {
                if (parameterTypes[j].equals(Boolean.TYPE)) {
                    methodKey.append("java.lang.Boolean");
                } else if (parameterTypes[j].equals(Byte.TYPE)) {
                    methodKey.append("java.lang.Byte");
                } else if (parameterTypes[j].equals(Character.TYPE)) {
                    methodKey.append("java.lang.Character");
                } else if (parameterTypes[j].equals(Double.TYPE)) {
                    methodKey.append("java.lang.Double");
                } else if (parameterTypes[j].equals(Float.TYPE)) {
                    methodKey.append("java.lang.Float");
                } else if (parameterTypes[j].equals(Integer.TYPE)) {
                    methodKey.append("java.lang.Integer");
                } else if (parameterTypes[j].equals(Long.TYPE)) {
                    methodKey.append("java.lang.Long");
                } else if (parameterTypes[j].equals(Short.TYPE)) {
                    methodKey.append("java.lang.Short");
                }
            } else {
                methodKey.append(parameterTypes[j].getName());
            }
            ++j;
        }
        return methodKey.toString();
    }

    private static String makeMethodKey(String method, Object[] params) {
        StringBuffer methodKey = new StringBuffer().append(method);
        int j = 0;
        while (j < params.length) {
            if (params[j] == null) {
                params[j] = OBJECT;
            }
            methodKey.append(params[j].getClass().getName());
            ++j;
        }
        return methodKey.toString();
    }

    private static final class CacheMiss {
        private CacheMiss() {
        }
    }
}

