/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.context.VMContext;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.VMProxyArg;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringUtils;

public class VelocimacroProxy
extends Directive {
    private String macroName = "";
    private String macroBody = "";
    private String[] argArray = null;
    private SimpleNode nodeTree = null;
    private int numMacroArgs = 0;
    private boolean init = false;
    private String[] callingArgs;
    private int[] callingArgTypes;
    private HashMap proxyArgHash = new HashMap();
    private HashMap keyMap = new HashMap();

    public String getName() {
        return this.macroName;
    }

    public int getType() {
        return 2;
    }

    public void setName(String name) {
        this.macroName = name;
    }

    public void setArgArray(String[] arr) {
        this.argArray = arr;
        this.numMacroArgs = this.argArray.length - 1;
    }

    public void setNodeTree(SimpleNode tree) {
        this.nodeTree = tree;
    }

    public int getNumArgs() {
        return this.numMacroArgs;
    }

    public void setMacrobody(String mb) {
        this.macroBody = mb;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException {
        try {
            if (this.nodeTree != null) {
                if (!this.init) {
                    this.nodeTree.init(context, null);
                    this.init = true;
                }
                VMContext vmc = new VMContext(context);
                int i = 1;
                while (i < this.argArray.length) {
                    VMProxyArg arg = (VMProxyArg)this.proxyArgHash.get(this.argArray[i]);
                    vmc.addVMProxyArg(arg);
                    ++i;
                }
                this.nodeTree.render(vmc, writer);
            } else {
                Runtime.error("VM error : " + this.macroName + ". Null AST");
            }
        }
        catch (Exception e) {
            Runtime.error("VelocimacroProxy.render() : exception VM = #" + this.macroName + "() : " + StringUtils.stackTrace(e));
        }
        return true;
    }

    public void init(InternalContextAdapter context, Node node) throws Exception {
        int i = node.jjtGetNumChildren();
        if (this.getNumArgs() != i) {
            Runtime.error("VM #" + this.macroName + ": error : too few arguments to macro. Wanted " + this.getNumArgs() + " got " + i + "  -->");
            return;
        }
        this.callingArgs = this.getArgArray(node);
        this.setupMacro(this.callingArgs, this.callingArgTypes);
    }

    public boolean setupMacro(String[] callArgs, int[] callArgTypes) {
        this.setupProxyArgs(callArgs, callArgTypes);
        this.parseTree();
        return true;
    }

    private void parseTree() {
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(this.macroBody.getBytes());
            this.nodeTree = Runtime.parse(inStream, "VM:" + this.macroName);
        }
        catch (Exception e) {
            Runtime.error("VelocimacroManager.parseTree() : exception " + this.macroName + " : " + StringUtils.stackTrace(e));
        }
    }

    private void setupProxyArgs(String[] callArgs, int[] callArgTypes) {
        int i = 1;
        while (i < this.argArray.length) {
            VMProxyArg arg = new VMProxyArg(this.argArray[i], callArgs[i - 1], callArgTypes[i - 1]);
            this.proxyArgHash.put(this.argArray[i], arg);
            ++i;
        }
    }

    private String[] getArgArray(Node node) {
        int numArgs = node.jjtGetNumChildren();
        String[] args = new String[numArgs];
        this.callingArgTypes = new int[numArgs];
        int i = 0;
        Token t = null;
        Token tLast = null;
        while (i < numArgs) {
            args[i] = "";
            this.callingArgTypes[i] = node.jjtGetChild(i).getType();
            t = node.jjtGetChild(i).getFirstToken();
            tLast = node.jjtGetChild(i).getLastToken();
            while (t != tLast) {
                int n = i;
                args[n] = args[n] + t.image;
                t = t.next;
            }
            int n = i++;
            args[n] = args[n] + t.image;
        }
        return args;
    }
}

