/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import java.util.Hashtable;
import org.apache.log.Category;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.output.DefaultOutputLogTarget;

public final class LogEngine {
    protected final Hashtable m_loggers = new Hashtable();
    protected final Hashtable m_categories = new Hashtable();
    protected final Hashtable m_logTargets;
    protected Priority.Enum m_priority = Priority.DEBUG;
    protected LogTarget m_defaultLogTarget;

    public void addLogTarget(String string, LogTarget logTarget) {
        if (string.equals("default")) {
            this.m_defaultLogTarget = logTarget;
        }
        this.m_logTargets.put(string, logTarget);
    }

    public LogTarget getLogTarget(String string) {
        return (LogTarget)this.m_logTargets.get(string);
    }

    public Category createCategory(String string, Priority.Enum enum_) {
        Category category = (Category)this.m_categories.get(string);
        if (category == null) {
            category = new Category(string);
            this.m_categories.put(string, category);
        }
        category.setPriority(enum_);
        return category;
    }

    public Logger createLogger(Category category) {
        return this.createLogger(category, null);
    }

    public Logger createLogger(Category category, LogTarget[] logTargetArray) {
        String string = category.getName();
        Logger logger = (Logger)this.m_loggers.get(string);
        if (logger == null) {
            int n = string.lastIndexOf(46);
            Logger logger2 = null;
            if (-1 != n) {
                String string2 = string.substring(0, n);
                logger2 = this.getLoggerFor(string2);
            }
            logger = new Logger(this, category, logTargetArray, logger2);
            this.m_loggers.put(string, logger);
        } else if (logTargetArray != null) {
            logger.setLogTargets(logTargetArray);
        }
        return logger;
    }

    public LogTarget getDefaultLogTarget() {
        return this.m_defaultLogTarget;
    }

    public Priority.Enum getGlobalPriority() {
        return this.m_priority;
    }

    public Logger getLoggerFor(String string) {
        Hashtable hashtable = this.m_loggers;
        synchronized (hashtable) {
            Logger logger = (Logger)this.m_loggers.get(string);
            if (logger == null) {
                logger = this.createLogger(this.createCategory(string, Priority.DEBUG));
            }
            Logger logger2 = logger;
            Object var3_5 = null;
            return logger2;
        }
    }

    public void log(String string, Throwable throwable) {
        System.err.println("Error: " + string);
        throwable.printStackTrace();
    }

    public void log(String string) {
        System.err.println("Error: " + string);
    }

    public void setDefaultLogTarget(LogTarget logTarget) {
        this.addLogTarget("default", logTarget);
        this.m_defaultLogTarget = logTarget;
    }

    public void setGlobalPriority(Priority.Enum enum_) {
        this.m_priority = enum_;
    }

    public LogEngine() {
        this.m_logTargets = new Hashtable();
        this.m_defaultLogTarget = new DefaultOutputLogTarget();
        this.m_logTargets.put("default", this.m_defaultLogTarget);
    }
}

