/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.net;

import com.oroinc.net.ftp.FTPClient;
import com.oroinc.net.ftp.FTPFile;
import com.oroinc.net.ftp.FTPReply;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class FTP
extends Task {
    protected static final int SEND_FILES = 0;
    protected static final int GET_FILES = 1;
    protected static final int DEL_FILES = 2;
    protected static final int LIST_FILES = 3;
    private String remotedir;
    private String server;
    private String userid;
    private String password;
    private File listing;
    private boolean binary = true;
    private boolean passive = false;
    private boolean verbose = false;
    private boolean newerOnly = false;
    private int action = 0;
    private Vector filesets = new Vector();
    private Vector dirCache = new Vector();
    private int transferred = 0;
    private String remoteFileSep = "/";
    private int port = 21;
    protected static final String[] ACTION_STRS = new String[]{"sending", "getting", "deleting", "listing"};
    protected static final String[] COMPLETED_ACTION_STRS = new String[]{"sent", "retrieved", "deleted", "listed"};

    public void setRemotedir(String string) {
        this.remotedir = string;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setUserid(String string) {
        this.userid = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setBinary(boolean bl) {
        this.binary = bl;
    }

    public void setPassive(boolean bl) {
        this.passive = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setNewer(boolean bl) {
        this.newerOnly = bl;
    }

    public void setDepends(boolean bl) {
        this.newerOnly = bl;
    }

    public void setSeparator(String string) {
        this.remoteFileSep = string;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void setAction(String string) throws BuildException {
        if (string.toLowerCase().equals("send") || string.toLowerCase().equals("put")) {
            this.action = 0;
        } else if (string.toLowerCase().equals("recv") || string.toLowerCase().equals("get")) {
            this.action = 1;
        } else if (string.toLowerCase().equals("del") || string.toLowerCase().equals("delete")) {
            this.action = 2;
        } else if (string.toLowerCase().equals("list")) {
            this.action = 3;
        } else {
            throw new BuildException("action " + string + " is not supported");
        }
    }

    public void setListing(File file) throws BuildException {
        this.listing = file;
    }

    protected void checkConfiguration() throws BuildException {
        if (this.server == null) {
            throw new BuildException("server attribute must be set!");
        }
        if (this.userid == null) {
            throw new BuildException("userid attribute must be set!");
        }
        if (this.password == null) {
            throw new BuildException("password attribute must be set!");
        }
        if (this.action == 3 && this.listing == null) {
            throw new BuildException("listing attribute must be set for list action!");
        }
    }

    protected int transferFiles(FTPClient fTPClient, FileSet fileSet) throws IOException, BuildException {
        DirectoryScanner directoryScanner;
        if (this.action == 0) {
            directoryScanner = fileSet.getDirectoryScanner(this.project);
        } else {
            directoryScanner = new FTPDirectoryScanner(fTPClient);
            fileSet.setupDirectoryScanner((FileScanner)directoryScanner, this.project);
            directoryScanner.scan();
        }
        String[] stringArray = directoryScanner.getIncludedFiles();
        String string = null;
        if (directoryScanner.getBasedir() == null && (this.action == 0 || this.action == 1)) {
            throw new BuildException("the dir attribute must be set for send and get actions");
        }
        if (this.action == 0 || this.action == 1) {
            string = directoryScanner.getBasedir().getAbsolutePath();
        }
        BufferedWriter bufferedWriter = null;
        if (this.action == 3) {
            File file = new File(this.listing.getParent());
            if (!file.exists()) {
                file.mkdirs();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(this.listing));
        }
        int n = 0;
        while (n < stringArray.length) {
            switch (this.action) {
                case 0: {
                    this.sendFile(fTPClient, string, stringArray[n]);
                    break;
                }
                case 1: {
                    this.getFile(fTPClient, string, stringArray[n]);
                    break;
                }
                case 2: {
                    this.delFile(fTPClient, stringArray[n]);
                    break;
                }
                case 3: {
                    this.listFile(fTPClient, bufferedWriter, stringArray[n]);
                    break;
                }
                default: {
                    throw new BuildException("unknown ftp action " + this.action);
                }
            }
            ++n;
        }
        if (this.action == 3) {
            bufferedWriter.close();
        }
        return stringArray.length;
    }

    protected void transferFiles(FTPClient fTPClient) throws IOException, BuildException {
        this.transferred = 0;
        if (this.filesets.size() == 0) {
            throw new BuildException("at least one fileset must be specified.");
        }
        int n = 0;
        while (n < this.filesets.size()) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(n);
            if (fileSet != null) {
                this.transferFiles(fTPClient, fileSet);
            }
            ++n;
        }
        this.log(this.transferred + " files " + COMPLETED_ACTION_STRS[this.action]);
    }

    protected String resolveFile(String string) {
        return string.replace(System.getProperty("file.separator").charAt(0), this.remoteFileSep.charAt(0));
    }

    protected void createParents(FTPClient fTPClient, String string) throws IOException, BuildException {
        String string2;
        Vector<File> vector = new Vector<File>();
        File file = new File(string);
        while ((string2 = file.getParent()) != null) {
            file = new File(string2);
            vector.addElement(file);
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            file = (File)vector.elementAt(n);
            if (!this.dirCache.contains(file)) {
                this.log("creating remote directory " + this.resolveFile(file.getPath()), 3);
                fTPClient.makeDirectory(this.resolveFile(file.getPath()));
                if (!FTPReply.isPositiveCompletion((int)fTPClient.getReplyCode()) && fTPClient.getReplyCode() != 550 && fTPClient.getReplyCode() != 553) {
                    throw new BuildException("could not create directory: " + fTPClient.getReplyString());
                }
                this.dirCache.addElement(file);
            }
            --n;
        }
    }

    protected boolean isUpToDate(FTPClient fTPClient, File file, String string) throws IOException, BuildException {
        this.log("checking date for " + string, 3);
        FTPFile[] fTPFileArray = fTPClient.listFiles(string);
        if (!FTPReply.isPositiveCompletion((int)fTPClient.getReplyCode())) {
            throw new BuildException("could not date test remote file: " + fTPClient.getReplyString());
        }
        if (fTPFileArray == null) {
            return false;
        }
        long l = fTPFileArray[0].getTimestamp().getTime().getTime();
        long l2 = file.lastModified();
        if (this.action == 0) {
            return l > l2;
        }
        return l2 > l;
    }

    /*
     * Unable to fully structure code
     */
    protected void sendFile(FTPClient var1_1, String var2_2, String var3_3) throws IOException, BuildException {
        var4_4 = null;
        try {
            var5_5 = this.project.resolveFile(new File(var2_2, var3_3).getPath());
            if (!this.newerOnly || !this.isUpToDate(var1_1, var5_5, this.resolveFile(var3_3))) break block11;
            var7_6 = null;
            ** if (var4_4 == null) goto lbl-1000
        }
        catch (Throwable var6_12) {
            var7_8 = null;
            if (var4_4 != null) {
                try {
                    var4_4.close();
                }
                catch (IOException var8_11) {
                    // empty catch block
                }
            }
            throw var6_12;
        }
lbl-1000:
        // 1 sources

        {
            try {
                var4_4.close();
            }
            catch (IOException var8_9) {
                // empty catch block
            }
        }
lbl-1000:
        // 3 sources

        {
            block11: {
                return;
            }
            if (this.verbose) {
                this.log("transferring " + var5_5.getAbsolutePath());
            }
            var4_4 = new BufferedInputStream(new FileInputStream(var5_5));
            this.createParents(var1_1, var3_3);
            var1_1.storeFile(this.resolveFile(var3_3), var4_4);
            if (!FTPReply.isPositiveCompletion((int)var1_1.getReplyCode())) {
                throw new BuildException("could not transfer file: " + var1_1.getReplyString());
            }
            this.log("File " + var5_5.getAbsolutePath() + " copied to " + this.server, 3);
            ++this.transferred;
        }
        var7_7 = null;
        if (var4_4 != null) {
            try {
                var4_4.close();
            }
            catch (IOException var8_10) {}
        }
    }

    protected void delFile(FTPClient fTPClient, String string) throws IOException, BuildException {
        if (this.verbose) {
            this.log("deleting " + string);
        }
        if (!fTPClient.deleteFile(this.resolveFile(string))) {
            throw new BuildException("could not delete file: " + fTPClient.getReplyString());
        }
        this.log("File " + string + " deleted from " + this.server, 3);
        ++this.transferred;
    }

    /*
     * Unable to fully structure code
     */
    protected void getFile(FTPClient var1_1, String var2_2, String var3_3) throws IOException, BuildException {
        var4_4 = null;
        try {
            var5_5 = this.project.resolveFile(new File(var2_2, var3_3).getPath());
            if (!this.newerOnly || !this.isUpToDate(var1_1, var5_5, this.resolveFile(var3_3))) break block12;
            var8_6 = null;
            ** if (var4_4 == null) goto lbl-1000
        }
        catch (Throwable var7_13) {
            var8_8 = null;
            if (var4_4 != null) {
                try {
                    var4_4.close();
                }
                catch (IOException var9_11) {
                    // empty catch block
                }
            }
            throw var7_13;
        }
lbl-1000:
        // 1 sources

        {
            try {
                var4_4.close();
            }
            catch (IOException var9_9) {
                // empty catch block
            }
        }
lbl-1000:
        // 3 sources

        {
            block12: {
                return;
            }
            if (this.verbose) {
                this.log("transferring " + var3_3 + " to " + var5_5.getAbsolutePath());
            }
            if (!(var6_12 = new File(var5_5.getParent())).exists()) {
                var6_12.mkdirs();
            }
            var4_4 = new BufferedOutputStream(new FileOutputStream(var5_5));
            var1_1.retrieveFile(this.resolveFile(var3_3), var4_4);
            if (!FTPReply.isPositiveCompletion((int)var1_1.getReplyCode())) {
                throw new BuildException("could not transfer file: " + var1_1.getReplyString());
            }
            this.log("File " + var5_5.getAbsolutePath() + " copied from " + this.server, 3);
            ++this.transferred;
        }
        var8_7 = null;
        if (var4_4 != null) {
            try {
                var4_4.close();
            }
            catch (IOException var9_10) {}
        }
    }

    protected void listFile(FTPClient fTPClient, BufferedWriter bufferedWriter, String string) throws IOException, BuildException {
        if (this.verbose) {
            this.log("listing " + string);
        }
        FTPFile fTPFile = fTPClient.listFiles(this.resolveFile(string))[0];
        bufferedWriter.write(fTPFile.toString());
        bufferedWriter.newLine();
        ++this.transferred;
    }

    public void execute() throws BuildException {
        this.checkConfiguration();
        FTPClient fTPClient = null;
        try {
            try {
                this.log("Opening FTP connection to " + this.server, 3);
                fTPClient = new FTPClient();
                fTPClient.connect(this.server, this.port);
                if (!FTPReply.isPositiveCompletion((int)fTPClient.getReplyCode())) {
                    throw new BuildException("FTP connection failed: " + fTPClient.getReplyString());
                }
                this.log("connected", 3);
                this.log("logging in to FTP server", 3);
                if (!fTPClient.login(this.userid, this.password)) {
                    throw new BuildException("Could not login to FTP server");
                }
                this.log("login succeeded", 3);
                if (this.binary) {
                    fTPClient.setFileType(2);
                    if (!FTPReply.isPositiveCompletion((int)fTPClient.getReplyCode())) {
                        throw new BuildException("could not set transfer type: " + fTPClient.getReplyString());
                    }
                }
                if (this.passive) {
                    this.log("entering passive mode", 3);
                    fTPClient.enterLocalPassiveMode();
                    if (!FTPReply.isPositiveCompletion((int)fTPClient.getReplyCode())) {
                        throw new BuildException("could not enter into passive mode: " + fTPClient.getReplyString());
                    }
                }
                if (this.remotedir != null) {
                    this.log("changing the remote directory", 3);
                    fTPClient.changeWorkingDirectory(this.remotedir);
                    if (!FTPReply.isPositiveCompletion((int)fTPClient.getReplyCode())) {
                        throw new BuildException("could not change remote directory: " + fTPClient.getReplyString());
                    }
                }
                this.log(ACTION_STRS[this.action] + " files");
                this.transferFiles(fTPClient);
            }
            catch (IOException iOException) {
                throw new BuildException("error during FTP transfer: " + iOException);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            throw throwable;
        }
    }

    protected class FTPDirectoryScanner
    extends DirectoryScanner {
        protected FTPClient ftp = null;

        public FTPDirectoryScanner(FTPClient fTPClient) {
            this.ftp = fTPClient;
        }

        public void scan() {
            if (this.includes == null) {
                this.includes = new String[1];
                this.includes[0] = "**";
            }
            if (this.excludes == null) {
                this.excludes = new String[0];
            }
            this.filesIncluded = new Vector();
            this.filesNotIncluded = new Vector();
            this.filesExcluded = new Vector();
            this.dirsIncluded = new Vector();
            this.dirsNotIncluded = new Vector();
            this.dirsExcluded = new Vector();
            try {
                String string = this.ftp.printWorkingDirectory();
                this.scandir(".", "", true);
                this.ftp.changeWorkingDirectory(string);
            }
            catch (IOException iOException) {
                throw new BuildException("Unable to scan FTP server: ", (Throwable)iOException);
            }
        }

        protected void scandir(String string, String string2, boolean bl) {
            try {
                if (!this.ftp.changeWorkingDirectory(string)) {
                    return;
                }
                FTPFile[] fTPFileArray = this.ftp.listFiles();
                if (fTPFileArray == null) {
                    return;
                }
                int n = 0;
                while (n < fTPFileArray.length) {
                    FTPFile fTPFile = fTPFileArray[n];
                    String string3 = string2 + fTPFile.getName();
                    if (fTPFile.isDirectory()) {
                        if (this.isIncluded(string3)) {
                            if (!this.isExcluded(string3)) {
                                this.dirsIncluded.addElement(string3);
                                if (bl) {
                                    this.scandir(string3, string3 + File.separator, bl);
                                }
                            } else {
                                this.dirsExcluded.addElement(string3);
                            }
                        } else {
                            this.dirsNotIncluded.addElement(string3);
                            if (bl && this.couldHoldIncluded(string3)) {
                                this.scandir(string3, string3 + File.separator, bl);
                            }
                        }
                        if (!bl) {
                            this.scandir(string3, string3 + File.separator, bl);
                        }
                    } else if (fTPFile.isFile()) {
                        if (this.isIncluded(string3)) {
                            if (!this.isExcluded(string3)) {
                                this.filesIncluded.addElement(string3);
                            } else {
                                this.filesExcluded.addElement(string3);
                            }
                        } else {
                            this.filesNotIncluded.addElement(string3);
                        }
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Error while communicating with FTP server: ", (Throwable)iOException);
            }
        }
    }
}

