/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import com.ibm.ivj.util.base.IvjException;
import com.ibm.ivj.util.base.ProjectEdition;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ide.VAJUtil;
import org.apache.tools.ant.taskdefs.optional.ide.VAJWorkspaceScanner;

public class VAJLoadProjects
extends Task {
    Vector projectDescriptions = new Vector();
    Vector expandedProjectDescriptions = new Vector();

    public VAJProjectDescription createVAJProject() {
        VAJProjectDescription vAJProjectDescription = new VAJProjectDescription();
        this.projectDescriptions.addElement(vAJProjectDescription);
        return vAJProjectDescription;
    }

    public void execute() {
        this.expandDescriptions();
        this.log("Loading " + this.expandedProjectDescriptions.size() + " project(s) into workspace");
        Enumeration enumeration = this.expandedProjectDescriptions.elements();
        while (enumeration.hasMoreElements()) {
            VAJProjectDescription vAJProjectDescription = (VAJProjectDescription)enumeration.nextElement();
            ProjectEdition projectEdition = VAJLoadProjects.findProjectEdition(vAJProjectDescription.getName(), vAJProjectDescription.getVersion());
            try {
                this.log("Loading " + vAJProjectDescription.getName() + ", Version " + vAJProjectDescription.getVersion() + ", into Workspace", 3);
                projectEdition.loadIntoWorkspace();
            }
            catch (IvjException ivjException) {
                throw VAJUtil.createBuildException("Project " + vAJProjectDescription.getName() + " could not be loaded.", ivjException);
            }
        }
    }

    public void expandDescriptions() {
        VAJProjectDescription vAJProjectDescription;
        Enumeration enumeration;
        String[] stringArray;
        try {
            stringArray = VAJUtil.getWorkspace().getRepository().getProjectNames();
        }
        catch (IvjException ivjException) {
            throw VAJUtil.createBuildException("VA Exception occured: ", ivjException);
        }
        int n = 0;
        while (n < stringArray.length) {
            enumeration = this.projectDescriptions.elements();
            while (enumeration.hasMoreElements()) {
                vAJProjectDescription = (VAJProjectDescription)enumeration.nextElement();
                String string = vAJProjectDescription.getName();
                if (!VAJWorkspaceScanner.match(string, stringArray[n])) continue;
                vAJProjectDescription.setProjectFound();
                this.expandedProjectDescriptions.addElement(new VAJProjectDescription(stringArray[n], vAJProjectDescription.getVersion()));
                break;
            }
            ++n;
        }
        enumeration = this.projectDescriptions.elements();
        while (enumeration.hasMoreElements()) {
            vAJProjectDescription = (VAJProjectDescription)enumeration.nextElement();
            if (vAJProjectDescription.projectFound()) continue;
            this.log("No Projects match the name " + vAJProjectDescription.getName(), 1);
        }
    }

    public static Vector findMatchingProjects(String string) {
        String[] stringArray;
        try {
            stringArray = VAJUtil.getWorkspace().getRepository().getProjectNames();
        }
        catch (IvjException ivjException) {
            throw VAJUtil.createBuildException("VA Exception occured: ", ivjException);
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (VAJWorkspaceScanner.match(string, stringArray[n])) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        return vector;
    }

    public static ProjectEdition findProjectEdition(String string, String string2) {
        try {
            ProjectEdition[] projectEditionArray = null;
            projectEditionArray = VAJUtil.getWorkspace().getRepository().getProjectEditions(string);
            if (projectEditionArray == null) {
                throw new BuildException("Project " + string + " doesn't exist");
            }
            ProjectEdition projectEdition = null;
            int n = 0;
            while (n < projectEditionArray.length && projectEdition == null) {
                if (string2.equals(projectEditionArray[n].getVersionName())) {
                    projectEdition = projectEditionArray[n];
                }
                ++n;
            }
            if (projectEdition == null) {
                throw new BuildException("Version " + string2 + " of Project " + string + " doesn't exist");
            }
            return projectEdition;
        }
        catch (IvjException ivjException) {
            throw VAJUtil.createBuildException("VA Exception occured: ", ivjException);
        }
    }

    public class VAJProjectDescription {
        private String name;
        private String version;
        private boolean projectFound;

        public VAJProjectDescription() {
        }

        public VAJProjectDescription(String string, String string2) {
            this.name = string;
            this.version = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean projectFound() {
            return this.projectFound;
        }

        public void setName(String string) {
            if (string == null || string.equals("")) {
                throw new BuildException("name attribute must be set");
            }
            this.name = string;
        }

        public void setProjectFound() {
            this.projectFound = true;
        }

        public void setVersion(String string) {
            if (string == null || string.equals("")) {
                throw new BuildException("version attribute must be set");
            }
            this.version = string;
        }
    }
}

