/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFile;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFileUtils;
import org.apache.tools.ant.types.Path;

public class Depend
extends MatchingTask {
    private Path srcPath;
    private Path destPath;
    private File cache;
    private Hashtable affectedClassMap;
    private Hashtable classFileInfoMap;
    private Vector outOfDateClasses;
    private boolean closure = false;

    private void writeDependencyList(File file, Vector vector) throws IOException {
        PrintWriter printWriter = null;
        try {
            String string = file.getParent();
            if (string != null) {
                new File(string).mkdirs();
            }
            printWriter = new PrintWriter(new FileWriter(file));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.println(enumeration.nextElement());
            }
            Object var7_6 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector readDependencyList(File file) throws IOException {
        Vector<String> vector = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            vector = new Vector<String>();
            while ((string = bufferedReader.readLine()) != null) {
                vector.addElement(string);
            }
            Object var6_5 = null;
            if (bufferedReader == null) return vector;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return vector;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void determineDependencies() throws IOException {
        this.affectedClassMap = new Hashtable();
        this.classFileInfoMap = new Hashtable();
        Enumeration enumeration = this.getClassFiles(this.destPath).elements();
        block2: while (true) {
            Object object;
            Object object2;
            Vector vector;
            ClassFileInfo classFileInfo;
            block10: {
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                classFileInfo = (ClassFileInfo)enumeration.nextElement();
                this.log("Adding class info for " + classFileInfo.className, 4);
                this.classFileInfoMap.put(classFileInfo.className, classFileInfo);
                vector = null;
                if (this.cache != null && ((File)(object2 = new File(this.cache, classFileInfo.relativeName + ".dep"))).exists() && ((File)object2).lastModified() > classFileInfo.absoluteFile.lastModified()) {
                    vector = this.readDependencyList((File)object2);
                }
                if (vector == null) {
                    Object var8_11;
                    object2 = null;
                    try {
                        object2 = new FileInputStream(classFileInfo.absoluteFile);
                        object = new ClassFile();
                        ((ClassFile)object).read((InputStream)object2);
                        vector = ((ClassFile)object).getClassRefs();
                        if (this.cache != null) {
                            File file = new File(this.cache, classFileInfo.relativeName + ".dep");
                            this.writeDependencyList(file, vector);
                        }
                        var8_11 = null;
                        if (object2 == null) break block10;
                    }
                    catch (Throwable throwable) {
                        var8_11 = null;
                        if (object2 != null) {
                            ((FileInputStream)object2).close();
                        }
                        throw throwable;
                    }
                    ((FileInputStream)object2).close();
                }
            }
            object2 = vector.elements();
            while (true) {
                void var6_10;
                if (!object2.hasMoreElements()) continue block2;
                object = (String)object2.nextElement();
                Hashtable hashtable = (Hashtable)this.affectedClassMap.get(object);
                if (hashtable == null) {
                    Hashtable hashtable2 = new Hashtable();
                    this.affectedClassMap.put(object, hashtable2);
                }
                var6_10.put(classFileInfo.className, classFileInfo);
            }
            break;
        }
    }

    private void deleteAllAffectedFiles() {
        Enumeration enumeration = this.outOfDateClasses.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.deleteAffectedFiles(string);
        }
    }

    private void deleteAffectedFiles(String string) {
        Hashtable hashtable = (Hashtable)this.affectedClassMap.get(string);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                ClassFileInfo classFileInfo = (ClassFileInfo)hashtable.get(string2);
                if (!classFileInfo.absoluteFile.exists()) continue;
                this.log("Deleting file " + classFileInfo.absoluteFile.getPath() + " since " + string + " out of date", 3);
                classFileInfo.absoluteFile.delete();
                if (this.closure) {
                    this.deleteAffectedFiles(string2);
                    continue;
                }
                if (string2.indexOf("$") == -1) continue;
                String string3 = string2.substring(0, string2.indexOf("$"));
                this.log("Top level class = " + string3, 3);
                ClassFileInfo classFileInfo2 = (ClassFileInfo)this.classFileInfoMap.get(string3);
                if (classFileInfo2 == null || !classFileInfo2.absoluteFile.exists()) continue;
                this.log("Deleting file " + classFileInfo2.absoluteFile.getPath() + " since " + "one of its inner classes was removed", 3);
                classFileInfo2.absoluteFile.delete();
                if (!this.closure) continue;
                this.deleteAffectedFiles(string3);
            }
        }
    }

    public void execute() throws BuildException {
        try {
            long l = System.currentTimeMillis();
            String[] stringArray = this.srcPath.list();
            if (stringArray.length == 0) {
                throw new BuildException("srcdir attribute must be set!", ((Task)this).location);
            }
            if (this.destPath == null) {
                this.destPath = this.srcPath;
            }
            if (this.cache != null && this.cache.exists() && !this.cache.isDirectory()) {
                throw new BuildException("The cache, if specified, must point to a directory");
            }
            if (this.cache != null && !this.cache.exists()) {
                this.cache.mkdirs();
            }
            this.determineDependencies();
            this.outOfDateClasses = new Vector();
            int n = 0;
            while (n < stringArray.length) {
                File file = ((Task)this).project.resolveFile(stringArray[n]);
                if (file.exists()) {
                    DirectoryScanner directoryScanner = this.getDirectoryScanner(file);
                    String[] stringArray2 = directoryScanner.getIncludedFiles();
                    this.scanDir(file, stringArray2);
                }
                ++n;
            }
            this.deleteAllAffectedFiles();
            this.log("Duration = " + (System.currentTimeMillis() - l));
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    protected void scanDir(File file, String[] stringArray) {
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (stringArray[n].endsWith(".java")) {
                String string = file2.getPath();
                String string2 = string.substring(file.getPath().length() + 1, string.length() - ".java".length());
                ClassFileInfo classFileInfo = (ClassFileInfo)this.classFileInfoMap.get(string2 = ClassFileUtils.convertSlashName(string2));
                if (classFileInfo == null) {
                    this.outOfDateClasses.addElement(string2);
                } else if (file2.lastModified() > classFileInfo.absoluteFile.lastModified()) {
                    this.outOfDateClasses.addElement(string2);
                }
            }
            ++n;
        }
    }

    private Vector getClassFiles(Path path) {
        String[] stringArray = path.list();
        Vector vector = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(stringArray[n]);
            if (file.isDirectory()) {
                this.addClassFiles(vector, file, file);
            }
            ++n;
        }
        return vector;
    }

    private void addClassFiles(Vector vector, File file, File file2) {
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file3 = new File(file, stringArray[n2]);
                if (file3.isDirectory()) {
                    this.addClassFiles(vector, file3, file2);
                } else if (file3.getName().endsWith(".class")) {
                    ClassFileInfo classFileInfo = new ClassFileInfo();
                    classFileInfo.absoluteFile = file3;
                    classFileInfo.relativeName = file3.getPath().substring(file2.getPath().length() + 1, file3.getPath().length() - 6);
                    classFileInfo.className = ClassFileUtils.convertSlashName(classFileInfo.relativeName);
                    vector.addElement(classFileInfo);
                }
                ++n2;
            }
        }
    }

    public void setSrcdir(Path path) {
        this.srcPath = path;
    }

    public void setDestDir(Path path) {
        this.destPath = path;
    }

    public void setCache(File file) {
        this.cache = file;
    }

    public void setClosure(boolean bl) {
        this.closure = bl;
    }

    private static class ClassFileInfo {
        public File absoluteFile;
        public String relativeName;
        public String className;

        private ClassFileInfo() {
        }
    }
}

