/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.CommandlineJava;

public class ANTLR
extends Task {
    private CommandlineJava commandline = new CommandlineJava();
    private File target;
    private File outputDirectory;
    private boolean fork = false;
    private File dir;

    public ANTLR() {
        this.commandline.setVm("java");
        this.commandline.setClassname("antlr.Tool");
    }

    public void setTarget(File file) {
        this.log("Setting target to: " + file.toString(), 3);
        this.target = file;
    }

    public void setOutputdirectory(File file) {
        this.log("Setting output directory to: " + file.toString(), 3);
        this.outputDirectory = file;
    }

    public void setFork(boolean bl) {
        this.fork = bl;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        if (this.target.lastModified() > this.getGeneratedFile().lastModified()) {
            this.commandline.createArgument().setValue("-o");
            this.commandline.createArgument().setValue(this.outputDirectory.toString());
            this.commandline.createArgument().setValue(this.target.toString());
            if (this.fork) {
                this.log("Forking " + this.commandline.toString(), 3);
                int n = this.run(this.commandline.getCommandline());
                if (n == 1) {
                    throw new BuildException("ANTLR returned: " + n, this.location);
                }
            } else {
                Execute.runCommand((Task)this, (String[])this.commandline.getCommandline());
            }
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.target == null || !this.target.isFile()) {
            throw new BuildException("Invalid target: " + this.target);
        }
        if (this.outputDirectory == null) {
            String string = this.target.toString();
            this.setOutputdirectory(new File(this.target.getParent()));
        }
        if (!this.outputDirectory.isDirectory()) {
            throw new BuildException("Invalid output directory: " + this.outputDirectory);
        }
        if (this.fork && (this.dir == null || !this.dir.isDirectory())) {
            throw new BuildException("Invalid working directory: " + this.dir);
        }
    }

    private File getGeneratedFile() throws BuildException {
        String string = null;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.target));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(" extends ");
                if (!string2.startsWith("class ") || n <= -1) continue;
                string = string2.substring(6, n).trim();
                break;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new BuildException("Unable to determine generated class");
        }
        if (string == null) {
            throw new BuildException("Unable to determine generated class");
        }
        return new File(this.outputDirectory, string + ".java");
    }

    private int run(String[] stringArray) throws BuildException {
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), null);
        execute.setAntRun(this.project);
        execute.setWorkingDirectory(this.dir);
        execute.setCommandline(stringArray);
        try {
            return execute.execute();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException, this.location);
        }
    }
}

