/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.dom.svg.SVGArea;
import org.apache.fop.extensions.ExtensionObj;
import org.apache.fop.extensions.Outline;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.LinkedRectangle;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.SpanArea;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.render.pdf.SVGRenderer;
import org.w3c.dom.svg.SVGSVGElement;

public class PDFRenderer
implements Renderer {
    private static final boolean OPTIMIZE_TEXT = true;
    protected PDFDocument pdfDoc;
    protected PDFResources pdfResources;
    protected IDReferences idReferences;
    PDFStream currentStream;
    PDFAnnotList currentAnnotList;
    PDFPage currentPage;
    protected String currentFontName;
    protected int currentFontSize;
    protected PDFPathPaint currentStroke = null;
    protected PDFPathPaint currentFill = null;
    protected float currentRed = 0.0f;
    protected float currentGreen = 0.0f;
    protected float currentBlue = 0.0f;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    private int currentAreaContainerXPosition = 0;
    private PDFColor currentColour = new PDFColor(0, 0, 0);
    int prevUnderlineXEndPos;
    int prevUnderlineYEndPos;
    int prevUnderlineSize;
    PDFColor prevUnderlineColor;
    int prevOverlineXEndPos;
    int prevOverlineYEndPos;
    int prevOverlineSize;
    PDFColor prevOverlineColor;
    int prevLineThroughXEndPos;
    int prevLineThroughYEndPos;
    int prevLineThroughSize;
    PDFColor prevLineThroughColor;
    boolean textOpen = false;
    int prevWordY = 0;
    int prevWordX = 0;
    int prevWordWidth = 0;
    boolean useKerning;
    private PDFOutline rootOutline;

    public PDFRenderer() {
        this.pdfDoc = new PDFDocument();
        String string = Configuration.getStringValue("use-kerning");
        this.useKerning = "yes".equals(string) || "true".equals(string);
    }

    private StringBuffer addKerning(String string, String string2, Hashtable hashtable) {
        Integer n;
        Hashtable hashtable2 = (Hashtable)hashtable.get(string);
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        if (hashtable2 != null && (n = (Integer)hashtable2.get(string2)) != null) {
            n2 = -n.intValue();
            stringBuffer = stringBuffer.append(") " + n2 + " (");
        }
        return stringBuffer;
    }

    protected void addLine(int n, int n2, int n3, int n4, int n5, String string, PDFPathPaint pDFPathPaint) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + pDFPathPaint.getColorSpaceOut(false) + string + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " m " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " l " + (float)n5 / 1000.0f + " w S\n" + "Q\nBT\n");
    }

    protected void addLine(int n, int n2, int n3, int n4, int n5, PDFPathPaint pDFPathPaint) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + pDFPathPaint.getColorSpaceOut(false) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " m " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " l " + (float)n5 / 1000.0f + " w S\n" + "Q\nBT\n");
    }

    protected void addRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + pDFPathPaint.getColorSpaceOut(false) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " re s\n" + "Q\nBT\n");
    }

    protected void addRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint, PDFPathPaint pDFPathPaint2) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + pDFPathPaint2.getColorSpaceOut(true) + pDFPathPaint.getColorSpaceOut(false) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " re b\n" + "Q\nBT\n");
    }

    private void closeText() {
        if (this.textOpen) {
            this.currentStream.add("] TJ\n");
            this.textOpen = false;
            this.prevWordX = 0;
            this.prevWordY = 0;
        }
    }

    private void doFrame(Area area) {
        int n = this.currentAreaContainerXPosition;
        int n2 = area.getContentWidth();
        if (area instanceof BlockArea) {
            n += ((BlockArea)area).getStartIndent();
        }
        int n3 = area.getContentHeight();
        int n4 = this.currentYPosition;
        ColorType colorType = area.getBackgroundColor();
        n -= area.getPaddingLeft();
        n4 += area.getPaddingTop();
        n2 = n2 + area.getPaddingLeft() + area.getPaddingRight();
        n3 = n3 + area.getPaddingTop() + area.getPaddingBottom();
        if (colorType != null && colorType.alpha() == 0.0f) {
            this.addRect(n, n4, n2, -n3, new PDFColor(colorType), new PDFColor(colorType));
        }
        n -= area.borderWidthLeft;
        n4 += area.borderWidthTop;
        n2 = n2 + area.borderWidthLeft + area.borderWidthRight;
        n3 = n3 + area.borderWidthTop + area.borderWidthBottom;
        if (area.borderWidthTop != 0) {
            this.addLine(n, n4, n + n2, n4, area.borderWidthTop, new PDFColor(area.borderColorTop));
        }
        if (area.borderWidthLeft != 0) {
            this.addLine(n, n4, n, n4 - n3, area.borderWidthLeft, new PDFColor(area.borderColorLeft));
        }
        if (area.borderWidthRight != 0) {
            this.addLine(n + n2, n4, n + n2, n4 - n3, area.borderWidthRight, new PDFColor(area.borderColorRight));
        }
        if (area.borderWidthBottom != 0) {
            this.addLine(n, n4 - n3, n + n2, n4 - n3, area.borderWidthBottom, new PDFColor(area.borderColorBottom));
        }
    }

    public void render(AreaTree areaTree, OutputStream outputStream) throws IOException, FOPException {
        MessageHandler.logln("rendering areas to PDF");
        this.idReferences = areaTree.getIDReferences();
        this.pdfResources = this.pdfDoc.getResources();
        this.pdfDoc.setIDReferences(this.idReferences);
        Enumeration enumeration = areaTree.getPages().elements();
        while (enumeration.hasMoreElements()) {
            this.renderPage((Page)enumeration.nextElement());
        }
        if (!this.idReferences.isEveryIdValid()) {
            MessageHandler.errorln("WARNING: The following id's were referenced but not found: " + this.idReferences.getInvalidIds() + "\n");
        }
        this.renderRootExtensions(areaTree);
        MessageHandler.logln("writing out PDF");
        this.pdfDoc.output(outputStream);
    }

    public void renderAreaContainer(AreaContainer areaContainer) {
        int n = this.currentYPosition;
        int n2 = this.currentAreaContainerXPosition;
        if (areaContainer.getPosition() == 3) {
            this.currentYPosition = areaContainer.getYPosition() - 2 * areaContainer.getPaddingTop() - 2 * areaContainer.borderWidthTop;
            this.currentAreaContainerXPosition = areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 2) {
            this.currentYPosition -= areaContainer.getYPosition();
            this.currentAreaContainerXPosition += areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 1) {
            this.currentYPosition -= areaContainer.getPaddingTop() + areaContainer.borderWidthTop;
            this.currentAreaContainerXPosition += areaContainer.getPaddingLeft() + areaContainer.borderWidthLeft;
        }
        this.currentXPosition = this.currentAreaContainerXPosition;
        this.doFrame(areaContainer);
        Enumeration enumeration = areaContainer.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        if (areaContainer.getPosition() != 1) {
            this.currentYPosition = n;
            this.currentAreaContainerXPosition = n2;
        } else {
            this.currentYPosition -= areaContainer.getHeight();
        }
    }

    public void renderBlockArea(BlockArea blockArea) {
        this.doFrame(blockArea);
        Enumeration enumeration = blockArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    public void renderBodyAreaContainer(BodyAreaContainer bodyAreaContainer) {
        int n = this.currentYPosition;
        int n2 = this.currentAreaContainerXPosition;
        if (bodyAreaContainer.getPosition() == 3) {
            this.currentYPosition = bodyAreaContainer.getYPosition();
            this.currentAreaContainerXPosition = bodyAreaContainer.getXPosition();
        } else if (bodyAreaContainer.getPosition() == 2) {
            this.currentYPosition -= bodyAreaContainer.getYPosition();
            this.currentAreaContainerXPosition += bodyAreaContainer.getXPosition();
        }
        this.currentXPosition = this.currentAreaContainerXPosition;
        int n3 = this.currentAreaContainerXPosition;
        int n4 = bodyAreaContainer.getContentWidth();
        int n5 = bodyAreaContainer.getContentHeight();
        int n6 = this.currentYPosition;
        ColorType colorType = bodyAreaContainer.getBackgroundColor();
        if (colorType != null && colorType.alpha() == 0.0f) {
            this.addRect(n3, n6, n4, -n5, new PDFColor(colorType), new PDFColor(colorType));
        }
        this.renderAreaContainer(bodyAreaContainer.getBeforeFloatReferenceArea());
        this.renderAreaContainer(bodyAreaContainer.getFootnoteReferenceArea());
        Enumeration enumeration = bodyAreaContainer.getMainReferenceArea().getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        if (bodyAreaContainer.getPosition() != 1) {
            this.currentYPosition = n;
            this.currentAreaContainerXPosition = n2;
        } else {
            this.currentYPosition -= bodyAreaContainer.getHeight();
        }
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        int n = displaySpace.getSize();
        this.currentYPosition -= n;
    }

    public void renderForeignObjectArea(ForeignObjectArea foreignObjectArea) {
        this.currentXPosition += foreignObjectArea.getXOffset();
        this.currentYPosition = this.currentYPosition;
        switch (foreignObjectArea.getAlign()) {
            default: 
        }
        switch (foreignObjectArea.getVerticalAlign()) {
            default: 
        }
        this.closeText();
        this.currentStream.add("ET\n");
        this.currentStream.add("q\n");
        switch (foreignObjectArea.scalingMethod()) {
            default: 
        }
        switch (foreignObjectArea.getOverflow()) {
            default: 
        }
        foreignObjectArea.getObject().render(this);
        this.currentStream.add("Q\n");
        this.currentStream.add("BT\n");
        this.currentXPosition += foreignObjectArea.getEffectiveWidth();
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentAreaContainerXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        this.currentYPosition -= n4;
        FopImage fopImage = imageArea.getImage();
        if (fopImage instanceof SVGImage) {
            try {
                this.closeText();
                SVGSVGElement sVGSVGElement = ((SVGImage)fopImage).getSVGDocument().getRootElement();
                this.currentStream.add("ET\nq\n" + (float)n3 / 1000.0f + " 0 0 " + (float)n4 / 1000.0f + " " + (float)n / 1000.0f + " " + (float)(n2 - n4) / 1000.0f + " cm\n");
                this.currentStream.add("Q\nBT\n");
            }
            catch (FopImageException fopImageException) {}
        } else {
            int n5 = this.pdfDoc.addImage(fopImage);
            this.closeText();
            this.currentStream.add("ET\nq\n" + (float)n3 / 1000.0f + " 0 0 " + (float)n4 / 1000.0f + " " + (float)n / 1000.0f + " " + (float)(n2 - n4) / 1000.0f + " cm\n" + "/Im" + n5 + " Do\nQ\nBT\n");
        }
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        this.currentXPosition += inlineSpace.getSize();
        if (inlineSpace.getUnderlined() && this.prevUnderlineColor != null) {
            this.addLine(this.prevUnderlineXEndPos, this.prevUnderlineYEndPos, this.prevUnderlineXEndPos + inlineSpace.getSize(), this.prevUnderlineYEndPos, this.prevUnderlineSize, this.prevUnderlineColor);
        }
        if (inlineSpace.getOverlined() && this.prevOverlineColor != null) {
            this.addLine(this.prevOverlineXEndPos, this.prevOverlineYEndPos, this.prevOverlineXEndPos + inlineSpace.getSize(), this.prevOverlineYEndPos, this.prevOverlineSize, this.prevOverlineColor);
        }
        if (inlineSpace.getLineThrough() && this.prevLineThroughColor != null) {
            this.addLine(this.prevLineThroughXEndPos, this.prevLineThroughYEndPos, this.prevLineThroughXEndPos + inlineSpace.getSize(), this.prevLineThroughYEndPos, this.prevLineThroughSize, this.prevLineThroughColor);
        }
    }

    public void renderLeaderArea(LeaderArea leaderArea) {
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        int n3 = leaderArea.getContentWidth();
        int n4 = leaderArea.getHeight();
        int n5 = leaderArea.getRuleThickness();
        int n6 = leaderArea.getRuleStyle();
        String string = this.setRuleStylePattern(n6);
        if (n5 != 0) {
            switch (n6) {
                case 5: {
                    this.addLine(n, n2, n + n3, n2, n5 / 3, string, new PDFColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue()));
                    this.addLine(n, n2 + 2 * n5 / 3, n + n3, n2 + 2 * n5 / 3, n5 / 3, string, new PDFColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue()));
                    break;
                }
                case 6: {
                    this.addLine(n, n2, n + n3, n2, n5 / 2, string, new PDFColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue()));
                    this.addLine(n, n2 + n5 / 2, n + n3, n2 + n5 / 2, n5 / 2, string, new PDFColor(255, 255, 255));
                    break;
                }
                case 7: {
                    this.addLine(n, n2, n + n3, n2, n5 / 2, string, new PDFColor(255, 255, 255));
                    this.addLine(n, n2 + n5 / 2, n + n3, n2 + n5 / 2, n5 / 2, string, new PDFColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue()));
                    break;
                }
                default: {
                    this.addLine(n, n2, n + n3, n2, n5, string, new PDFColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue()));
                }
            }
            this.currentXPosition += leaderArea.getContentWidth();
            this.currentYPosition += n5;
        }
    }

    public void renderLineArea(LineArea lineArea) {
        int n = this.currentAreaContainerXPosition + lineArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = lineArea.getContentWidth();
        int n4 = lineArea.getHeight();
        this.currentYPosition -= lineArea.getPlacementOffset();
        this.currentXPosition = n;
        int n5 = this.currentYPosition;
        Enumeration enumeration = lineArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            if (box instanceof InlineArea) {
                InlineArea inlineArea = (InlineArea)box;
                this.currentYPosition = n2 - inlineArea.getYOffset();
            } else {
                this.currentYPosition = n2 - lineArea.getPlacementOffset();
            }
            box.render(this);
        }
        this.currentYPosition = n2 - n4;
        this.currentXPosition = n;
    }

    private void renderOutline(Outline outline) {
        Object object;
        if (this.rootOutline == null) {
            this.rootOutline = this.pdfDoc.makeOutlineRoot();
        }
        PDFOutline pDFOutline = null;
        Outline outline2 = outline.getParentOutline();
        if (outline2 == null) {
            pDFOutline = this.pdfDoc.makeOutline(this.rootOutline, outline.getLabel().toString(), outline.getInternalDestination());
        } else {
            object = (PDFOutline)outline2.getRendererObject();
            if (object == null) {
                MessageHandler.errorln("Error: pdfParentOutline is null");
            } else {
                pDFOutline = this.pdfDoc.makeOutline((PDFOutline)object, outline.getLabel().toString(), outline.getInternalDestination());
            }
        }
        outline.setRendererObject(pDFOutline);
        object = outline.getOutlines();
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            this.renderOutline((Outline)enumeration.nextElement());
        }
    }

    public void renderPage(Page page) {
        this.currentStream = this.pdfDoc.makeStream();
        BodyAreaContainer bodyAreaContainer = page.getBody();
        AreaContainer areaContainer = page.getBefore();
        AreaContainer areaContainer2 = page.getAfter();
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.currentStream.add("BT\n");
        this.renderBodyAreaContainer(bodyAreaContainer);
        if (areaContainer != null) {
            this.renderAreaContainer(areaContainer);
        }
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
        this.closeText();
        this.currentStream.add("ET\n");
        this.currentPage = this.pdfDoc.makePage(this.pdfResources, this.currentStream, page.getWidth() / 1000, page.getHeight() / 1000, page);
        if (page.hasLinks()) {
            this.currentAnnotList = this.pdfDoc.makeAnnotList();
            this.currentPage.setAnnotList(this.currentAnnotList);
            Enumeration enumeration = page.getLinkSets().elements();
            while (enumeration.hasMoreElements()) {
                LinkSet linkSet = (LinkSet)enumeration.nextElement();
                linkSet.align();
                String string = linkSet.getDest();
                int n = linkSet.getLinkType();
                Enumeration enumeration2 = linkSet.getRects().elements();
                while (enumeration2.hasMoreElements()) {
                    LinkedRectangle linkedRectangle = (LinkedRectangle)enumeration2.nextElement();
                    this.currentAnnotList.addLink(this.pdfDoc.makeLink(linkedRectangle.getRectangle(), string, n));
                }
            }
        } else {
            this.currentAnnotList = null;
        }
    }

    protected void renderRootExtensions(AreaTree areaTree) {
        Vector vector = areaTree.getExtensions();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ExtensionObj extensionObj = (ExtensionObj)enumeration.nextElement();
                if (!(extensionObj instanceof Outline)) continue;
                this.renderOutline((Outline)extensionObj);
            }
        }
    }

    public void renderSVGArea(SVGArea sVGArea) {
        Object object;
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        SVGSVGElement sVGSVGElement = sVGArea.getSVGDocument().getRootElement();
        int n3 = (int)(sVGSVGElement.getWidth().getBaseVal().getValue() * 1000.0f);
        int n4 = (int)(sVGSVGElement.getHeight().getBaseVal().getValue() * 1000.0f);
        float f = 1.0f;
        float f2 = -1.0f;
        int n5 = n;
        int n6 = n2;
        if (sVGSVGElement.getViewBox() != null) {
            object = sVGSVGElement.getViewBox().getBaseVal();
            f = sVGSVGElement.getWidth().getBaseVal().getValue() / object.getWidth();
            f2 = sVGSVGElement.getHeight().getBaseVal().getValue() / object.getHeight();
            n5 -= (int)(f * object.getX() * 1000.0f);
            n6 -= (int)(f2 * object.getY() * 1000.0f);
            f2 = -f2;
        }
        this.currentStream.add("q\n");
        if (n3 != 0 && n4 != 0) {
            this.currentStream.add(String.valueOf((float)n / 1000.0f) + " " + (float)n2 / 1000.0f + " m\n");
            this.currentStream.add(String.valueOf((float)(n + n3) / 1000.0f) + " " + (float)n2 / 1000.0f + " l\n");
            this.currentStream.add(String.valueOf((float)(n + n3) / 1000.0f) + " " + (float)(n2 - n4) / 1000.0f + " l\n");
            this.currentStream.add(String.valueOf((float)n / 1000.0f) + " " + (float)(n2 - n4) / 1000.0f + " l\n");
            this.currentStream.add("h\n");
            this.currentStream.add("W\n");
            this.currentStream.add("n\n");
        }
        this.currentStream.add(String.valueOf(f) + " 0 0 " + f2 + " " + (float)n5 / 1000.0f + " " + (float)n6 / 1000.0f + " cm\n");
        object = new SVGRenderer(sVGArea.getFontState(), this.pdfDoc, this.currentFontName, this.currentFontSize, this.currentXPosition, this.currentYPosition);
        ((SVGRenderer)object).renderSVG(sVGSVGElement, 0, 0);
        this.currentStream.add(((SVGRenderer)object).getString());
        this.currentStream.add("Q\n");
    }

    public void renderSpanArea(SpanArea spanArea) {
        Enumeration enumeration = spanArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    public void renderWordArea(WordArea wordArea) {
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable hashtable = null;
        boolean bl = false;
        if (this.useKerning && (hashtable = wordArea.getFontState().getKerning()) != null && !hashtable.isEmpty()) {
            bl = true;
        }
        String string2 = wordArea.getFontState().getFontName();
        int n2 = wordArea.getFontState().getFontSize();
        PDFColor pDFColor = new PDFColor(wordArea.getRed(), wordArea.getGreen(), wordArea.getBlue());
        if (!string2.equals(this.currentFontName) || n2 != this.currentFontSize) {
            this.closeText();
            this.currentFontName = string2;
            this.currentFontSize = n2;
            stringBuffer = stringBuffer.append("/" + string2 + " " + n2 / 1000 + " Tf\n");
        }
        if (!pDFColor.equals(this.currentFill)) {
            this.closeText();
            this.currentFill = pDFColor;
            stringBuffer.append(this.currentFill.getColorSpaceOut(true));
        }
        int n3 = this.currentXPosition;
        int n4 = this.currentYPosition;
        if (wordArea.getUnderlined()) {
            n = n4 - n2 / 10;
            this.addLine(n3, n, n3 + wordArea.getContentWidth(), n, n2 / 14, pDFColor);
            this.prevUnderlineXEndPos = n3 + wordArea.getContentWidth();
            this.prevUnderlineYEndPos = n;
            this.prevUnderlineSize = n2 / 14;
            this.prevUnderlineColor = pDFColor;
        }
        if (wordArea.getOverlined()) {
            n = n4 + wordArea.getFontState().getAscender() + n2 / 10;
            this.addLine(n3, n, n3 + wordArea.getContentWidth(), n, n2 / 14, pDFColor);
            this.prevOverlineXEndPos = n3 + wordArea.getContentWidth();
            this.prevOverlineYEndPos = n;
            this.prevOverlineSize = n2 / 14;
            this.prevOverlineColor = pDFColor;
        }
        if (wordArea.getLineThrough()) {
            n = n4 + wordArea.getFontState().getAscender() * 3 / 8;
            this.addLine(n3, n, n3 + wordArea.getContentWidth(), n, n2 / 14, pDFColor);
            this.prevLineThroughXEndPos = n3 + wordArea.getContentWidth();
            this.prevLineThroughYEndPos = n;
            this.prevLineThroughSize = n2 / 14;
            this.prevLineThroughColor = pDFColor;
        }
        if (!this.textOpen || n4 != this.prevWordY) {
            this.closeText();
            stringBuffer.append("1 0 0 1 " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " Tm [(");
            this.prevWordY = n4;
            this.textOpen = true;
        } else {
            n = this.prevWordX - n3 + this.prevWordWidth;
            float f = (float)n / (float)this.currentFontSize * 1000.0f;
            stringBuffer.append(String.valueOf(f) + " (");
        }
        this.prevWordWidth = wordArea.getContentWidth();
        this.prevWordX = n3;
        if (wordArea.getPageNumberID() != null) {
            string = this.idReferences.getPageNumber(wordArea.getPageNumberID());
            if (string == null) {
                string = "";
            }
        } else {
            string = wordArea.getText();
        }
        int n5 = string.length();
        int n6 = 0;
        while (n6 < n5) {
            char c = string.charAt(n6);
            String string3 = "";
            if (c > '\u007f') {
                stringBuffer.append("\\");
                stringBuffer.append(Integer.toOctalString(c));
            } else {
                switch (c) {
                    case '(': 
                    case ')': 
                    case '\\': {
                        string3 = "\\";
                        break;
                    }
                }
                stringBuffer.append(String.valueOf(string3) + c);
            }
            if (bl && n6 + 1 < n5) {
                stringBuffer.append((Object)this.addKerning(new Character(c).toString(), new Character(string.charAt(n6 + 1)).toString(), hashtable));
            }
            ++n6;
        }
        stringBuffer.append(") ");
        this.currentStream.add(stringBuffer.toString());
        this.currentXPosition += wordArea.getContentWidth();
    }

    public void setProducer(String string) {
        this.pdfDoc.setProducer(string);
    }

    private String setRuleStylePattern(int n) {
        String string = "";
        switch (n) {
            case 4: {
                string = "[] 0 d ";
                break;
            }
            case 3: {
                string = "[3 3] 0 d ";
                break;
            }
            case 2: {
                string = "[1 3] 0 d ";
                break;
            }
            case 5: {
                string = "[] 0 d ";
                break;
            }
            default: {
                string = "[] 0 d ";
            }
        }
        return string;
    }

    public void setupFontInfo(FontInfo fontInfo) {
        FontSetup.setup(fontInfo);
        FontSetup.addToResources(this.pdfDoc, fontInfo);
    }
}

