/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.fop.fonts.FontFileReader;
import org.apache.fop.fonts.Glyphs;
import org.apache.fop.fonts.TTFDirTabEntry;
import org.apache.fop.fonts.TTFMtxEntry;

public class TTFFile {
    static final byte NTABS = 24;
    static final int NMACGLYPHS = 258;
    static final int MAX_CHAR_CODE = 255;
    static final int ENC_BUF_SIZE = 1024;
    boolean is_embeddable = true;
    boolean hasSerifs = true;
    Hashtable dirTabs;
    Hashtable kerningTab;
    int upem;
    int ntabs;
    int nhmtx;
    int post_format;
    int loca_format;
    int nglyphs;
    int nmglyphs;
    int names_count;
    TTFDirTabEntry dir_tab;
    TTFMtxEntry[] mtx_tab;
    int[] mtx_encoded = null;
    boolean reencoded = false;
    String enc_names;
    String fontName = "";
    String fullName = "";
    String notice = "";
    String familyName = "";
    String subFamilyName = "";
    long italicAngle = 0L;
    long isFixedPitch = 0L;
    int fontBBox1 = 0;
    int fontBBox2 = 0;
    int fontBBox3 = 0;
    int fontBBox4 = 0;
    int capHeight = 0;
    int underlinePosition = 0;
    int underlineThickness = 0;
    int xHeight = 0;
    int ascender = 0;
    int descender = 0;

    private void fixWidth() {
        if (this.reencoded) {
            return;
        }
        this.reencoded = true;
        this.nmglyphs = 0;
        this.mtx_encoded = new int[Glyphs.tex8r.length];
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n = 0;
        while (n < this.mtx_tab.length) {
            hashtable.put(this.mtx_tab[n].name, new Integer(this.mtx_tab[n].wx));
            ++n;
        }
        int n2 = 0;
        while (n2 < Glyphs.tex8r.length) {
            ++this.nmglyphs;
            Integer n3 = (Integer)hashtable.get(Glyphs.tex8r[n2]);
            this.mtx_encoded[n2] = n3 == null ? 0 : n3;
            ++n2;
        }
    }

    public int getCapHeight() {
        return this.get_ttf_funit(this.capHeight);
    }

    public String getCharSetName() {
        return "WinAnsi";
    }

    public int getCharWidth(int n) {
        this.fixWidth();
        return this.get_ttf_funit(this.mtx_encoded[n]);
    }

    public short getFirstChar() {
        return 0;
    }

    public int getFlags() {
        int n = 32;
        if (this.italicAngle != 0L) {
            n |= 0x40;
        }
        if (this.isFixedPitch != 0L) {
            n |= 2;
        }
        if (this.hasSerifs) {
            n |= 1;
        }
        return n;
    }

    public int[] getFontBBox() {
        int[] nArray = new int[]{this.get_ttf_funit(this.fontBBox1), this.get_ttf_funit(this.fontBBox2), this.get_ttf_funit(this.fontBBox3), this.get_ttf_funit(this.fontBBox4)};
        return nArray;
    }

    public String getItalicAngle() {
        String string = Short.toString((short)(this.italicAngle / 65536L));
        if (this.italicAngle % 65536L > 0L) {
            string = String.valueOf(string) + "." + Short.toString((short)((short)(this.italicAngle % 65536L * 1000L) / 65536));
        }
        return string;
    }

    public Hashtable getKerning() {
        return this.kerningTab;
    }

    public short getLastChar() {
        this.fixWidth();
        return (short)(this.nmglyphs - 1);
    }

    public int getLowerCaseAscent() {
        return this.get_ttf_funit(this.ascender);
    }

    public int getLowerCaseDescent() {
        return this.get_ttf_funit(this.descender);
    }

    public String getPostscriptName() {
        return this.fontName;
    }

    public String getStemV() {
        return "0";
    }

    public String getWindowsName() {
        return new String(String.valueOf(this.familyName) + "," + this.subFamilyName);
    }

    public int getXHeight() {
        return this.get_ttf_funit(this.xHeight);
    }

    int get_ttf_funit(int n) {
        int n2;
        if (n < 0) {
            long l = n % this.upem;
            long l2 = 1000L * l;
            long l3 = l / l2;
            n2 = -(-1000 * n / this.upem - (int)l3);
        } else {
            n2 = n / this.upem * 1000 + n % this.upem * 1000 / this.upem;
        }
        return n2;
    }

    public boolean isEmbeddable() {
        return this.is_embeddable;
    }

    public static void main(String[] stringArray) {
        try {
            TTFFile tTFFile = new TTFFile();
            FontFileReader fontFileReader = new FontFileReader(stringArray[0]);
            tTFFile.readFont(fontFileReader);
            tTFFile.printStuff();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }

    public void printStuff() {
        System.out.println("Font name: " + this.fontName);
        System.out.println("Full name: " + this.fullName);
        System.out.println("Family name: " + this.familyName);
        System.out.println("Subfamily name: " + this.subFamilyName);
        System.out.println("Notice:    " + this.notice);
        System.out.println("xHeight:   " + this.get_ttf_funit(this.xHeight));
        System.out.println("capheight: " + this.get_ttf_funit(this.capHeight));
        int n = (int)(this.italicAngle >> 16);
        System.out.println("Italic: " + n);
        System.out.print("ItalicAngle: " + (short)(this.italicAngle / 65536L));
        if (this.italicAngle % 65536L > 0L) {
            System.out.print("." + (short)(this.italicAngle % 65536L * 1000L) / 65536);
        }
        System.out.println();
        System.out.println("Ascender:    " + this.get_ttf_funit(this.ascender));
        System.out.println("Descender:   " + this.get_ttf_funit(this.descender));
        System.out.println("FontBBox:    [" + this.get_ttf_funit(this.fontBBox1) + " " + this.get_ttf_funit(this.fontBBox2) + " " + this.get_ttf_funit(this.fontBBox3) + " " + this.get_ttf_funit(this.fontBBox4) + "]");
    }

    public void readFont(FontFileReader fontFileReader) throws IOException {
        int n;
        long l;
        int n2;
        fontFileReader.skip(4L);
        this.ntabs = fontFileReader.readTTFUShort();
        fontFileReader.skip(6L);
        this.dirTabs = new Hashtable();
        TTFDirTabEntry[] tTFDirTabEntryArray = new TTFDirTabEntry[this.ntabs];
        int n3 = 0;
        while (n3 < this.ntabs) {
            tTFDirTabEntryArray[n3] = new TTFDirTabEntry();
            this.dirTabs.put(tTFDirTabEntryArray[n3].read(fontFileReader), tTFDirTabEntryArray[n3]);
            ++n3;
        }
        this.seek_tab(fontFileReader, "head", 18L);
        this.upem = fontFileReader.readTTFUShort();
        fontFileReader.skip(16L);
        this.fontBBox1 = fontFileReader.readTTFShort();
        this.fontBBox2 = fontFileReader.readTTFShort();
        this.fontBBox3 = fontFileReader.readTTFShort();
        this.fontBBox4 = fontFileReader.readTTFShort();
        fontFileReader.skip(6L);
        this.loca_format = fontFileReader.readTTFShort();
        this.seek_tab(fontFileReader, "maxp", 4L);
        this.nglyphs = fontFileReader.readTTFUShort();
        this.mtx_tab = new TTFMtxEntry[this.nglyphs];
        n3 = 0;
        while (n3 < this.nglyphs) {
            this.mtx_tab[n3] = new TTFMtxEntry();
            ++n3;
        }
        this.seek_tab(fontFileReader, "hhea", 4L);
        this.ascender = fontFileReader.readTTFShort();
        this.descender = fontFileReader.readTTFShort();
        fontFileReader.skip(26L);
        this.nhmtx = fontFileReader.readTTFUShort();
        this.seek_tab(fontFileReader, "hmtx", 0L);
        n3 = 0;
        while (n3 < this.nhmtx) {
            this.mtx_tab[n3].wx = fontFileReader.readTTFUShort();
            fontFileReader.skip(2L);
            ++n3;
        }
        this.seek_tab(fontFileReader, "post", 0L);
        this.post_format = fontFileReader.readTTFLong();
        this.italicAngle = fontFileReader.readTTFULong();
        this.underlinePosition = fontFileReader.readTTFShort();
        this.underlineThickness = fontFileReader.readTTFShort();
        this.isFixedPitch = fontFileReader.readTTFULong();
        fontFileReader.skip(16L);
        switch (this.post_format) {
            case 65536: {
                n3 = 0;
                while (n3 < Glyphs.mac_glyph_names.length) {
                    this.mtx_tab[n3].name = Glyphs.mac_glyph_names[n3];
                    ++n3;
                }
                break;
            }
            case 131072: {
                String[] stringArray;
                n2 = fontFileReader.readTTFUShort();
                n3 = 0;
                while (n3 < n2) {
                    this.mtx_tab[n3].index = fontFileReader.readTTFUShort();
                    ++n3;
                }
                TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("post");
                if (tTFDirTabEntry == null) {
                    System.out.println("Can't find table 'post'");
                }
                int n4 = (stringArray = new String[(int)(l = tTFDirTabEntry.length - ((long)fontFileReader.getCurrentPos() - tTFDirTabEntry.offset))]).length < this.nglyphs ? stringArray.length : this.nglyphs;
                n3 = 0;
                while (n3 < n4) {
                    stringArray[n3] = fontFileReader.readTTFString(fontFileReader.readTTFUByte());
                    ++n3;
                }
                n3 = 0;
                while (n3 < n2) {
                    if (this.mtx_tab[n3].index < 258) {
                        this.mtx_tab[n3].name = Glyphs.mac_glyph_names[this.mtx_tab[n3].index];
                    } else {
                        n = this.mtx_tab[n3].index - 258;
                        this.mtx_tab[n3].name = stringArray[n];
                    }
                    ++n3;
                }
                break;
            }
        }
        if (this.dirTabs.get("OS/2") != null) {
            this.seek_tab(fontFileReader, "OS/2", 8L);
            int n5 = fontFileReader.readTTFUShort();
            this.is_embeddable = (n5 & 2) != 0;
        } else {
            this.is_embeddable = true;
        }
        this.seek_tab(fontFileReader, "loca", 0L);
        n3 = 0;
        while (n3 < this.nglyphs) {
            this.mtx_tab[n3].offset = this.loca_format == 1 ? fontFileReader.readTTFULong() : (long)(fontFileReader.readTTFUShort() << 1);
            ++n3;
        }
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("glyf");
        n3 = 0;
        while (n3 < this.nglyphs - 1) {
            if (this.mtx_tab[n3].offset != this.mtx_tab[n3 + 1].offset) {
                fontFileReader.seek_set(tTFDirTabEntry.offset + this.mtx_tab[n3].offset);
                fontFileReader.skip(2L);
                this.mtx_tab[n3].bbox[0] = fontFileReader.readTTFShort();
                this.mtx_tab[n3].bbox[1] = fontFileReader.readTTFShort();
                this.mtx_tab[n3].bbox[2] = fontFileReader.readTTFShort();
                this.mtx_tab[n3].bbox[3] = fontFileReader.readTTFShort();
            } else {
                this.mtx_tab[n3].bbox[0] = this.mtx_tab[0].bbox[0];
                this.mtx_tab[n3].bbox[1] = this.mtx_tab[0].bbox[1];
                this.mtx_tab[n3].bbox[2] = this.mtx_tab[0].bbox[2];
                this.mtx_tab[n3].bbox[3] = this.mtx_tab[0].bbox[3];
            }
            ++n3;
        }
        l = ((TTFDirTabEntry)this.dirTabs.get((Object)"glyf")).offset;
        n3 = 0;
        while (n3 < this.nglyphs) {
            if (n3 + 1 >= this.mtx_tab.length || this.mtx_tab[n3].offset != this.mtx_tab[n3 + 1].offset) {
                fontFileReader.seek_set(l + this.mtx_tab[n3].offset);
                fontFileReader.skip(2L);
                this.mtx_tab[n3].bbox[0] = fontFileReader.readTTFShort();
                this.mtx_tab[n3].bbox[1] = fontFileReader.readTTFShort();
                this.mtx_tab[n3].bbox[2] = fontFileReader.readTTFShort();
                this.mtx_tab[n3].bbox[3] = fontFileReader.readTTFShort();
            } else {
                this.mtx_tab[n3].bbox[0] = this.mtx_tab[0].bbox[0];
                this.mtx_tab[n3].bbox[1] = this.mtx_tab[0].bbox[0];
                this.mtx_tab[n3].bbox[2] = this.mtx_tab[0].bbox[0];
                this.mtx_tab[n3].bbox[3] = this.mtx_tab[0].bbox[0];
            }
            ++n3;
        }
        this.seek_tab(fontFileReader, "name", 2L);
        n3 = fontFileReader.getCurrentPos();
        l = fontFileReader.readTTFUShort();
        int n6 = fontFileReader.readTTFUShort() + n3 - 2;
        n3 += 4;
        while (l-- > 0L) {
            fontFileReader.seek_set(n3);
            int n7 = fontFileReader.readTTFUShort();
            int n8 = fontFileReader.readTTFUShort();
            int n9 = fontFileReader.readTTFUShort();
            n = fontFileReader.readTTFUShort();
            n2 = fontFileReader.readTTFUShort();
            if (n7 == 1 && n8 == 0 && (n == 1 || n == 2 || n == 0 || n == 4 || n == 6)) {
                fontFileReader.seek_set(n6 + fontFileReader.readTTFUShort());
                String string = fontFileReader.readTTFString(n2);
                switch (n) {
                    case 0: {
                        this.notice = string;
                        break;
                    }
                    case 1: {
                        this.familyName = string;
                        break;
                    }
                    case 2: {
                        this.subFamilyName = string;
                        break;
                    }
                    case 4: {
                        this.fullName = string;
                        break;
                    }
                    case 6: {
                        this.fontName = string;
                        break;
                    }
                }
                if (!this.notice.equals("") && !this.fullName.equals("") && !this.fontName.equals("") && !this.familyName.equals("") && !this.subFamilyName.equals("")) break;
            }
            n3 += 12;
        }
        tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("PCLT");
        if (tTFDirTabEntry != null) {
            fontFileReader.seek_set(tTFDirTabEntry.offset + 4L + 4L + 2L);
            this.xHeight = fontFileReader.readTTFUShort();
            fontFileReader.skip(4L);
            this.capHeight = fontFileReader.readTTFUShort();
            fontFileReader.skip(34L);
            int n10 = fontFileReader.readTTFUByte();
            n10 >>= 6;
            this.hasSerifs = (n10 &= 3) != 1;
        } else {
            n3 = 0;
            while (n3 < this.mtx_tab.length) {
                if ("H".equals(this.mtx_tab[n3].name)) {
                    this.capHeight = this.mtx_tab[n3].bbox[3] - this.mtx_tab[n3].bbox[1];
                }
                ++n3;
            }
        }
        this.kerningTab = new Hashtable();
        tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get("kern");
        if (tTFDirTabEntry != null) {
            this.seek_tab(fontFileReader, "kern", 2L);
            l = fontFileReader.readTTFUShort();
            while (l > 0L) {
                fontFileReader.skip(4L);
                n = fontFileReader.readTTFUShort();
                if ((n & 1) == 0 || (n & 2) != 0 || (n & 4) != 0) {
                    return;
                }
                if (n >> 8 == 0) {
                    n = fontFileReader.readTTFUShort();
                    fontFileReader.skip(6L);
                    while (n-- > 0) {
                        n3 = fontFileReader.readTTFUShort();
                        n6 = fontFileReader.readTTFUShort();
                        short s = fontFileReader.readTTFShort();
                        if (s == 0) continue;
                        Hashtable<String, Integer> hashtable = (Hashtable<String, Integer>)this.kerningTab.get(this.mtx_tab[n3].name);
                        if (hashtable == null) {
                            hashtable = new Hashtable<String, Integer>();
                        }
                        hashtable.put(this.mtx_tab[n6].name, new Integer(this.get_ttf_funit(s)));
                        this.kerningTab.put(this.mtx_tab[n3].name, hashtable);
                    }
                }
                --l;
            }
        }
    }

    void seek_tab(FontFileReader fontFileReader, String string, long l) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = (TTFDirTabEntry)this.dirTabs.get(string);
        if (tTFDirTabEntry == null) {
            System.out.println("Dirtab " + string + " not found.");
            return;
        }
        fontFileReader.seek_set(tTFDirTabEntry.offset + l);
    }
}

