/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.SimplePageMaster;

public class LayoutMasterSet
extends FObj {
    private Hashtable simplePageMasters;
    private Hashtable pageSequenceMasters;
    private Hashtable allRegions;
    private Root root;

    protected LayoutMasterSet(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:layout-master-set";
        this.simplePageMasters = new Hashtable();
        this.pageSequenceMasters = new Hashtable();
        if (!fObj.getName().equals("fo:root")) {
            throw new FOPException("fo:layout-master-set must be child of fo:root, not " + fObj.getName());
        }
        this.root = (Root)fObj;
        this.root.setLayoutMasterSet(this);
        this.allRegions = new Hashtable();
    }

    protected void addPageSequenceMaster(String string, PageSequenceMaster pageSequenceMaster) throws FOPException {
        if (this.existsName(string)) {
            throw new FOPException("'master-name' (" + string + ") must be unique " + "across page-masters and page-sequence-masters");
        }
        this.pageSequenceMasters.put(string, pageSequenceMaster);
    }

    protected void addSimplePageMaster(SimplePageMaster simplePageMaster) throws FOPException {
        if (this.existsName(simplePageMaster.getMasterName())) {
            throw new FOPException("'master-name' (" + simplePageMaster.getMasterName() + ") must be unique " + "across page-masters and page-sequence-masters");
        }
        this.simplePageMasters.put(simplePageMaster.getMasterName(), simplePageMaster);
    }

    protected void checkRegionNames() throws FOPException {
        Enumeration enumeration = this.simplePageMasters.elements();
        while (enumeration.hasMoreElements()) {
            SimplePageMaster simplePageMaster = (SimplePageMaster)enumeration.nextElement();
            Hashtable hashtable = simplePageMaster.getRegions();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                String string;
                Region region = (Region)enumeration2.nextElement();
                if (this.allRegions.containsKey(region.getRegionName()) && !(string = (String)this.allRegions.get(region.getRegionName())).equals(region.getRegionClass())) {
                    throw new FOPException("Duplicate region-names (" + region.getRegionName() + ") must map " + "to the same region-class (" + string + "!=" + region.getRegionClass() + ")");
                }
                this.allRegions.put(region.getRegionName(), region.getRegionClass());
            }
        }
    }

    private boolean existsName(String string) {
        return this.simplePageMasters.containsKey(string) || this.pageSequenceMasters.containsKey(string);
    }

    protected PageSequenceMaster getPageSequenceMaster(String string) {
        return (PageSequenceMaster)this.pageSequenceMasters.get(string);
    }

    protected SimplePageMaster getSimplePageMaster(String string) {
        return (SimplePageMaster)this.simplePageMasters.get(string);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected boolean regionNameExists(String string) {
        boolean bl = false;
        Enumeration enumeration = this.simplePageMasters.elements();
        while (enumeration.hasMoreElements()) {
            bl = ((SimplePageMaster)enumeration.nextElement()).regionNameExists(string);
            if (!bl) continue;
            return bl;
        }
        return bl;
    }

    protected void resetPageMasters() {
        Enumeration enumeration = this.pageSequenceMasters.elements();
        while (enumeration.hasMoreElements()) {
            ((PageSequenceMaster)enumeration.nextElement()).reset();
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new LayoutMasterSet(fObj, propertyList);
        }
    }
}

