/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.dom.svg;

import org.apache.fop.dom.svg.SVGExceptionImpl;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;

public class SVGMatrixImpl
implements SVGMatrix {
    float a = 1.0f;
    float b = 0.0f;
    float c = 0.0f;
    float d = 1.0f;
    float e = 0.0f;
    float f = 0.0f;

    public SVGMatrix flipX() {
        return null;
    }

    public SVGMatrix flipY() {
        return null;
    }

    public float getA() {
        return this.a;
    }

    public float getB() {
        return this.b;
    }

    public float getC() {
        return this.c;
    }

    public float getD() {
        return this.d;
    }

    public float getE() {
        return this.e;
    }

    public float getF() {
        return this.f;
    }

    public SVGMatrix inverse() throws SVGException {
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl();
        double d = Math.abs(this.a * this.d - this.b * this.c);
        if (d == 0.0) {
            throw new SVGExceptionImpl(2, "Matrix: " + this.toString() + " could not be inverted");
        }
        sVGMatrixImpl.setA((float)((double)this.d / d));
        sVGMatrixImpl.setB((float)((double)this.b / d));
        sVGMatrixImpl.setC((float)((double)(-this.c) / d));
        sVGMatrixImpl.setD((float)((double)this.a / d));
        sVGMatrixImpl.setE(-this.e);
        sVGMatrixImpl.setF(-this.f);
        return sVGMatrixImpl;
    }

    public SVGMatrix multiply(SVGMatrix sVGMatrix) throws SVGException {
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl();
        sVGMatrixImpl.setA(this.a * sVGMatrix.getA() + this.b * sVGMatrix.getC());
        sVGMatrixImpl.setB(this.a * sVGMatrix.getB() + this.b * sVGMatrix.getD());
        sVGMatrixImpl.setC(this.c * sVGMatrix.getA() + this.d * sVGMatrix.getC());
        sVGMatrixImpl.setD(this.c * sVGMatrix.getB() + this.d * sVGMatrix.getD());
        sVGMatrixImpl.setE(this.a * this.e + this.c * this.f + sVGMatrix.getE());
        sVGMatrixImpl.setF(this.b * this.f + this.d * this.f + sVGMatrix.getF());
        return sVGMatrixImpl;
    }

    public SVGMatrix rotate(float f) throws SVGException {
        f = (float)((double)f * Math.PI / 180.0);
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl();
        sVGMatrixImpl.setA((float)Math.cos(f));
        sVGMatrixImpl.setB((float)Math.sin(f));
        sVGMatrixImpl.setC((float)(-Math.sin(f)));
        sVGMatrixImpl.setD((float)Math.cos(f));
        return this.multiply(sVGMatrixImpl);
    }

    public SVGMatrix rotateFromVector(float f, float f2) throws SVGException {
        return null;
    }

    public SVGMatrix scale(float f) throws SVGException {
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl();
        sVGMatrixImpl.setA(this.a * f);
        sVGMatrixImpl.setB(this.b);
        sVGMatrixImpl.setC(this.c);
        sVGMatrixImpl.setD(this.d * f);
        sVGMatrixImpl.setE(this.e);
        sVGMatrixImpl.setF(this.f);
        return sVGMatrixImpl;
    }

    public SVGMatrix scaleNonUniform(float f, float f2) throws SVGException {
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl();
        sVGMatrixImpl.setA(this.a * f);
        sVGMatrixImpl.setB(this.b);
        sVGMatrixImpl.setC(this.c);
        sVGMatrixImpl.setD(this.d * f2);
        sVGMatrixImpl.setE(this.e);
        sVGMatrixImpl.setF(this.f);
        return sVGMatrixImpl;
    }

    public void setA(float f) {
        this.a = f;
    }

    public void setB(float f) {
        this.b = f;
    }

    public void setC(float f) {
        this.c = f;
    }

    public void setD(float f) {
        this.d = f;
    }

    public void setE(float f) {
        this.e = f;
    }

    public void setF(float f) {
        this.f = f;
    }

    public SVGMatrix skewX(float f) throws SVGException {
        f = (float)((double)f * Math.PI / 180.0);
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl();
        sVGMatrixImpl.setA(1.0f);
        sVGMatrixImpl.setB(0.0f);
        sVGMatrixImpl.setC((float)Math.tan(f));
        sVGMatrixImpl.setD(1.0f);
        return this.multiply(sVGMatrixImpl);
    }

    public SVGMatrix skewY(float f) throws SVGException {
        f = (float)((double)f * Math.PI / 180.0);
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl();
        sVGMatrixImpl.setA(1.0f);
        sVGMatrixImpl.setB((float)Math.tan(f));
        sVGMatrixImpl.setC(0.0f);
        sVGMatrixImpl.setD(1.0f);
        return this.multiply(sVGMatrixImpl);
    }

    public String toString() {
        return "[" + this.getA() + " " + this.getB() + " " + this.getC() + " " + this.getD() + " " + this.getE() + " " + this.getF() + "]";
    }

    public SVGMatrix translate(float f, float f2) throws SVGException {
        SVGMatrixImpl sVGMatrixImpl = new SVGMatrixImpl();
        sVGMatrixImpl.setA(this.a);
        sVGMatrixImpl.setB(this.b);
        sVGMatrixImpl.setC(this.c);
        sVGMatrixImpl.setD(this.d);
        sVGMatrixImpl.setE(this.e + f);
        sVGMatrixImpl.setF(this.f + f2);
        return sVGMatrixImpl;
    }
}

