/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.dom.svg;

import org.apache.fop.dom.ElementImpl;
import org.apache.fop.dom.css.CSSStyleRuleImpl;
import org.apache.fop.dom.svg.SVGAnimatedStringImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGStylable;

public abstract class SVGElementImpl
extends ElementImpl
implements SVGElement {
    String idString = "";
    CSSStyleDeclaration styleDec;
    SVGSVGElement ownerSvg;
    SVGAnimatedString className = new SVGAnimatedStringImpl("");

    public Node appendChild(Node node) throws DOMException {
        Node node2 = super.appendChild(node);
        if (node instanceof SVGElementImpl) {
            SVGElementImpl sVGElementImpl = (SVGElementImpl)node;
            if (this.ownerSvg != null) {
                sVGElementImpl.setOwnerSVG(this.ownerSvg);
            }
        }
        return node2;
    }

    public CSSValue getAnimatedPresentationAttribute(String string) {
        return this.getPresentationAttribute(string);
    }

    public SVGAnimatedString getClassName() {
        return this.className;
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return null;
    }

    public String getId() {
        return this.idString;
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    public SVGSVGElement getOwnerSVGElement() {
        return this.ownerSvg;
    }

    public CSSValue getPresentationAttribute(String string) {
        Object object;
        CSSValue cSSValue = null;
        CSSStyleDeclaration cSSStyleDeclaration = this.getStyle();
        if (cSSStyleDeclaration != null) {
            cSSValue = cSSStyleDeclaration.getPropertyCSSValue(string);
        }
        if (cSSValue == null) {
            object = this.getOwnerSVGElement();
            StyleSheetList styleSheetList = object.getStyleSheets();
            int n = 0;
            while (n < styleSheetList.getLength()) {
                CSSRuleList cSSRuleList = ((CSSStyleSheet)styleSheetList.item(n)).getCssRules();
                int n2 = 0;
                while (n2 < cSSRuleList.getLength()) {
                    CSSRule cSSRule = cSSRuleList.item(n2);
                    if (cSSRule.getType() == 1 && ((CSSStyleRuleImpl)cSSRule).matches(this)) {
                        cSSStyleDeclaration = ((CSSStyleRule)cSSRule).getStyle();
                        cSSValue = cSSStyleDeclaration.getPropertyCSSValue(string);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        if (cSSValue == null && (object = this.getParentNode()) instanceof SVGStylable) {
            cSSValue = ((SVGStylable)object).getPresentationAttribute(string);
        }
        return cSSValue;
    }

    public CSSStyleDeclaration getStyle() {
        return this.styleDec;
    }

    public SVGElement getViewportElement() {
        return null;
    }

    public void setClassName(SVGAnimatedString sVGAnimatedString) {
        this.className = sVGAnimatedString;
    }

    public void setExternalResourcesRequired(SVGAnimatedBoolean sVGAnimatedBoolean) {
    }

    public void setId(String string) {
        this.idString = string;
    }

    public void setOwnerSVG(SVGSVGElement sVGSVGElement) {
        this.ownerSvg = sVGSVGElement;
        NodeList nodeList = this.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof SVGElementImpl) {
                ((SVGElementImpl)node).setOwnerSVG(sVGSVGElement);
            }
            ++n;
        }
    }

    public void setStyle(CSSStyleDeclaration cSSStyleDeclaration) {
        this.styleDec = cSSStyleDeclaration;
    }
}

