/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class CommandlineJava
implements Cloneable {
    private Commandline vmCommand = new Commandline();
    private Commandline javaCommand = new Commandline();
    private SysProperties sysProperties = new SysProperties();
    private Path classpath = null;
    private String vmVersion;

    public CommandlineJava() {
        this.setVm("java");
        this.setVmversion(Project.getJavaVersion());
    }

    public Commandline.Argument createArgument() {
        return this.javaCommand.createArgument();
    }

    public Commandline.Argument createVmArgument() {
        return this.vmCommand.createArgument();
    }

    public void addSysproperty(Environment.Variable variable) {
        this.sysProperties.addVariable(variable);
    }

    public void setVm(String string) {
        this.vmCommand.setExecutable(string);
    }

    public void setVmversion(String string) {
        this.vmVersion = string;
    }

    public void setClassname(String string) {
        this.javaCommand.setExecutable(string);
    }

    public String getClassname() {
        return this.javaCommand.getExecutable();
    }

    public Path createClasspath(Project project) {
        if (this.classpath == null) {
            this.classpath = new Path(project);
        }
        return this.classpath;
    }

    public String getVmversion() {
        return this.vmVersion;
    }

    public String[] getCommandline() {
        Path path = this.classpath != null ? this.classpath.concatSystemClasspath("ignore") : null;
        int n = this.vmCommand.size() + this.javaCommand.size() + this.sysProperties.size();
        if (path != null && path.size() > 0) {
            n += 2;
        }
        String[] stringArray = new String[n];
        System.arraycopy(this.vmCommand.getCommandline(), 0, stringArray, 0, this.vmCommand.size());
        int n2 = this.vmCommand.size();
        if (this.sysProperties.size() > 0) {
            System.arraycopy(this.sysProperties.getVariables(), 0, stringArray, n2, this.sysProperties.size());
            n2 += this.sysProperties.size();
        }
        if (path != null && path.toString().trim().length() > 0) {
            stringArray[n2++] = "-classpath";
            stringArray[n2++] = path.toString();
        }
        System.arraycopy(this.javaCommand.getCommandline(), 0, stringArray, n2, this.javaCommand.size());
        return stringArray;
    }

    public String toString() {
        return Commandline.toString(this.getCommandline());
    }

    public int size() {
        int n = this.vmCommand.size() + this.javaCommand.size();
        if (this.classpath != null && this.classpath.size() > 0) {
            n += 2;
        }
        return n;
    }

    public Commandline getJavaCommand() {
        return this.javaCommand;
    }

    public Commandline getVmCommand() {
        return this.vmCommand;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setSystemProperties() throws BuildException {
        this.sysProperties.setSystem();
    }

    public void restoreSystemProperties() throws BuildException {
        this.sysProperties.restoreSystem();
    }

    public SysProperties getSystemProperties() {
        return this.sysProperties;
    }

    public Object clone() {
        CommandlineJava commandlineJava = new CommandlineJava();
        commandlineJava.vmCommand = (Commandline)this.vmCommand.clone();
        commandlineJava.javaCommand = (Commandline)this.javaCommand.clone();
        commandlineJava.sysProperties = (SysProperties)this.sysProperties.clone();
        if (this.classpath != null) {
            commandlineJava.classpath = (Path)this.classpath.clone();
        }
        commandlineJava.vmVersion = this.vmVersion;
        return commandlineJava;
    }

    public void clearJavaArgs() {
        this.javaCommand.clearArgs();
    }

    public static class SysProperties
    extends Environment
    implements Cloneable {
        Properties sys = null;

        public String[] getVariables() throws BuildException {
            String[] stringArray = super.getVariables();
            if (stringArray == null) {
                return null;
            }
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = "-D" + stringArray[n];
                ++n;
            }
            return stringArray;
        }

        public int size() {
            return this.variables.size();
        }

        public void setSystem() throws BuildException {
            try {
                this.sys = System.getProperties();
                Properties properties = new Properties(this.sys);
                Enumeration enumeration = this.variables.elements();
                while (enumeration.hasMoreElements()) {
                    Environment.Variable variable = (Environment.Variable)enumeration.nextElement();
                    ((Hashtable)properties).put(variable.getKey(), variable.getValue());
                }
                System.setProperties(properties);
            }
            catch (SecurityException securityException) {
                throw new BuildException("Cannot modify system properties", securityException);
            }
        }

        public void restoreSystem() throws BuildException {
            if (this.sys == null) {
                throw new BuildException("Unbalanced nesting of SysProperties");
            }
            try {
                System.setProperties(this.sys);
                this.sys = null;
            }
            catch (SecurityException securityException) {
                throw new BuildException("Cannot modify system properties", securityException);
            }
        }

        public Object clone() {
            try {
                SysProperties sysProperties = (SysProperties)super.clone();
                sysProperties.variables = (Vector)this.variables.clone();
                return sysProperties;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

