/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecuteOn;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Transform
extends ExecuteOn {
    protected Commandline.Marker targetFilePos = null;
    protected Mapper mapperElement = null;
    protected FileNameMapper mapper = null;
    protected File destDir = null;
    protected boolean srcIsFirst = true;

    public void setDest(File file) {
        this.destDir = file;
    }

    public Commandline.Marker createTargetfile() {
        if (this.targetFilePos != null) {
            throw new BuildException(this.taskType + " doesn't support multiple targetfile elements.", this.location);
        }
        this.targetFilePos = this.cmdl.createMarker();
        this.srcIsFirst = this.srcFilePos != null;
        return this.targetFilePos;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.location);
        }
        this.mapperElement = new Mapper(this.project);
        return this.mapperElement;
    }

    protected void checkConfiguration() {
        super.checkConfiguration();
        if (this.mapperElement == null) {
            throw new BuildException("no mapper specified", this.location);
        }
        if (this.destDir == null) {
            throw new BuildException("no dest attribute specified", this.location);
        }
        this.mapper = this.mapperElement.getImplementation();
    }

    protected String[] getFiles(File file, DirectoryScanner directoryScanner) {
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        return sourceFileScanner.restrict(directoryScanner.getIncludedFiles(), file, this.destDir, this.mapper);
    }

    protected String[] getDirs(File file, DirectoryScanner directoryScanner) {
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        return sourceFileScanner.restrict(directoryScanner.getIncludedDirectories(), file, this.destDir, this.mapper);
    }

    protected String[] getCommandline(String[] stringArray, File file) {
        int n;
        Object object;
        Object[] objectArray;
        if (this.targetFilePos == null) {
            return super.getCommandline(stringArray, file);
        }
        Vector<String[]> vector = new Vector<String[]>();
        Hashtable<String[], String[]> hashtable = new Hashtable<String[], String[]>();
        int n2 = 0;
        while (n2 < stringArray.length) {
            objectArray = this.mapper.mapFileName(stringArray[n2]);
            if (objectArray != null) {
                int n3 = 0;
                while (n3 < objectArray.length) {
                    object = new File(this.destDir, (String)objectArray[n3]).getAbsolutePath();
                    if (!hashtable.contains(object)) {
                        vector.addElement((String[])object);
                        hashtable.put((String[])object, (String[])object);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        String[] stringArray2 = this.cmdl.getCommandline();
        object = new String[stringArray2.length + stringArray.length + objectArray.length];
        int n4 = stringArray2.length;
        if (this.srcFilePos != null) {
            n4 = this.srcFilePos.getPosition();
        }
        if (n4 < (n = this.targetFilePos.getPosition()) || n4 == n && this.srcIsFirst) {
            System.arraycopy(stringArray2, 0, object, 0, n4);
            System.arraycopy(stringArray2, n4, object, n4 + stringArray.length, n - n4);
            System.arraycopy(objectArray, 0, object, n + stringArray.length, objectArray.length);
            System.arraycopy(stringArray2, n, object, n + stringArray.length + objectArray.length, stringArray2.length - n);
        } else {
            System.arraycopy(stringArray2, 0, object, 0, n);
            System.arraycopy(objectArray, 0, object, n, objectArray.length);
            System.arraycopy(stringArray2, n, object, n + objectArray.length, n4 - n);
            System.arraycopy(stringArray2, n4, object, n4 + stringArray.length + objectArray.length, stringArray2.length - n4);
            n4 += objectArray.length;
        }
        int n5 = 0;
        while (n5 < stringArray.length) {
            object[n4 + n5] = new File(file, stringArray[n5]).getAbsolutePath();
            ++n5;
        }
        return object;
    }

    protected String[] getCommandline(String string, File file) {
        return this.getCommandline(new String[]{string}, file);
    }
}

