/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.component;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.Disposable;
import org.apache.avalon.Initializable;
import org.apache.avalon.Poolable;
import org.apache.avalon.Recyclable;
import org.apache.avalon.ThreadSafe;
import org.apache.avalon.util.Lock;
import org.apache.excalibur.pool.ObjectFactory;
import org.apache.excalibur.pool.Pool;

public class DefaultComponentPool
extends AbstractLoggable
implements Pool,
Initializable,
Disposable,
Runnable,
ThreadSafe {
    public static final int DEFAULT_POOL_SIZE = 8;
    protected List m_availableResources = new ArrayList();
    protected List m_usedResources = new ArrayList();
    private Lock m_mutex = new Lock();
    private boolean m_initialized;
    private boolean m_disposed;
    private Thread m_initializationThread;
    protected ObjectFactory m_factory;
    protected int m_initial = 4;
    protected int m_maximum = 8;

    private void init(ObjectFactory objectFactory, int n, int n2) throws Exception {
        this.m_factory = objectFactory;
        this.m_initial = n;
        this.m_maximum = n2;
    }

    public void init() throws Exception {
        this.m_initializationThread = new Thread(this);
        this.m_initializationThread.start();
    }

    public void run() {
        try {
            block7: {
                try {
                    this.m_mutex.lock();
                    int n = 0;
                    while (n < this.m_initial) {
                        try {
                            this.m_availableResources.add(this.m_factory.newInstance());
                        }
                        catch (Exception exception) {
                            this.getLogger().warn("Could not create poolable resource", (Throwable)exception);
                        }
                        ++n;
                    }
                    if (this.m_availableResources.size() <= 0) break block7;
                    this.m_initialized = true;
                }
                catch (Exception exception) {
                    this.getLogger().debug("ComponentPool.run()", (Throwable)exception);
                    Object var2_5 = null;
                    this.m_mutex.unlock();
                }
            }
            Object var2_4 = null;
            this.m_mutex.unlock();
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
    }

    public void dispose() {
        try {
            try {
                this.m_mutex.lock();
                this.m_disposed = true;
                while (!this.m_availableResources.isEmpty()) {
                    this.m_availableResources.remove(0);
                }
            }
            catch (Exception exception) {
                this.getLogger().debug("ComponentPool.dispose()", (Throwable)exception);
                Object var2_2 = null;
                this.m_mutex.unlock();
            }
            Object var2_1 = null;
            this.m_mutex.unlock();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
    }

    protected Poolable getOverflowResource() throws Exception {
        Poolable poolable = (Poolable)this.m_factory.newInstance();
        this.getLogger().debug("Component Pool - creating Overflow Resource: Resource=" + poolable + " Available=" + this.m_availableResources.size() + " Used=" + this.m_usedResources.size());
        return poolable;
    }

    public Poolable get() throws Exception {
        if (!this.m_initialized) {
            if (this.m_initializationThread == null) {
                throw new IllegalStateException("You cannot get a resource before the pool is initialized");
            }
            this.m_initializationThread.join();
            this.m_initializationThread = null;
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot get a resource after the pool is disposed");
        }
        Poolable poolable = null;
        try {
            block9: {
                try {
                    this.m_mutex.lock();
                    if (this.m_availableResources.size() > 0) {
                        poolable = (Poolable)this.m_availableResources.remove(0);
                        this.m_usedResources.add(poolable);
                        break block9;
                    }
                    poolable = this.getOverflowResource();
                    if (poolable == null) break block9;
                    this.m_usedResources.add(poolable);
                }
                catch (Exception exception) {
                    this.getLogger().debug("ComponentPool.get()", (Throwable)exception);
                    Object var3_3 = null;
                    this.m_mutex.unlock();
                }
            }
            Object var3_2 = null;
            this.m_mutex.unlock();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
        if (poolable == null) {
            throw new RuntimeException("Could not get the component from the pool");
        }
        return poolable;
    }

    public void put(Poolable poolable) {
        int n = -1;
        try {
            try {
                this.m_mutex.lock();
                n = this.m_usedResources.indexOf(poolable);
                if (poolable instanceof Recyclable) {
                    ((Recyclable)poolable).recycle();
                }
                if (n >= 0) {
                    this.m_usedResources.remove(n);
                    if (this.m_availableResources.size() < this.m_maximum) {
                        this.m_availableResources.add(poolable);
                    } else {
                        try {
                            this.m_factory.decommission(poolable);
                            this.getLogger().debug("Component Pool - decommissioning Overflow Resource: Resource=" + poolable + " Available=" + this.m_availableResources.size() + " Used=" + this.m_usedResources.size());
                            poolable = null;
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("caught exception decommissioning resource: " + poolable);
                        }
                    }
                }
                Object var4_5 = null;
                this.m_mutex.unlock();
            }
            catch (Exception exception) {
                this.getLogger().debug("ComponentPool.put()", (Throwable)exception);
                Object var4_6 = null;
                this.m_mutex.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
    }

    public DefaultComponentPool(ObjectFactory objectFactory) throws Exception {
        this.init(objectFactory, 4, 8);
    }

    public DefaultComponentPool(ObjectFactory objectFactory, int n) throws Exception {
        this.init(objectFactory, n, n);
    }

    public DefaultComponentPool(ObjectFactory objectFactory, int n, int n2) throws Exception {
        this.init(objectFactory, n, n2);
    }
}

