/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.hsqldb.Channel;
import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.jdbcConnection;

class Function {
    private Channel cChannel;
    private String sFunction;
    private Method mMethod;
    private int iReturnType;
    private int iArgCount;
    private int[] iArgType;
    private boolean[] bArgNullable;
    private Object[] oArg;
    private Expression[] eArg;
    private boolean bConnection;

    Function(String string, Channel channel) throws SQLException {
        GenericDeclaration genericDeclaration;
        this.cChannel = channel;
        this.sFunction = string;
        int n = string.lastIndexOf(46);
        Trace.check(n != -1, 10, string);
        String string2 = string.substring(0, n);
        channel.check("CLASS \"" + string2 + "\"", 15);
        String string3 = string.substring(n + 1);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (Exception exception) {
            throw Trace.error(40, String.valueOf(string2) + " " + exception);
        }
        Method[] methodArray = clazz.getMethods();
        n = 0;
        while (n < methodArray.length) {
            genericDeclaration = methodArray[n];
            if (((Method)genericDeclaration).getName().equals(string3)) {
                Trace.check(this.mMethod == null, 12, string3);
                this.mMethod = genericDeclaration;
            }
            ++n;
        }
        Trace.check(this.mMethod != null, 12, string3);
        genericDeclaration = this.mMethod.getReturnType();
        this.iReturnType = Column.getTypeNr(((Class)genericDeclaration).getName());
        Class<?>[] classArray = this.mMethod.getParameterTypes();
        this.iArgCount = classArray.length;
        this.iArgType = new int[this.iArgCount];
        this.bArgNullable = new boolean[this.iArgCount];
        n = 0;
        while (n < classArray.length) {
            Class<?> clazz2 = classArray[n];
            String string4 = clazz2.getName();
            if (n == 0 && string4.equals("java.sql.Connection")) {
                this.bConnection = true;
            } else {
                if (string4.equals("[B")) {
                    string4 = "byte[]";
                }
                this.iArgType[n] = Column.getTypeNr(string4);
                this.bArgNullable[n] = clazz2.isPrimitive() ^ true;
            }
            ++n;
        }
        this.eArg = new Expression[this.iArgCount];
        this.oArg = new Object[this.iArgCount];
    }

    void checkResolved() throws SQLException {
        int n = 0;
        while (n < this.iArgCount) {
            if (this.eArg[n] != null) {
                this.eArg[n].checkResolved();
            }
            ++n;
        }
    }

    int getArgCount() {
        return this.iArgCount - (this.bConnection ? 1 : 0);
    }

    int getArgType(int n) {
        return this.iArgType[n];
    }

    int getReturnType() {
        return this.iReturnType;
    }

    Object getValue() throws SQLException {
        Object object;
        int n = 0;
        if (this.bConnection) {
            this.oArg[n] = new jdbcConnection(this.cChannel);
            ++n;
        }
        while (n < this.iArgCount) {
            Expression expression = this.eArg[n];
            object = null;
            if (expression != null) {
                object = expression.getValue(this.iArgType[n]);
            }
            if (object == null && !this.bArgNullable[n]) {
                return null;
            }
            this.oArg[n] = object;
            ++n;
        }
        try {
            return this.mMethod.invoke(null, this.oArg);
        }
        catch (Exception exception) {
            object = String.valueOf(this.sFunction) + ": " + exception.toString();
            throw Trace.getError(19, (String)object);
        }
    }

    void resolve(TableFilter tableFilter) throws SQLException {
        int n = 0;
        while (n < this.iArgCount) {
            if (this.eArg[n] != null) {
                this.eArg[n].resolve(tableFilter);
            }
            ++n;
        }
    }

    void setArgument(int n, Expression expression) {
        if (this.bConnection) {
            ++n;
        }
        this.eArg[n] = expression;
    }
}

