/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeObject
extends ScriptableObject {
    public static void finishInit(Scriptable scriptable, FunctionObject functionObject, Scriptable scriptable2) {
        Object object = scriptable2.get("valueOf", scriptable2);
        ((FunctionObject)object).setLength((short)0);
    }

    public String getClassName() {
        return "Object";
    }

    public static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) throws JavaScriptException {
        if (!bl) {
            return function.construct(context, function.getParentScope(), objectArray);
        }
        if (objectArray.length == 0 || objectArray[0] == null || objectArray[0] == Undefined.instance) {
            return new NativeObject();
        }
        return ScriptRuntime.toObject(function.getParentScope(), objectArray[0]);
    }

    public static String jsFunction_toString(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (context.getLanguageVersion() != 120) {
            return "[object " + scriptable.getClassName() + "]";
        }
        return NativeObject.toSource(context, scriptable, objectArray, function);
    }

    public static Object jsFunction_valueOf(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return scriptable;
    }

    public static String toSource(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Scriptable scriptable2 = scriptable;
        if (context.iterating == null) {
            context.iterating = new Hashtable(31);
        }
        if (context.iterating.get(scriptable2) == Boolean.TRUE) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        Object[] objectArray2 = scriptable2.getIds();
        int n = 0;
        while (n < objectArray2.length) {
            Object object;
            if (n > 0) {
                stringBuffer.append(", ");
            }
            Object object2 = objectArray2[n];
            String string = ScriptRuntime.toString(object2);
            Object object3 = object = object2 instanceof String ? scriptable2.get((String)object2, scriptable2) : scriptable2.get(((Number)object2).intValue(), scriptable2);
            if (object instanceof String) {
                stringBuffer.append(String.valueOf(string) + ":\"" + ScriptRuntime.escapeString(ScriptRuntime.toString(object)) + "\"");
            } else {
                try {
                    context.iterating.put(scriptable2, Boolean.TRUE);
                    stringBuffer.append(String.valueOf(string) + ":" + ScriptRuntime.toString(object));
                }
                finally {
                    Object var12_11 = null;
                    context.iterating.remove(scriptable2);
                }
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String toString() {
        Context context = Context.getContext();
        if (context != null) {
            return NativeObject.jsFunction_toString(context, this, null, null);
        }
        return "[object " + this.getClassName() + "]";
    }
}

