/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db.pool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public abstract class DB {
    protected String DB_USER;
    protected String DB_PASS;
    protected String DB_CONNECTION;
    private String JDBCDriver = null;

    protected DB() {
    }

    public Connection getConnection() throws SQLException {
        try {
            return DriverManager.getConnection(this.DB_CONNECTION, this.DB_USER, this.DB_PASS);
        }
        catch (ClassCircularityError classCircularityError) {
            return DriverManager.getConnection(this.DB_CONNECTION, this.DB_USER, this.DB_PASS);
        }
    }

    public abstract String getIdSqlForAutoIncrement();

    public String getJDBCDriver() {
        return this.JDBCDriver;
    }

    public abstract String getSequenceSql(Object var1);

    public abstract char getStringDelimiter();

    public abstract String ignoreCase(String var1);

    public String ignoreCaseInOrderBy(String in) {
        return this.ignoreCase(in);
    }

    public void init(String url, String username, String password) throws Exception {
        this.DB_USER = username;
        this.DB_PASS = password;
        this.DB_CONNECTION = url;
        if (this.JDBCDriver == null) {
            throw new Exception("The JDBC driver must be set for the DB object with a URL of " + url);
        }
        Class.forName(this.JDBCDriver).newInstance();
    }

    public abstract void lockTable(Connection var1, String var2) throws SQLException;

    public boolean objectDataNeedsTrans() {
        return false;
    }

    public void setJDBCDriver(String newDriver) {
        this.JDBCDriver = newDriver;
    }

    public abstract String toUpperCase(String var1);

    public abstract void unlockTable(Connection var1, String var2) throws SQLException;
}

